/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class ByteCodec
extends AbstractPrimitiveCodec<Byte> {
    ByteCodec(ByteBufAllocator allocator) {
        super(allocator, Byte.TYPE, Byte.class);
    }

    @Override
    public Byte decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return (byte)IntegerCodec.decodeInt(value, binary, metadata.getType());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Byte;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new ByteParameter(this.allocator, (Byte)value);
    }

    @Override
    public boolean canPrimitiveDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    static final class ByteParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final byte value;

        ByteParameter(ByteBufAllocator allocator, byte value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> this.allocator.buffer(1).writeByte((int)this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TINYINT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteParameter)) {
                return false;
            }
            ByteParameter byteValue = (ByteParameter)o;
            return this.value == byteValue.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

