/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractLobParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.MassiveCodec;
import dev.miku.r2dbc.mysql.codec.lob.LobUtils;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.r2dbc.spi.Blob;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class BlobCodec
implements MassiveCodec<Blob> {
    private static final int MAX_MERGE = 16384;
    private final ByteBufAllocator allocator;

    BlobCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public Blob decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return LobUtils.createBlob(value);
    }

    @Override
    public Blob decodeMassive(List<ByteBuf> value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return LobUtils.createBlob(value);
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        MySqlType type = metadata.getType();
        return (type.isLob() || type == MySqlType.GEOMETRY) && target.isAssignableFrom(Blob.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Blob;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new BlobParameter(this.allocator, (Blob)value);
    }

    static List<ByteBuf> toList(List<ByteBuf> buffers) {
        switch (buffers.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(buffers.get(0));
            }
        }
        return buffers;
    }

    static void releaseAll(List<ByteBuf> buffers, ByteBuf lastBuf) {
        boolean nonLast = true;
        for (ByteBuf buf : buffers) {
            ReferenceCountUtil.safeRelease((Object)buf);
            if (buf != lastBuf) continue;
            nonLast = false;
        }
        if (nonLast) {
            lastBuf.release();
        }
    }

    private static final class BlobParameter
    extends AbstractLobParameter {
        private final ByteBufAllocator allocator;
        private final AtomicReference<Blob> blob;

        private BlobParameter(ByteBufAllocator allocator, Blob blob) {
            this.allocator = allocator;
            this.blob = new AtomicReference<Blob>(blob);
        }

        public Flux<ByteBuf> publishBinary() {
            return Flux.defer(() -> {
                Blob blob = this.blob.getAndSet(null);
                if (blob == null) {
                    return Flux.error((Throwable)new IllegalStateException("Blob has written, can not write twice"));
                }
                return Flux.from((Publisher)blob.stream()).collectList().defaultIfEmpty(Collections.emptyList()).flatMapIterable(list -> {
                    if (list.isEmpty()) {
                        return Collections.singletonList(this.allocator.buffer(1).writeByte(0));
                    }
                    long bytes = 0L;
                    ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
                    ByteBuf lastBuf = this.allocator.buffer();
                    try {
                        ByteBuf firstBuf = lastBuf;
                        buffers.add(firstBuf);
                        VarIntUtils.reserveVarInt(firstBuf);
                        for (ByteBuffer src : list) {
                            if (!src.hasRemaining()) continue;
                            int size = src.remaining();
                            bytes += (long)size;
                            if (size > 16384 - lastBuf.readableBytes()) {
                                lastBuf = this.allocator.buffer();
                                buffers.add(lastBuf);
                            }
                            lastBuf.writeBytes(src);
                        }
                        VarIntUtils.setReservedVarInt(firstBuf, bytes);
                        return BlobCodec.toList(buffers);
                    }
                    catch (Throwable e) {
                        BlobCodec.releaseAll(buffers, lastBuf);
                        throw e;
                    }
                });
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.defer(() -> {
                Blob blob = this.blob.getAndSet(null);
                if (blob == null) {
                    return Mono.error((Throwable)new IllegalStateException("Blob has written, can not write twice"));
                }
                return Flux.from((Publisher)blob.stream()).doOnSubscribe(ignored -> writer.startHex()).doOnNext(writer::writeHex).then();
            });
        }

        @Override
        public MySqlType getType() {
            return MySqlType.LONGBLOB;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobParameter)) {
                return false;
            }
            BlobParameter blobValue = (BlobParameter)o;
            return Objects.equals(this.blob.get(), blobValue.blob.get());
        }

        public int hashCode() {
            Blob blob = this.blob.get();
            return blob == null ? 0 : blob.hashCode();
        }

        @Override
        protected Publisher<Void> getDiscard() {
            Blob blob = this.blob.getAndSet(null);
            return blob == null ? null : blob.discard();
        }
    }
}

