/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.MySqlColumnMetadata;
import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.CodecUtils;
import dev.miku.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class BigDecimalCodec
extends AbstractClassedCodec<BigDecimal> {
    BigDecimalCodec(ByteBufAllocator allocator) {
        super(allocator, BigDecimal.class);
    }

    @Override
    public BigDecimal decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        MySqlType type = metadata.getType();
        if (binary) {
            return BigDecimalCodec.decodeBinary(value, type);
        }
        switch (type) {
            case FLOAT: {
                return BigDecimal.valueOf(Float.parseFloat(value.toString(StandardCharsets.US_ASCII)));
            }
            case DOUBLE: {
                return BigDecimal.valueOf(Double.parseDouble(value.toString(StandardCharsets.US_ASCII)));
            }
            case DECIMAL: {
                return BigDecimalCodec.parseBigDecimal(value);
            }
            case BIGINT_UNSIGNED: {
                String num;
                if (value.getByte(value.readerIndex()) == 43) {
                    value.skipBytes(1);
                }
                if (CodecUtils.isGreaterThanLongMax(num = value.toString(StandardCharsets.US_ASCII))) {
                    return new BigDecimal(num);
                }
                return BigDecimal.valueOf(CodecUtils.parsePositive(num));
            }
        }
        return BigDecimal.valueOf(CodecUtils.parseLong(value));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new BigDecimalParameter(this.allocator, (BigDecimal)value);
    }

    @Override
    protected boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    private static BigDecimal decodeBinary(ByteBuf buf, MySqlType type) {
        switch (type) {
            case BIGINT_UNSIGNED: {
                long v = buf.readLongLE();
                if (v < 0L) {
                    return new BigDecimal(CodecUtils.unsignedBigInteger(v));
                }
                return BigDecimal.valueOf(v);
            }
            case BIGINT: {
                return BigDecimal.valueOf(buf.readLongLE());
            }
            case INT_UNSIGNED: {
                return BigDecimal.valueOf(buf.readUnsignedIntLE());
            }
            case INT: 
            case MEDIUMINT_UNSIGNED: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(buf.readIntLE());
            }
            case SMALLINT_UNSIGNED: {
                return BigDecimal.valueOf(buf.readUnsignedShortLE());
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(buf.readShortLE());
            }
            case TINYINT_UNSIGNED: {
                return BigDecimal.valueOf(buf.readUnsignedByte());
            }
            case TINYINT: {
                return BigDecimal.valueOf(buf.readByte());
            }
            case DECIMAL: {
                return BigDecimalCodec.parseBigDecimal(buf);
            }
            case FLOAT: {
                return BigDecimal.valueOf(buf.readFloatLE());
            }
            case DOUBLE: {
                return BigDecimal.valueOf(buf.readDoubleLE());
            }
        }
        throw new IllegalStateException("Cannot decode type " + (Object)((Object)type) + " as a BigDecimal");
    }

    private static BigDecimal parseBigDecimal(ByteBuf buf) {
        return new BigDecimal(buf.toString(StandardCharsets.US_ASCII));
    }

    private static final class BigDecimalParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final BigDecimal value;

        private BigDecimalParameter(ByteBufAllocator allocator, BigDecimal value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> CodecUtils.encodeAscii(this.allocator, this.value.toString()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeBigDecimal(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.DECIMAL;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigDecimalParameter)) {
                return false;
            }
            BigDecimalParameter that = (BigDecimalParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

