/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.MySqlSslConfiguration;
import dev.miku.r2dbc.mysql.ServerVersion;
import dev.miku.r2dbc.mysql.client.DefaultHostnameVerifier;
import dev.miku.r2dbc.mysql.client.SslState;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.message.server.SyntheticSslResponseMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import reactor.netty.tcp.SslProvider;
import reactor.util.Logger;
import reactor.util.Loggers;

final class SslBridgeHandler
extends ChannelDuplexHandler {
    static final String NAME = "R2dbcMySqlSslBridgeHandler";
    private static final String SSL_NAME = "R2dbcMySqlSslHandler";
    private static final Logger logger = Loggers.getLogger(SslBridgeHandler.class);
    private static final String[] TLS_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"};
    private static final String[] OLD_TLS_PROTOCOLS = new String[]{"TLSv1.1", "TLSv1"};
    private static final ServerVersion VER_5_6_0 = ServerVersion.create(5, 6, 0);
    private static final ServerVersion VER_5_6_46 = ServerVersion.create(5, 6, 46);
    private static final ServerVersion VER_5_7_0 = ServerVersion.create(5, 7, 0);
    private static final ServerVersion VER_5_7_28 = ServerVersion.create(5, 7, 28);
    private final ConnectionContext context;
    private final MySqlSslConfiguration ssl;
    private SSLEngine sslEngine;

    SslBridgeHandler(ConnectionContext context, MySqlSslConfiguration ssl) {
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
        this.ssl = AssertUtils.requireNonNull(ssl, "ssl must not be null");
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.ssl.getSslMode() == SslMode.TUNNEL) {
            this.handleSslState(ctx, SslState.BRIDGING);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslState) {
            this.handleSslState(ctx, (SslState)((Object)evt));
            return;
        }
        if (evt instanceof SslHandshakeCompletionEvent) {
            this.handleSslCompleted(ctx, (SslHandshakeCompletionEvent)evt);
        }
        super.userEventTriggered(ctx, evt);
    }

    private void handleSslCompleted(ChannelHandlerContext ctx, SslHandshakeCompletionEvent evt) {
        if (!evt.isSuccess()) {
            ctx.fireExceptionCaught(evt.cause());
            return;
        }
        SslMode mode = this.ssl.getSslMode();
        if (mode.verifyIdentity()) {
            SSLEngine sslEngine = this.sslEngine;
            if (sslEngine == null) {
                ctx.fireExceptionCaught((Throwable)new IllegalStateException("sslEngine must not be null when verify identity"));
                return;
            }
            String host = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName();
            if (!this.hostnameVerifier().verify(host, sslEngine.getSession())) {
                ctx.fireExceptionCaught((Throwable)new SSLException("The hostname '" + host + "' could not be verified"));
                return;
            }
        }
        if (mode != SslMode.TUNNEL) {
            ctx.fireChannelRead((Object)SyntheticSslResponseMessage.INSTANCE);
        }
        logger.debug("SSL handshake completed, remove SSL bridge in pipeline");
        ctx.pipeline().remove(NAME);
    }

    private void handleSslState(ChannelHandlerContext ctx, SslState state) {
        switch (state) {
            case BRIDGING: {
                logger.debug("SSL event triggered, enable SSL handler to pipeline");
                reactor.netty.tcp.SslProvider sslProvider = reactor.netty.tcp.SslProvider.builder().sslContext((SslProvider.ProtocolSslContextSpec)MySqlSslContextSpec.forClient(this.ssl, this.context.getServerVersion())).build();
                SslHandler sslHandler = sslProvider.getSslContext().newHandler(ctx.alloc());
                this.sslEngine = sslHandler.engine();
                ctx.pipeline().addBefore(NAME, SSL_NAME, (ChannelHandler)sslHandler);
                break;
            }
            case UNSUPPORTED: {
                logger.debug("Server unsupported SSL, remove SSL bridge in pipeline");
                ctx.pipeline().remove(NAME);
            }
        }
    }

    private HostnameVerifier hostnameVerifier() {
        HostnameVerifier verifier = this.ssl.getSslHostnameVerifier();
        return verifier == null ? DefaultHostnameVerifier.INSTANCE : verifier;
    }

    private static boolean isCurrentTlsEnabled(ServerVersion version) {
        return version.isGreaterThanOrEqualTo(VER_5_7_28) || version.isGreaterThanOrEqualTo(VER_5_6_46) && version.isLessThan(VER_5_7_0) || version.isGreaterThanOrEqualTo(VER_5_6_0) && version.isEnterprise();
    }

    private static final class MySqlSslContextSpec
    implements SslProvider.ProtocolSslContextSpec {
        private final SslContextBuilder builder;

        private MySqlSslContextSpec(SslContextBuilder builder) {
            this.builder = builder;
        }

        public MySqlSslContextSpec configure(Consumer<SslContextBuilder> customizer) {
            AssertUtils.requireNonNull(customizer, "customizer must not be null");
            customizer.accept(this.builder);
            return this;
        }

        public SslContext sslContext() throws SSLException {
            return this.builder.build();
        }

        static MySqlSslContextSpec forClient(MySqlSslConfiguration ssl, ServerVersion version) {
            SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);
            String[] tlsProtocols = ssl.getTlsVersion();
            if (tlsProtocols.length > 0) {
                builder.protocols(tlsProtocols);
            } else if (SslBridgeHandler.isCurrentTlsEnabled(version)) {
                builder.protocols(TLS_PROTOCOLS);
            } else {
                logger.warn("MySQL {} does not support TLS1.2, TLS1.1 is disabled in latest JDKs", new Object[]{version});
                builder.protocols(OLD_TLS_PROTOCOLS);
            }
            String sslKey = ssl.getSslKey();
            if (sslKey != null) {
                CharSequence keyPassword = ssl.getSslKeyPassword();
                String sslCert = ssl.getSslCert();
                if (sslCert == null) {
                    throw new IllegalStateException("SSL key present but client cert does not exist");
                }
                builder.keyManager(new File(sslCert), new File(sslKey), keyPassword == null ? null : keyPassword.toString());
            }
            if (ssl.getSslMode().verifyCertificate()) {
                String sslCa = ssl.getSslCa();
                if (sslCa != null) {
                    builder.trustManager(new File(sslCa));
                }
            } else {
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            return new MySqlSslContextSpec(ssl.customizeSslContext(builder));
        }
    }
}

