/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.client;

import dev.miku.r2dbc.mysql.client.San;
import dev.miku.r2dbc.mysql.util.AddressUtils;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultHostnameVerifier
implements HostnameVerifier {
    static final DefaultHostnameVerifier INSTANCE = new DefaultHostnameVerifier();
    private static final Logger logger = Loggers.getLogger(DefaultHostnameVerifier.class);
    private static final boolean LOG_DEBUG = logger.isDebugEnabled();
    private static final String COMMON_NAME = "CN";
    private static final int DNS = 0;
    private static final int IP_V4 = 1;
    private static final int IP_V6 = 2;

    @Override
    public boolean verify(String host, SSLSession session) {
        Certificate[] certs;
        AssertUtils.requireNonNull(host, "host must not be null");
        AssertUtils.requireNonNull(session, "session must not be null");
        try {
            certs = session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            logger.error("Load peer certificates failed", (Throwable)e);
            return false;
        }
        if (certs.length == 0) {
            return false;
        }
        if (!(certs[0] instanceof X509Certificate)) {
            logger.warn("Certificate for '{}' must be X509Certificate (not javax) instead of {}", new Object[]{host, certs[0].getClass()});
            return false;
        }
        X509Certificate cert = (X509Certificate)certs[0];
        List<San> sans = DefaultHostnameVerifier.extractSans(cert);
        if (sans.isEmpty()) {
            return DefaultHostnameVerifier.matchCn(host, cert);
        }
        switch (DefaultHostnameVerifier.determineHostType(host)) {
            case 1: {
                return DefaultHostnameVerifier.matchIpv4(host, sans);
            }
            case 2: {
                return DefaultHostnameVerifier.matchIpv6(host, sans);
            }
        }
        return DefaultHostnameVerifier.matchDns(host, sans);
    }

    private static boolean matchIpv4(String ip, List<San> sans) {
        for (San san : sans) {
            if (7 != san.getType() || !ip.equals(san.getValue())) continue;
            if (LOG_DEBUG) {
                logger.debug("Certificate for '{}' matched IPv4 '{}' of the Subject Alternative Names", new Object[]{ip, san.getValue()});
            }
            return true;
        }
        logger.warn("Certificate for '{}' does not match any Subject Alternative Names: {}", new Object[]{ip, sans});
        return false;
    }

    private static boolean matchIpv6(String ip, List<San> sans) {
        String host = DefaultHostnameVerifier.normaliseIpv6(ip);
        for (San san : sans) {
            if (7 != san.getType() || !host.equals(DefaultHostnameVerifier.normaliseIpv6(san.getValue()))) continue;
            if (LOG_DEBUG) {
                logger.debug("Certificate for '{}' matched IPv6 '{}' of the Subject Alternative Names", new Object[]{ip, san.getValue()});
            }
            return true;
        }
        logger.warn("Certificate for '{}' does not match any Subject Alternative Names: {}", new Object[]{ip, sans});
        return false;
    }

    private static boolean matchDns(String host, List<San> sans) {
        if (host.isEmpty() || host.charAt(0) == '.' || host.endsWith("..")) {
            logger.warn("Certificate for '{}' cannot match because it is invalid", new Object[]{host});
            return false;
        }
        for (San san : sans) {
            if (2 != san.getType() || !DefaultHostnameVerifier.matchHost(host, san.getValue())) continue;
            if (LOG_DEBUG) {
                logger.debug("Certificate for '{}' matched DNS '{}' of the Subject Alternative Names", new Object[]{host, san.getValue()});
            }
            return true;
        }
        logger.warn("Certificate for '{}' does not match any Subject Alternative Names: {}", new Object[]{host, sans});
        return false;
    }

    private static boolean matchCn(String host, X509Certificate cert) {
        LdapName name;
        String principal = cert.getSubjectX500Principal().getName("RFC2253");
        try {
            name = new LdapName(principal);
        }
        catch (InvalidNameException e) {
            logger.error("LDAP name parse failed", (Throwable)e);
            return false;
        }
        String cn = null;
        for (Rdn rdn : name.getRdns()) {
            if (!COMMON_NAME.equalsIgnoreCase(rdn.getType())) continue;
            cn = rdn.getValue().toString();
            break;
        }
        if (cn == null) {
            logger.warn("Certificate for '{}' does not contain the Common Name", new Object[]{host});
            return false;
        }
        if (host.isEmpty() || host.charAt(0) == '.' || host.endsWith("..") || !DefaultHostnameVerifier.matchHost(host, cn)) {
            logger.warn("Certificate for '{}' does not match the Common Name: {}", new Object[]{host, cn});
            return false;
        }
        if (LOG_DEBUG) {
            logger.debug("Certificate for '{}' matched by Common Name '{}'", new Object[]{host, cn});
        }
        return true;
    }

    private static boolean matchHost(String host, String pattern) {
        if (pattern.isEmpty() || pattern.charAt(0) == '.' || pattern.endsWith("..")) {
            return false;
        }
        int asteriskIndex = pattern.indexOf(42);
        if (asteriskIndex < 0) {
            return host.equalsIgnoreCase(pattern);
        }
        int patternSize = pattern.length();
        if (patternSize == 1) {
            logger.warn("Certificate cannot signature as {} for match all identities", new Object[]{pattern});
            return false;
        }
        int postfixSize = patternSize - asteriskIndex - 1;
        int remainderIndex = host.length() - postfixSize;
        if (remainderIndex <= asteriskIndex) {
            return false;
        }
        String lHost = host.toLowerCase(Locale.ROOT);
        String lPattern = pattern.toLowerCase(Locale.ROOT);
        if (asteriskIndex > 0 && !lHost.startsWith(lPattern.substring(0, asteriskIndex)) || postfixSize > 0 && !lHost.endsWith(lPattern.substring(asteriskIndex + 1))) {
            return false;
        }
        return !host.substring(asteriskIndex, remainderIndex).contains(".");
    }

    private static List<San> extractSans(X509Certificate cert) {
        Collection<List<?>> pairs;
        try {
            pairs = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            logger.warn("Load Subject Alternative Names from Certificate failed", (Throwable)e);
            return Collections.emptyList();
        }
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<San> sans = new ArrayList<San>();
        for (List<?> pair : pairs) {
            int type;
            Object left;
            if (pair == null || pair.size() < 2 || (left = pair.get(0)) == null) continue;
            if (left instanceof Integer) {
                type = (Integer)left;
            } else {
                try {
                    type = Integer.parseInt(left.toString());
                }
                catch (NumberFormatException ignored) {
                    logger.info("Unknown SAN type {}", new Object[]{left});
                    continue;
                }
            }
            if (2 == type || 7 == type) {
                Object value = pair.get(1);
                if (value instanceof String) {
                    sans.add(new San((String)value, type));
                    continue;
                }
                if (value instanceof byte[]) {
                    logger.warn("Certificate contains an ASN.1 DER encoded form but DER is unsupported now");
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Certificate contains an unknown value of Subject Alternative Names: {}", new Object[]{value.getClass()});
                continue;
            }
            logger.warn("Certificate contains an unknown type of Subject Alternative Names: {}", new Object[]{type});
        }
        return sans;
    }

    private static String normaliseIpv6(String ip) {
        try {
            return InetAddress.getByName(ip).getHostAddress();
        }
        catch (UnknownHostException ignored) {
            return ip;
        }
    }

    private static int determineHostType(String hostname) {
        if (AddressUtils.isIpv4(hostname)) {
            return 1;
        }
        int maxIndex = hostname.length() - 1;
        String host = hostname.charAt(0) == '[' && hostname.charAt(maxIndex) == ']' ? hostname.substring(1, maxIndex) : hostname;
        if (AddressUtils.isIpv6(host)) {
            return 2;
        }
        return 0;
    }

    private DefaultHostnameVerifier() {
    }
}

