/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.cache;

import dev.miku.r2dbc.mysql.cache.Caches;
import dev.miku.r2dbc.mysql.cache.LeftPad;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;

final class RingBuffer<T>
extends LeftPad {
    private static final AtomicIntegerFieldUpdater<RingBuffer> HEAD = AtomicIntegerFieldUpdater.newUpdater(RingBuffer.class, "head");
    private static final AtomicIntegerFieldUpdater<RingBuffer> TAIL = AtomicIntegerFieldUpdater.newUpdater(RingBuffer.class, "tail");
    private static final int SCALE = 4;
    private static final int SHIFT = Integer.numberOfTrailingZeros(128) - Integer.numberOfTrailingZeros(4);
    private static final int PADDING = (1 << SHIFT) - 1;
    private static final int MAX_SIZE = 256;
    private volatile int head;
    int p15;
    long p16;
    long p17;
    long p18;
    long p19;
    long p20;
    long p21;
    long p22;
    long p23;
    long p24;
    long p25;
    long p26;
    long p27;
    long p28;
    long p29;
    long p30;
    private volatile int tail;
    int p31;
    long p32;
    long p33;
    long p34;
    long p35;
    long p36;
    long p37;
    long p38;
    long p39;
    long p40;
    long p41;
    long p42;
    long p43;
    long p44;
    long p45;
    long p46;
    private final AtomicReferenceArray<T> buffer;
    private final int maxSize;
    private final int mask;
    private final int retry;
    private final Consumer<T> consumer;

    RingBuffer(int capacity, int retry, Consumer<T> consumer) {
        int maxSize;
        AssertUtils.require(capacity > 0 && capacity <= 256, "capacity must between 1 and 256");
        this.maxSize = maxSize = Caches.ceilingPowerOfTwo(capacity);
        this.mask = maxSize - 1;
        this.buffer = new AtomicReferenceArray((maxSize << SHIFT) + PADDING);
        this.retry = retry;
        this.consumer = consumer;
    }

    boolean offer(T value) {
        for (int i = 0; i < this.retry; ++i) {
            int tail = this.tail;
            int size = tail - this.head;
            if (size >= this.maxSize) {
                return false;
            }
            int offset = this.getOffset(tail);
            if (!TAIL.compareAndSet(this, tail, tail + 1)) continue;
            this.buffer.set(offset, value);
            return true;
        }
        return false;
    }

    void drainAll() {
        int tail = this.tail;
        int head = this.head;
        int size = tail - head;
        if (size < 0 || size > this.maxSize) {
            throw new IllegalStateException("Impossible size between " + head + " and " + tail);
        }
        if (size == 0) {
            return;
        }
        int nullCount = 0;
        int maxNullCount = Math.min(size << 2, 128);
        while (size > 0) {
            int offset = this.getOffset(head);
            T value = this.buffer.get(offset);
            if (value == null) {
                if (nullCount++ >= maxNullCount) break;
            } else if (HEAD.compareAndSet(this, head, head + 1)) {
                this.buffer.compareAndSet(offset, value, null);
                this.consumer.accept(value);
            }
            head = this.head;
            size = tail - head;
        }
    }

    long keeping(int v) {
        this.p15 = this.p31 = v;
        this.p46 = this.p7 = (long)this.p31;
        this.p45 = this.p7;
        this.p44 = this.p7;
        this.p43 = this.p7;
        this.p42 = this.p7;
        this.p41 = this.p7;
        this.p40 = this.p7;
        this.p39 = this.p7;
        this.p38 = this.p7;
        this.p37 = this.p7;
        this.p36 = this.p7;
        this.p35 = this.p7;
        this.p34 = this.p7;
        this.p33 = this.p7;
        this.p32 = this.p7;
        this.p30 = this.p7;
        this.p29 = this.p7;
        this.p28 = this.p7;
        this.p27 = this.p7;
        this.p26 = this.p7;
        this.p25 = this.p7;
        this.p24 = this.p7;
        this.p23 = this.p7;
        this.p22 = this.p7;
        this.p21 = this.p7;
        this.p20 = this.p7;
        this.p19 = this.p7;
        this.p18 = this.p7;
        this.p17 = this.p7;
        this.p16 = this.p7;
        this.p14 = this.p7;
        this.p13 = this.p7;
        this.p12 = this.p7;
        this.p11 = this.p7;
        this.p10 = this.p7;
        this.p9 = this.p7;
        this.p8 = this.p7;
        this.p6 = this.p7;
        this.p5 = this.p7;
        this.p4 = this.p7;
        this.p3 = this.p7;
        this.p2 = this.p7;
        this.p1 = this.p7;
        this.p0 = this.p7;
        return this.p7;
    }

    private int getOffset(int index) {
        return ((index & this.mask) << SHIFT) + PADDING;
    }
}

