/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.authentication;

import dev.miku.r2dbc.mysql.authentication.AuthUtils;
import dev.miku.r2dbc.mysql.authentication.MySqlAuthProvider;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import reactor.util.annotation.Nullable;

final class OldAuthProvider
implements MySqlAuthProvider {
    static final OldAuthProvider INSTANCE = new OldAuthProvider();
    private static final int MAX_SALT_LENGTH = 8;
    private static final long FIRST_HASHING = 1345345333L;
    private static final long SECOND_HASHING = 305419889L;
    private static final int SUM_INIT_VALUE = 7;
    private static final int HASH_MARK = 63;
    private static final long MOD = 0x3FFFFFFFL;
    private static final int SEED_INC = 33;
    private static final int SEED_MULTIPLIER = 3;
    private static final int RESULT_INC = 64;
    private static final int RESULT_MULTIPLIER = 31;

    @Override
    public boolean isSslNecessary() {
        return false;
    }

    @Override
    public byte[] authentication(@Nullable CharSequence password, byte[] salt, CharCollation collation) {
        byte[] challenge;
        String saltString;
        if (password == null || password.length() <= 0) {
            return InternalArrays.EMPTY_BYTES;
        }
        AssertUtils.requireNonNull(collation, "collation must not be null when password exists");
        Charset charset = collation.getCharset();
        if (salt.length == 0) {
            saltString = "";
            challenge = InternalArrays.EMPTY_BYTES;
        } else {
            String newString = new String(salt, charset);
            if (newString.length() > 8) {
                saltString = newString.substring(0, 8);
                challenge = saltString.getBytes(charset);
            } else {
                saltString = newString;
                challenge = salt;
            }
        }
        long authentications = OldAuthProvider.hashing(challenge);
        long messages = OldAuthProvider.hashing(OldAuthProvider.encodeNoWhitespace(password, charset));
        long firstSeed = (OldAuthProvider.firstPart(authentications) ^ OldAuthProvider.firstPart(messages)) % 0x3FFFFFFFL;
        long secondSeed = (OldAuthProvider.secondPart(authentications) ^ OldAuthProvider.secondPart(messages)) % 0x3FFFFFFFL;
        int stringSize = saltString.length();
        char[] results = new char[stringSize];
        for (int i = 0; i < stringSize; ++i) {
            firstSeed = (firstSeed * 3L + secondSeed) % 0x3FFFFFFFL;
            secondSeed = (firstSeed + secondSeed + 33L) % 0x3FFFFFFFL;
            results[i] = (char)Math.floor((double)firstSeed / 1.073741823E9 * 31.0 + 64.0);
        }
        long lastSeed = (firstSeed * 3L + secondSeed) % 0x3FFFFFFFL;
        char mark = (char)Math.floor((double)lastSeed / 1.073741823E9 * 31.0);
        int i = 0;
        while (i < stringSize) {
            int n = i++;
            results[n] = (char)(results[n] ^ mark);
        }
        return AuthUtils.encodeTerminal(CharBuffer.wrap(results), charset);
    }

    @Override
    public MySqlAuthProvider next() {
        return this;
    }

    @Override
    public String getType() {
        return "mysql_old_password";
    }

    private static byte[] encodeNoWhitespace(CharSequence password, Charset charset) {
        int size = password.length();
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char current = password.charAt(i);
            if (Character.isWhitespace(current)) continue;
            builder.append(current);
        }
        ByteBuffer buffer = charset.encode(CharBuffer.wrap(builder));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    private static long firstPart(long results) {
        return results >>> 32 & Integer.MAX_VALUE;
    }

    private static long secondPart(long results) {
        return results & Integer.MAX_VALUE;
    }

    private static long hashing(byte[] plaintext) {
        long firstPart = 1345345333L;
        long secondPart = 305419889L;
        long sum = 7L;
        for (byte current : plaintext) {
            int bits = current & 0xFF;
            firstPart ^= (firstPart << 8) + ((firstPart & 0x3FL) + sum) * (long)bits;
            secondPart += firstPart ^ secondPart << 8;
            sum += (long)bits;
        }
        return (firstPart & Integer.MAX_VALUE) << 32 | secondPart & Integer.MAX_VALUE;
    }

    private OldAuthProvider() {
    }
}

