/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.BaseFluxExchangeable;
import dev.miku.r2dbc.mysql.Binding;
import dev.miku.r2dbc.mysql.Query;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.QueryLogger;
import dev.miku.r2dbc.mysql.message.client.PreparedTextQueryMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

final class TextQueryExchangeable
extends BaseFluxExchangeable {
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final Query query;
    private final Iterator<Binding> bindings;

    TextQueryExchangeable(Query query, Iterator<Binding> bindings) {
        this.query = query;
        this.bindings = bindings;
    }

    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.requests.tryEmitComplete();
            while (this.bindings.hasNext()) {
                this.bindings.next().clear();
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    @Override
    protected void tryNextOrComplete(@Nullable SynchronousSink<ServerMessage> sink) {
        if (this.bindings.hasNext()) {
            QueryLogger.log(this.query);
            PreparedTextQueryMessage message = this.bindings.next().toTextMessage(this.query);
            Sinks.EmitResult result = this.requests.tryEmitNext((Object)message);
            if (result == Sinks.EmitResult.OK) {
                return;
            }
            QueryFlow.logger.error("Emit request failed due to {}", new Object[]{result});
            message.dispose();
        }
        if (sink != null) {
            sink.complete();
        }
    }

    @Override
    protected String offendingSql() {
        return this.query.getFormattedSql();
    }
}

