/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ConsistentSnapshotEngine;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Option;
import io.r2dbc.spi.TransactionDefinition;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class MySqlTransactionDefinition
implements TransactionDefinition {
    public static final Option<Boolean> WITH_CONSISTENT_SNAPSHOT = Option.valueOf((String)"withConsistentSnapshot");
    public static final Option<ConsistentSnapshotEngine> CONSISTENT_SNAPSHOT_ENGINE = Option.valueOf((String)"consistentSnapshotEngine");
    public static final Option<Long> CONSISTENT_SNAPSHOT_FROM_SESSION = Option.valueOf((String)"consistentSnapshotFromSession");
    private static final MySqlTransactionDefinition EMPTY = new MySqlTransactionDefinition(Collections.emptyMap());
    private final Map<Option<?>, Object> options;

    private MySqlTransactionDefinition(Map<Option<?>, Object> options) {
        this.options = options;
    }

    public <T> T getAttribute(Option<T> option) {
        return (T)this.options.get(option);
    }

    public Builder mutate() {
        return new Builder(new HashMap(this.options));
    }

    public static MySqlTransactionDefinition empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder(new HashMap());
    }

    public static final class Builder {
        private final Map<Option<?>, Object> options;

        public MySqlTransactionDefinition build() {
            switch (this.options.size()) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    Map.Entry<Option<?>, Object> entry = this.options.entrySet().iterator().next();
                    return new MySqlTransactionDefinition(Collections.singletonMap(entry.getKey(), entry.getValue()));
                }
            }
            return new MySqlTransactionDefinition(new HashMap(this.options));
        }

        public Builder isolationLevel(@Nullable IsolationLevel isolationLevel) {
            return this.option(TransactionDefinition.ISOLATION_LEVEL, isolationLevel);
        }

        public Builder lockWaitTimeout(@Nullable Duration lockWaitTimeout) {
            return this.option(TransactionDefinition.LOCK_WAIT_TIMEOUT, lockWaitTimeout);
        }

        public Builder readOnly(@Nullable Boolean readOnly) {
            return this.option(TransactionDefinition.READ_ONLY, readOnly);
        }

        public Builder withConsistentSnapshot(@Nullable Boolean withConsistentSnapshot) {
            return this.option(WITH_CONSISTENT_SNAPSHOT, withConsistentSnapshot);
        }

        public Builder consistentSnapshotEngine(@Nullable ConsistentSnapshotEngine snapshotEngine) {
            return this.option(CONSISTENT_SNAPSHOT_ENGINE, snapshotEngine);
        }

        public Builder consistentSnapshotFromSession(@Nullable Long sessionId) {
            return this.option(CONSISTENT_SNAPSHOT_FROM_SESSION, sessionId);
        }

        private <T> Builder option(Option<T> key, @Nullable T value) {
            if (value == null) {
                this.options.remove(key);
            } else {
                this.options.put(key, value);
            }
            return this;
        }

        private Builder(Map<Option<?>, Object> options) {
            this.options = options;
        }
    }
}

