/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.handler.ssl.SslContextBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import reactor.util.annotation.Nullable;

public final class MySqlSslConfiguration {
    private static final MySqlSslConfiguration DISABLED = new MySqlSslConfiguration(SslMode.DISABLED, InternalArrays.EMPTY_STRINGS, null, null, null, null, null, null);
    private final SslMode sslMode;
    private final String[] tlsVersion;
    @Nullable
    private final HostnameVerifier sslHostnameVerifier;
    @Nullable
    private final String sslCa;
    @Nullable
    private final String sslKey;
    @Nullable
    private final CharSequence sslKeyPassword;
    @Nullable
    private final String sslCert;
    @Nullable
    private final Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer;

    private MySqlSslConfiguration(SslMode sslMode, String[] tlsVersion, @Nullable HostnameVerifier sslHostnameVerifier, @Nullable String sslCa, @Nullable String sslKey, @Nullable CharSequence sslKeyPassword, @Nullable String sslCert, @Nullable Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer) {
        this.sslMode = sslMode;
        this.tlsVersion = tlsVersion;
        this.sslHostnameVerifier = sslHostnameVerifier;
        this.sslCa = sslCa;
        this.sslKey = sslKey;
        this.sslKeyPassword = sslKeyPassword;
        this.sslCert = sslCert;
        this.sslContextBuilderCustomizer = sslContextBuilderCustomizer;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public String[] getTlsVersion() {
        return this.tlsVersion;
    }

    @Nullable
    public HostnameVerifier getSslHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    @Nullable
    public String getSslCa() {
        return this.sslCa;
    }

    @Nullable
    public String getSslKey() {
        return this.sslKey;
    }

    @Nullable
    public CharSequence getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    @Nullable
    public String getSslCert() {
        return this.sslCert;
    }

    public SslContextBuilder customizeSslContext(SslContextBuilder builder) {
        if (this.sslContextBuilderCustomizer == null) {
            return builder;
        }
        return this.sslContextBuilderCustomizer.apply(builder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlSslConfiguration)) {
            return false;
        }
        MySqlSslConfiguration that = (MySqlSslConfiguration)o;
        return this.sslMode == that.sslMode && Arrays.equals(this.tlsVersion, that.tlsVersion) && Objects.equals(this.sslHostnameVerifier, that.sslHostnameVerifier) && Objects.equals(this.sslCa, that.sslCa) && Objects.equals(this.sslKey, that.sslKey) && Objects.equals(this.sslKeyPassword, that.sslKeyPassword) && Objects.equals(this.sslCert, that.sslCert) && Objects.equals(this.sslContextBuilderCustomizer, that.sslContextBuilderCustomizer);
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.sslMode, this.sslHostnameVerifier, this.sslCa, this.sslKey, this.sslKeyPassword, this.sslCert, this.sslContextBuilderCustomizer});
        return 31 * hash + Arrays.hashCode(this.tlsVersion);
    }

    public String toString() {
        if (this.sslMode == SslMode.DISABLED) {
            return "MySqlSslConfiguration{sslMode=DISABLED}";
        }
        return "MySqlSslConfiguration{sslMode=" + (Object)((Object)this.sslMode) + ", tlsVersion=" + Arrays.toString(this.tlsVersion) + ", sslHostnameVerifier=" + this.sslHostnameVerifier + ", sslCa='" + this.sslCa + "', sslKey='" + this.sslKey + "', sslKeyPassword=REDACTED, sslCert='" + this.sslCert + "', sslContextBuilderCustomizer=" + this.sslContextBuilderCustomizer + '}';
    }

    static MySqlSslConfiguration disabled() {
        return DISABLED;
    }

    static MySqlSslConfiguration create(SslMode sslMode, String[] tlsVersion, @Nullable HostnameVerifier sslHostnameVerifier, @Nullable String sslCa, @Nullable String sslKey, @Nullable CharSequence sslKeyPassword, @Nullable String sslCert, @Nullable Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer) {
        AssertUtils.requireNonNull(sslMode, "sslMode must not be null");
        if (sslMode == SslMode.DISABLED) {
            return DISABLED;
        }
        AssertUtils.requireNonNull(tlsVersion, "tlsVersion must not be null");
        return new MySqlSslConfiguration(sslMode, tlsVersion, sslHostnameVerifier, sslCa, sslKey, sslKeyPassword, sslCert, sslContextBuilderCustomizer);
    }
}

