/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ColumnNameSet;
import dev.miku.r2dbc.mysql.MySqlColumnDescriptor;
import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.r2dbc.spi.RowMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

final class MySqlRowMetadata
implements RowMetadata {
    private final MySqlColumnDescriptor[] originMetadata;
    private final MySqlColumnDescriptor[] sortedMetadata;
    private final ColumnNameSet nameSet;

    private MySqlRowMetadata(MySqlColumnDescriptor[] metadata) {
        int size = metadata.length;
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("Least 1 column metadata");
            }
            case 1: {
                String name = metadata[0].getName();
                this.originMetadata = metadata;
                this.sortedMetadata = metadata;
                this.nameSet = ColumnNameSet.of(name);
                break;
            }
            default: {
                MySqlColumnDescriptor[] sortedMetadata = new MySqlColumnDescriptor[size];
                System.arraycopy(metadata, 0, sortedMetadata, 0, size);
                Arrays.sort(sortedMetadata, ColumnNameSet.NAME_COMPARATOR);
                String[] originNames = MySqlRowMetadata.getNames(metadata);
                String[] sortedNames = MySqlRowMetadata.getNames(sortedMetadata);
                this.originMetadata = metadata;
                this.sortedMetadata = sortedMetadata;
                this.nameSet = ColumnNameSet.of(originNames, sortedNames);
            }
        }
    }

    public MySqlColumnDescriptor getColumnMetadata(int index) {
        if (index < 0 || index >= this.originMetadata.length) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", total: " + this.originMetadata.length);
        }
        return this.originMetadata[index];
    }

    public MySqlColumnDescriptor getColumnMetadata(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        int index = this.nameSet.findIndex(name);
        if (index < 0) {
            throw new NoSuchElementException("Column name '" + name + "' does not exist");
        }
        return this.sortedMetadata[index];
    }

    public boolean contains(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        return this.nameSet.contains(name);
    }

    public List<MySqlColumnDescriptor> getColumnMetadatas() {
        return InternalArrays.asImmutableList(this.originMetadata);
    }

    public Set<String> getColumnNames() {
        return this.nameSet;
    }

    public String toString() {
        return "MySqlRowMetadata{metadata=" + Arrays.toString(this.originMetadata) + ", sortedNames=" + Arrays.toString(this.nameSet.getSortedNames()) + '}';
    }

    MySqlColumnDescriptor[] unwrap() {
        return this.originMetadata;
    }

    static MySqlRowMetadata create(DefinitionMetadataMessage[] columns) {
        int size = columns.length;
        MySqlColumnDescriptor[] metadata = new MySqlColumnDescriptor[size];
        for (int i = 0; i < size; ++i) {
            metadata[i] = MySqlColumnDescriptor.create(i, columns[i]);
        }
        return new MySqlRowMetadata(metadata);
    }

    private static String[] getNames(MySqlColumnDescriptor[] metadata) {
        int size = metadata.length;
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = metadata[i].getName();
        }
        return names;
    }
}

