/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.InsertSyntheticRow;
import dev.miku.r2dbc.mysql.MySqlRow;
import dev.miku.r2dbc.mysql.MySqlRowMetadata;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.FieldValue;
import dev.miku.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.OkMessage;
import dev.miku.r2dbc.mysql.message.server.RowMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.NettyBufferUtils;
import dev.miku.r2dbc.mysql.util.OperatorUtils;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

public final class MySqlResult
implements Result {
    private static final Consumer<ReferenceCounted> RELEASE = ReferenceCounted::release;
    private static final BiConsumer<Result.Segment, SynchronousSink<Integer>> ROWS_UPDATED = (segment, sink) -> {
        if (segment instanceof Result.UpdateCount) {
            sink.next((Object)((int)((Result.UpdateCount)segment).value()));
        } else if (segment instanceof Result.Message) {
            sink.error((Throwable)((Result.Message)segment).exception());
        } else if (segment instanceof ReferenceCounted) {
            ReferenceCountUtil.safeRelease((Object)segment);
        }
    };
    private static final BiFunction<Integer, Integer, Integer> SUM = Integer::sum;
    private final Flux<Result.Segment> segments;

    private MySqlResult(Flux<Result.Segment> segments) {
        this.segments = segments;
    }

    public Mono<Integer> getRowsUpdated() {
        return this.segments.handle(ROWS_UPDATED).reduce(SUM);
    }

    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        AssertUtils.requireNonNull(f, "mapping function must not be null");
        return this.segments.handle((segment, sink) -> {
            if (segment instanceof Result.RowSegment) {
                Row row = ((Result.RowSegment)segment).row();
                try {
                    sink.next(f.apply(row, row.getMetadata()));
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)segment);
                }
            } else if (segment instanceof Result.Message) {
                sink.error((Throwable)((Result.Message)segment).exception());
            } else if (segment instanceof ReferenceCounted) {
                ReferenceCountUtil.safeRelease((Object)segment);
            }
        });
    }

    public <T> Flux<T> map(Function<? super Readable, ? extends T> f) {
        AssertUtils.requireNonNull(f, "mapping function must not be null");
        return this.segments.handle((segment, sink) -> {
            if (segment instanceof Result.RowSegment) {
                try {
                    sink.next(f.apply((Readable)((Result.RowSegment)segment).row()));
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)segment);
                }
            } else if (segment instanceof Result.Message) {
                sink.error((Throwable)((Result.Message)segment).exception());
            } else if (segment instanceof ReferenceCounted) {
                ReferenceCountUtil.safeRelease((Object)segment);
            }
        });
    }

    public MySqlResult filter(Predicate<Result.Segment> filter) {
        AssertUtils.requireNonNull(filter, "filter must not be null");
        return new MySqlResult((Flux<Result.Segment>)this.segments.filter(segment -> {
            if (filter.test((Result.Segment)segment)) {
                return true;
            }
            if (segment instanceof ReferenceCounted) {
                ReferenceCountUtil.safeRelease((Object)segment);
            }
            return false;
        }));
    }

    public <T> Flux<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> f) {
        AssertUtils.requireNonNull(f, "mapping function must not be null");
        return this.segments.flatMap(segment -> {
            Publisher ret = (Publisher)f.apply((Result.Segment)segment);
            if (ret == null) {
                return Mono.error((Throwable)new IllegalStateException("The mapper returned a null Publisher"));
            }
            if (ret instanceof Mono) {
                Mono mono = (Mono)ret;
                return mono.doAfterTerminate(() -> ReferenceCountUtil.release((Object)segment));
            }
            return Flux.from((Publisher)ret).doAfterTerminate(() -> ReferenceCountUtil.release((Object)segment));
        });
    }

    static MySqlResult toResult(boolean binary, Codecs codecs, ConnectionContext context, @Nullable String generatedKeyName, Flux<ServerMessage> messages) {
        AssertUtils.requireNonNull(codecs, "codecs must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(messages, "messages must not be null");
        return new MySqlResult((Flux<Result.Segment>)OperatorUtils.discardOnCancel(messages).doOnDiscard(ReferenceCounted.class, RELEASE).handle((BiConsumer)new MySqlSegments(binary, codecs, context, generatedKeyName)));
    }

    private static final class MySqlSegments
    implements BiConsumer<ServerMessage, SynchronousSink<Result.Segment>> {
        private final boolean binary;
        private final Codecs codecs;
        private final ConnectionContext context;
        @Nullable
        private final String generatedKeyName;
        private MySqlRowMetadata rowMetadata;

        private MySqlSegments(boolean binary, Codecs codecs, ConnectionContext context, @Nullable String generatedKeyName) {
            this.binary = binary;
            this.codecs = codecs;
            this.context = context;
            this.generatedKeyName = generatedKeyName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(ServerMessage message, SynchronousSink<Result.Segment> sink) {
            if (message instanceof RowMessage) {
                FieldValue[] fields;
                MySqlRowMetadata metadata = this.rowMetadata;
                if (metadata == null) {
                    ReferenceCountUtil.safeRelease((Object)message);
                    sink.error((Throwable)new IllegalStateException("No MySqlRowMetadata available"));
                    return;
                }
                try {
                    fields = ((RowMessage)message).decode(this.binary, metadata.unwrap());
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)message);
                }
                sink.next((Object)new MySqlRowSegment(fields, metadata, this.codecs, this.binary, this.context));
            } else if (message instanceof SyntheticMetadataMessage) {
                DefinitionMetadataMessage[] metadataMessages = ((SyntheticMetadataMessage)message).unwrap();
                if (metadataMessages.length == 0) {
                    return;
                }
                this.rowMetadata = MySqlRowMetadata.create(metadataMessages);
            } else if (message instanceof OkMessage) {
                MySqlUpdateCount segment = this.generatedKeyName == null ? new MySqlUpdateCount((OkMessage)message) : new MySqlOkSegment((OkMessage)message, this.codecs, this.generatedKeyName);
                sink.next((Object)segment);
            } else if (message instanceof ErrorMessage) {
                sink.next((Object)new MySqlMessage((ErrorMessage)message));
            } else {
                ReferenceCountUtil.safeRelease((Object)message);
            }
        }
    }

    private static final class MySqlOkSegment
    extends MySqlUpdateCount
    implements Result.RowSegment {
        private final Codecs codecs;
        private final String keyName;

        private MySqlOkSegment(OkMessage message, Codecs codecs, String keyName) {
            super(message);
            this.codecs = codecs;
            this.keyName = keyName;
        }

        public Row row() {
            return new InsertSyntheticRow(this.codecs, this.keyName, this.message.getLastInsertId());
        }
    }

    private static class MySqlUpdateCount
    implements Result.UpdateCount {
        protected final OkMessage message;

        private MySqlUpdateCount(OkMessage message) {
            this.message = message;
        }

        public long value() {
            return this.message.getAffectedRows();
        }
    }

    private static final class MySqlRowSegment
    extends AbstractReferenceCounted
    implements Result.RowSegment {
        private final MySqlRow row;
        private final FieldValue[] fields;

        private MySqlRowSegment(FieldValue[] fields, MySqlRowMetadata metadata, Codecs codecs, boolean binary, ConnectionContext context) {
            this.row = new MySqlRow(fields, metadata, codecs, binary, context);
            this.fields = fields;
        }

        public Row row() {
            return this.row;
        }

        public ReferenceCounted touch(Object hint) {
            if (this.fields.length == 0) {
                return this;
            }
            for (FieldValue field : this.fields) {
                field.touch(hint);
            }
            return this;
        }

        protected void deallocate() {
            NettyBufferUtils.releaseAll(this.fields);
        }
    }

    private static final class MySqlMessage
    implements Result.Message {
        private final ErrorMessage message;

        private MySqlMessage(ErrorMessage message) {
            this.message = message;
        }

        public R2dbcException exception() {
            return this.message.toException();
        }

        public int errorCode() {
            return this.message.getCode();
        }

        public String sqlState() {
            return this.message.getSqlState();
        }

        public String message() {
            return this.message.getMessage();
        }
    }
}

