/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.MySqlBatch;
import dev.miku.r2dbc.mysql.MySqlResult;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.client.Client;
import dev.miku.r2dbc.mysql.codec.Codecs;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import reactor.core.publisher.Flux;

final class MySqlBatchingBatch
extends MySqlBatch {
    private final Client client;
    private final Codecs codecs;
    private final ConnectionContext context;
    private StringBuilder builder;

    MySqlBatchingBatch(Client client, Codecs codecs, ConnectionContext context) {
        this.client = AssertUtils.requireNonNull(client, "client must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
    }

    @Override
    public MySqlBatch add(String sql) {
        AssertUtils.requireNonNull(sql, "sql must not be null");
        int index = MySqlBatchingBatch.lastNonWhitespace(sql);
        if (index >= 0 && sql.charAt(index) == ';') {
            this.requireBuilder().append(sql, 0, index);
        } else {
            this.requireBuilder().append(sql);
        }
        return this;
    }

    @Override
    public Flux<MySqlResult> execute() {
        return QueryFlow.execute(this.client, this.getSql()).map(messages -> MySqlResult.toResult(false, this.codecs, this.context, null, (Flux<ServerMessage>)messages));
    }

    public String toString() {
        return "MySqlBatchingBatch{sql=REDACTED}";
    }

    String getSql() {
        return this.builder.toString();
    }

    private StringBuilder requireBuilder() {
        if (this.builder == null) {
            this.builder = new StringBuilder();
            return this.builder;
        }
        return this.builder.append(';');
    }

    private static int lastNonWhitespace(String sql) {
        int size = sql.length();
        for (int i = size - 1; i >= 0; --i) {
            if (Character.isWhitespace(sql.charAt(i))) continue;
            return i;
        }
        return -1;
    }
}

