/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.BaseFluxExchangeable;
import dev.miku.r2dbc.mysql.QueryFlow;
import dev.miku.r2dbc.mysql.QueryLogger;
import dev.miku.r2dbc.mysql.message.client.TextQueryMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import java.util.Iterator;
import reactor.core.Scannable;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

final class MultiQueryExchangeable
extends BaseFluxExchangeable {
    private final Iterator<String> statements;
    private String current;

    MultiQueryExchangeable(Iterator<String> statements) {
        this.statements = statements;
    }

    public void dispose() {
        this.requests.tryEmitComplete();
    }

    public boolean isDisposed() {
        return (Boolean)this.requests.scanOrDefault(Scannable.Attr.TERMINATED, (Object)Boolean.FALSE);
    }

    @Override
    protected void tryNextOrComplete(@Nullable SynchronousSink<ServerMessage> sink) {
        if (this.statements.hasNext()) {
            String current = this.statements.next();
            QueryLogger.log(current);
            this.current = current;
            Sinks.EmitResult result = this.requests.tryEmitNext((Object)new TextQueryMessage(current));
            if (result == Sinks.EmitResult.OK) {
                return;
            }
            QueryFlow.logger.error("Emit request failed due to {}", new Object[]{result});
        }
        if (sink != null) {
            sink.complete();
        }
    }

    @Override
    protected String offendingSql() {
        return this.current;
    }
}

