/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlColumnDescriptor;
import dev.miku.r2dbc.mysql.MySqlNames;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class ColumnNameSet
extends AbstractSet<String>
implements Set<String> {
    static final Comparator<MySqlColumnDescriptor> NAME_COMPARATOR = (left, right) -> MySqlNames.compare(left.getName(), right.getName());
    private final String[] originNames;
    private final String[] sortedNames;

    private ColumnNameSet(String[] originNames, String[] sortedNames) {
        this.originNames = originNames;
        this.sortedNames = sortedNames;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.findIndex((String)o) >= 0;
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return InternalArrays.asIterator(this.originNames);
    }

    @Override
    public int size() {
        return this.originNames.length;
    }

    @Override
    public boolean isEmpty() {
        return this.originNames.length == 0;
    }

    @Override
    public Spliterator<String> spliterator() {
        return Spliterators.spliterator(this.originNames, 1296);
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        Objects.requireNonNull(action);
        for (String name : this.originNames) {
            action.accept(name);
        }
    }

    public String[] toArray() {
        return Arrays.copyOf(this.originNames, this.originNames.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Objects.requireNonNull(a);
        int size = this.originNames.length;
        if (a.length < size) {
            return Arrays.copyOf(this.originNames, size, a.getClass());
        }
        System.arraycopy(this.originNames, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        Objects.requireNonNull(c);
        if (!c.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super String> filter) {
        Objects.requireNonNull(filter);
        for (String name : this.originNames) {
            if (!filter.test(name)) continue;
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        if (!c.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        if (!c.containsAll(this)) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return Arrays.toString(this.originNames);
    }

    int findIndex(String name) {
        return MySqlNames.nameSearch(this.sortedNames, name);
    }

    String[] getSortedNames() {
        return this.sortedNames;
    }

    static ColumnNameSet of(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        String[] names = new String[]{name};
        return new ColumnNameSet(names, names);
    }

    static ColumnNameSet of(String[] originNames, String[] sortedNames) {
        AssertUtils.requireNonNull(originNames, "originNames must not be null");
        AssertUtils.requireNonNull(sortedNames, "sortedNames must not be null");
        AssertUtils.require(originNames.length == sortedNames.length, "The length of origin names the same as sorted names one");
        return new ColumnNameSet(originNames, sortedNames);
    }
}

