/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.ConnectionState;
import dev.miku.r2dbc.mysql.message.server.CompleteMessage;
import dev.miku.r2dbc.mysql.message.server.ErrorMessage;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Iterator;
import java.util.List;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

abstract class AbstractTransactionState {
    final ConnectionState state;
    int tasks;
    private final List<String> statements;
    @Nullable
    private String sql;

    protected AbstractTransactionState(ConnectionState state, int tasks, List<String> statements) {
        this.state = state;
        this.tasks = tasks;
        this.statements = statements;
    }

    final void setSql(String sql) {
        this.sql = sql;
    }

    final boolean isSimple() {
        return this.statements.size() == 1;
    }

    final String batchStatement() {
        if (this.statements.size() == 1) {
            return this.statements.get(0);
        }
        return String.join((CharSequence)";", this.statements);
    }

    final Iterator<String> statements() {
        return this.statements.iterator();
    }

    final boolean accept(ServerMessage message, SynchronousSink<Void> sink) {
        if (message instanceof ErrorMessage) {
            sink.error((Throwable)((ErrorMessage)message).toException(this.sql));
            return false;
        }
        if (message instanceof CompleteMessage) {
            int task = Integer.lowestOneBit(this.tasks);
            this.tasks -= task;
            return this.process(task, sink);
        }
        if (message instanceof ReferenceCounted) {
            ReferenceCountUtil.safeRelease((Object)message);
        }
        return false;
    }

    abstract boolean cancelTasks();

    protected abstract boolean process(int var1, SynchronousSink<Void> var2);
}

