/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.MetricExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetryResourceAutoConfiguration;
import io.opentelemetry.sdk.autoconfigure.PropagatorConfiguration;
import io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.SdkMeterProviderConfigurer;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import java.util.ServiceLoader;

public final class OpenTelemetrySdkAutoConfiguration {
    public static OpenTelemetrySdk initialize() {
        return OpenTelemetrySdkAutoConfiguration.initialize(true);
    }

    public static OpenTelemetrySdk initialize(boolean setResultAsGlobal) {
        return OpenTelemetrySdkAutoConfiguration.initialize(setResultAsGlobal, DefaultConfigProperties.get());
    }

    public static OpenTelemetrySdk initialize(boolean setResultAsGlobal, ConfigProperties config) {
        ContextPropagators propagators = PropagatorConfiguration.configurePropagators(config);
        Resource resource = OpenTelemetryResourceAutoConfiguration.configureResource(config);
        OpenTelemetrySdkAutoConfiguration.configureMeterProvider(resource, config);
        SdkTracerProvider tracerProvider = TracerProviderConfiguration.configureTracerProvider(resource, config);
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(propagators).build();
        if (setResultAsGlobal) {
            GlobalOpenTelemetry.set((OpenTelemetry)openTelemetrySdk);
        }
        return openTelemetrySdk;
    }

    private static void configureMeterProvider(Resource resource, ConfigProperties config) {
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder().setResource(resource);
        String exemplarFilter = config.getString("otel.metrics.exemplar.filter");
        if (exemplarFilter == null) {
            exemplarFilter = "with_sampled_trace";
        }
        switch (exemplarFilter) {
            case "none": {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.neverSample());
                break;
            }
            case "all": {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.alwaysSample());
                break;
            }
            default: {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.sampleWithTraces());
            }
        }
        for (SdkMeterProviderConfigurer configurer : ServiceLoader.load(SdkMeterProviderConfigurer.class)) {
            configurer.configure(meterProviderBuilder, config);
        }
        String exporterName = config.getString("otel.metrics.exporter");
        if (exporterName == null) {
            exporterName = "none";
        }
        MetricExporterConfiguration.configureExporter(exporterName, config, meterProviderBuilder);
        SdkMeterProvider meterProvider = meterProviderBuilder.buildAndRegisterGlobal();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkMeterProvider)meterProvider).close()));
    }

    private OpenTelemetrySdkAutoConfiguration() {
    }
}

