/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl.util;

import io.netty5.handler.ssl.util.FingerprintTrustManagerFactory;
import io.netty5.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class FingerprintTrustManagerFactoryBuilder {
    private final String algorithm;
    private final List<String> fingerprints = new ArrayList<String>();

    FingerprintTrustManagerFactoryBuilder(String algorithm) {
        this.algorithm = Objects.requireNonNull(algorithm, "algorithm");
    }

    public FingerprintTrustManagerFactoryBuilder fingerprints(CharSequence ... fingerprints) {
        return this.fingerprints(Arrays.asList(Objects.requireNonNull(fingerprints, "fingerprints")));
    }

    public FingerprintTrustManagerFactoryBuilder fingerprints(Iterable<? extends CharSequence> fingerprints) {
        Objects.requireNonNull(fingerprints, "fingerprints");
        for (CharSequence charSequence : fingerprints) {
            ObjectUtil.checkNotNullWithIAE((Object)charSequence, (String)"fingerprint");
            this.fingerprints.add(charSequence.toString());
        }
        return this;
    }

    public FingerprintTrustManagerFactory build() {
        if (this.fingerprints.isEmpty()) {
            throw new IllegalStateException("No fingerprints provided");
        }
        byte[][] fingerprints = FingerprintTrustManagerFactory.toFingerprintArray(this.fingerprints);
        return new FingerprintTrustManagerFactory(this.algorithm, fingerprints);
    }
}

