/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferUtil;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.ssl.NotSslRecordException;
import io.netty5.handler.ssl.SniCompletionEvent;
import io.netty5.handler.ssl.SslHandshakeCompletionEvent;
import io.netty5.handler.ssl.SslUtils;
import io.netty5.util.Resource;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;

public abstract class SslClientHelloHandler<T>
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslClientHelloHandler.class);
    private boolean handshakeFailed;
    private boolean suppressRead;
    private ReadBufferAllocator pendingReadBufferAllocator;
    private Buffer handshakeBuffer;

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed) {
            try {
                int packetLength;
                int readerIndex = in.readerOffset();
                int handshakeLength = -1;
                block7: for (int readableBytes = in.readableBytes(); readableBytes >= 5; readableBytes -= packetLength) {
                    int contentType = in.getUnsignedByte(readerIndex);
                    switch (contentType) {
                        case 20: 
                        case 21: {
                            int len = SslUtils.getEncryptedPacketLength(in, readerIndex);
                            if (len == -2) {
                                this.handshakeFailed = true;
                                NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + BufferUtil.hexDump((Buffer)in));
                                in.skipReadableBytes(in.readableBytes());
                                ctx.fireChannelInboundEvent((Object)new SniCompletionEvent(e));
                                ctx.fireChannelInboundEvent((Object)new SslHandshakeCompletionEvent(e));
                                throw e;
                            }
                            if (len == -1) {
                                return;
                            }
                            this.select(ctx, null);
                            return;
                        }
                        case 22: {
                            int majorVersion = in.getUnsignedByte(readerIndex + 1);
                            if (majorVersion != 3) break;
                            packetLength = in.getUnsignedShort(readerIndex + 3) + 5;
                            if (readableBytes < packetLength) {
                                return;
                            }
                            if (packetLength == 5) {
                                this.select(ctx, null);
                                return;
                            }
                            int endOffset = readerIndex + packetLength;
                            if (handshakeLength == -1) {
                                if (readerIndex + 4 > endOffset) {
                                    return;
                                }
                                int handshakeType = in.getUnsignedByte(readerIndex + 5);
                                if (handshakeType != 1) {
                                    this.select(ctx, null);
                                    return;
                                }
                                handshakeLength = in.getUnsignedMedium(readerIndex + 5 + 1);
                                readerIndex += 4;
                                if (handshakeLength + 4 + 5 <= (packetLength -= 4)) {
                                    in.readerOffset(readerIndex += 5);
                                    this.select(ctx, in.readSplit(handshakeLength));
                                    return;
                                }
                                if (this.handshakeBuffer == null) {
                                    this.handshakeBuffer = ctx.bufferAllocator().allocate(handshakeLength);
                                } else {
                                    this.handshakeBuffer.resetOffsets();
                                }
                            }
                            int hsLen = packetLength - 5;
                            in.copyInto(readerIndex + 5, this.handshakeBuffer, this.handshakeBuffer.writerOffset(), hsLen);
                            this.handshakeBuffer.skipWritableBytes(hsLen);
                            readerIndex += packetLength;
                            if (handshakeLength > this.handshakeBuffer.readableBytes()) continue block7;
                            Buffer clientHello = this.handshakeBuffer.readerOffset(0).writerOffset(handshakeLength);
                            this.handshakeBuffer = null;
                            this.select(ctx, clientHello);
                            return;
                        }
                    }
                    this.select(ctx, null);
                    return;
                }
            }
            catch (NotSslRecordException e) {
                throw e;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected client hello packet: " + BufferUtil.hexDump((Buffer)in), (Throwable)e);
                }
                this.select(ctx, null);
            }
        }
    }

    private void releaseHandshakeBuffer() {
        Resource.dispose((Object)this.handshakeBuffer);
        this.handshakeBuffer = null;
    }

    private void select(ChannelHandlerContext ctx, Buffer clientHello) {
        try {
            Future<T> future = this.lookup(ctx, clientHello);
            if (future.isDone()) {
                Resource.dispose((Object)clientHello);
                this.onLookupComplete(ctx, future);
            } else {
                this.suppressRead = true;
                future.addListener(f -> {
                    Resource.dispose((Object)clientHello);
                    try {
                        this.suppressRead = false;
                        try {
                            this.onLookupComplete(ctx, f);
                        }
                        catch (DecoderException err) {
                            ctx.fireChannelExceptionCaught((Throwable)err);
                        }
                        catch (Exception cause) {
                            ctx.fireChannelExceptionCaught((Throwable)new DecoderException((Throwable)cause));
                        }
                        catch (Throwable cause) {
                            ctx.fireChannelExceptionCaught(cause);
                        }
                    }
                    finally {
                        ReadBufferAllocator pendingReadBufferAllocator = this.pendingReadBufferAllocator;
                        if (pendingReadBufferAllocator != null) {
                            this.pendingReadBufferAllocator = null;
                            ctx.read(pendingReadBufferAllocator);
                        }
                    }
                });
            }
        }
        catch (Throwable cause) {
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.releaseHandshakeBuffer();
        super.handlerRemoved0(ctx);
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, Buffer var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, Future<? extends T> var2) throws Exception;

    public void read(ChannelHandlerContext ctx, ReadBufferAllocator readBufferAllocator) {
        if (this.suppressRead) {
            this.pendingReadBufferAllocator = readBufferAllocator;
        } else {
            ctx.read(readBufferAllocator);
        }
    }
}

