/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.base64.Base64;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PemReader.class);
    private static final Pattern CERT_HEADER = Pattern.compile("-+BEGIN\\s[^-\\r\\n]*CERTIFICATE[^-\\r\\n]*-+(?:\\s|\\r|\\n)+");
    private static final Pattern CERT_FOOTER = Pattern.compile("-+END\\s[^-\\r\\n]*CERTIFICATE[^-\\r\\n]*-+(?:\\s|\\r|\\n)*");
    private static final Pattern KEY_HEADER = Pattern.compile("-+BEGIN\\s[^-\\r\\n]*PRIVATE\\s+KEY[^-\\r\\n]*-+(?:\\s|\\r|\\n)+");
    private static final Pattern KEY_FOOTER = Pattern.compile("-+END\\s[^-\\r\\n]*PRIVATE\\s+KEY[^-\\r\\n]*-+(?:\\s|\\r|\\n)*");
    private static final Pattern BODY = Pattern.compile("[a-z0-9+/=][a-z0-9+/=\\r\\n]*", 2);

    static Buffer[] readCertificates(File file) throws CertificateException {
        Buffer[] bufferArray;
        FileInputStream in = new FileInputStream(file);
        try {
            bufferArray = PemReader.readCertificates(in);
        }
        catch (Throwable throwable) {
            try {
                PemReader.safeClose(in);
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new CertificateException("could not find certificate file: " + file);
            }
        }
        PemReader.safeClose(in);
        return bufferArray;
    }

    static Buffer[] readCertificates(InputStream in) throws CertificateException {
        String content;
        try {
            content = PemReader.readContent(in);
        }
        catch (IOException e) {
            throw new CertificateException("failed to read certificate input stream", e);
        }
        ArrayList<Buffer> certs = new ArrayList<Buffer>();
        Matcher m = CERT_HEADER.matcher(content);
        int start = 0;
        while (m.find(start)) {
            m.usePattern(BODY);
            if (!m.find()) break;
            Buffer base64 = DefaultBufferAllocators.onHeapAllocator().copyOf(m.group(0), StandardCharsets.US_ASCII);
            try {
                m.usePattern(CERT_FOOTER);
                if (!m.find()) break;
                certs.add(Base64.decode((Buffer)base64));
                start = m.end();
                m.usePattern(CERT_HEADER);
            }
            finally {
                if (base64 == null) continue;
                base64.close();
            }
        }
        if (certs.isEmpty()) {
            throw new CertificateException("found no certificates in input stream");
        }
        return (Buffer[])certs.toArray(Buffer[]::new);
    }

    static Buffer readPrivateKey(File file) throws KeyException {
        Buffer buffer;
        FileInputStream in = new FileInputStream(file);
        try {
            buffer = PemReader.readPrivateKey(in);
        }
        catch (Throwable throwable) {
            try {
                PemReader.safeClose(in);
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new KeyException("could not find key file: " + file);
            }
        }
        PemReader.safeClose(in);
        return buffer;
    }

    static Buffer readPrivateKey(InputStream in) throws KeyException {
        String content;
        try {
            content = PemReader.readContent(in);
        }
        catch (IOException e) {
            throw new KeyException("failed to read key input stream", e);
        }
        Matcher m = KEY_HEADER.matcher(content);
        if (!m.find()) {
            throw PemReader.keyNotFoundException();
        }
        m.usePattern(BODY);
        if (!m.find()) {
            throw PemReader.keyNotFoundException();
        }
        try (Buffer base64 = DefaultBufferAllocators.onHeapAllocator().copyOf(m.group(0), StandardCharsets.US_ASCII);){
            m.usePattern(KEY_FOOTER);
            if (!m.find()) {
                throw PemReader.keyNotFoundException();
            }
            Buffer buffer = Base64.decode((Buffer)base64);
            return buffer;
        }
    }

    private static KeyException keyNotFoundException() {
        return new KeyException("could not find a PKCS #8 private key in input stream (see https://netty.io/wiki/sslcontextbuilder-and-private-key.html for more information)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContent(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int ret;
            byte[] buf = new byte[8192];
            while ((ret = in.read(buf)) >= 0) {
                out.write(buf, 0, ret);
            }
            String string = out.toString(StandardCharsets.US_ASCII);
            return string;
        }
        finally {
            PemReader.safeClose(out);
        }
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a stream.", (Throwable)e);
        }
    }

    private static void safeClose(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a stream.", (Throwable)e);
        }
    }

    private PemReader() {
    }
}

