/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty.internal.tcnative.SSL;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.ssl.DefaultOpenSslKeyMaterial;
import io.netty5.handler.ssl.OpenSslKeyMaterial;
import io.netty5.handler.ssl.OpenSslPrivateKey;
import io.netty5.handler.ssl.PemEncoded;
import io.netty5.handler.ssl.PemX509Certificate;
import io.netty5.handler.ssl.ReferenceCountedOpenSslContext;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager keyManager, String password) {
        this.keyManager = keyManager;
        this.password = password;
    }

    static void validateKeyMaterialSupported(X509Certificate[] keyCertChain, PrivateKey key, String keyPassword) throws SSLException {
        OpenSslKeyMaterialProvider.validateSupported(keyCertChain);
        OpenSslKeyMaterialProvider.validateSupported(key, keyPassword);
    }

    private static void validateSupported(PrivateKey key, String password) throws SSLException {
        if (key == null) {
            return;
        }
        long pkeyBio = 0L;
        long pkey = 0L;
        try {
            pkeyBio = ReferenceCountedOpenSslContext.toBIO(key);
            pkey = SSL.parsePrivateKey((long)pkeyBio, (String)password);
        }
        catch (Exception e) {
            throw new SSLException("PrivateKey type not supported " + key.getFormat(), e);
        }
        finally {
            SSL.freeBIO((long)pkeyBio);
            if (pkey != 0L) {
                SSL.freePrivateKey((long)pkey);
            }
        }
    }

    private static void validateSupported(X509Certificate[] certificates) throws SSLException {
        if (certificates == null || certificates.length == 0) {
            return;
        }
        long chainBio = 0L;
        long chain = 0L;
        BufferAllocator allocator = DefaultBufferAllocators.offHeapAllocator();
        try (PemEncoded encoded = PemX509Certificate.toPEM(allocator, certificates);){
            chainBio = ReferenceCountedOpenSslContext.toBIO(allocator, encoded);
            chain = SSL.parseX509Chain((long)chainBio);
        }
        catch (Exception e) {
            throw new SSLException("Certificate type not supported", e);
        }
        finally {
            SSL.freeBIO((long)chainBio);
            if (chain != 0L) {
                SSL.freeX509Chain((long)chain);
            }
        }
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    OpenSslKeyMaterial chooseKeyMaterial(BufferAllocator allocator, String alias) throws Exception {
        X509Certificate[] certificates = this.keyManager.getCertificateChain(alias);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        PrivateKey key = this.keyManager.getPrivateKey(alias);
        long chainBio = 0L;
        long pkeyBio = 0L;
        long chain = 0L;
        long pkey = 0L;
        try {
            PemEncoded encoded = PemX509Certificate.toPEM(allocator, certificates);
            try {
                OpenSslKeyMaterial keyMaterial;
                chainBio = ReferenceCountedOpenSslContext.toBIO(allocator, encoded);
                chain = SSL.parseX509Chain((long)chainBio);
                if (key instanceof OpenSslPrivateKey) {
                    keyMaterial = ((OpenSslPrivateKey)key).newKeyMaterial(chain, certificates);
                } else {
                    pkeyBio = ReferenceCountedOpenSslContext.toBIO(key);
                    pkey = key == null ? 0L : SSL.parsePrivateKey((long)pkeyBio, (String)this.password);
                    keyMaterial = new DefaultOpenSslKeyMaterial(chain, pkey, certificates);
                }
                chain = 0L;
                pkey = 0L;
                OpenSslKeyMaterial openSslKeyMaterial = keyMaterial;
                if (encoded != null) {
                    encoded.close();
                }
                return openSslKeyMaterial;
            }
            catch (Throwable throwable) {
                if (encoded != null) {
                    try {
                        encoded.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            SSL.freeBIO((long)chainBio);
            SSL.freeBIO((long)pkeyBio);
            if (chain != 0L) {
                SSL.freeX509Chain((long)chain);
            }
            if (pkey != 0L) {
                SSL.freePrivateKey((long)pkey);
            }
        }
    }

    void destroy() {
    }
}

