/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.handler.ssl.ConscryptAlpnSslEngine;
import io.netty5.util.internal.PlatformDependent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.net.ssl.SSLEngine;

final class Conscrypt {
    private static final MethodHandle IS_CONSCRYPT_SSLENGINE;

    static boolean isAvailable() {
        return IS_CONSCRYPT_SSLENGINE != null;
    }

    static boolean isEngineSupported(SSLEngine engine) {
        try {
            return IS_CONSCRYPT_SSLENGINE != null && IS_CONSCRYPT_SSLENGINE.invokeExact(engine);
        }
        catch (IllegalAccessException ignore) {
            return false;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private Conscrypt() {
    }

    static {
        MethodHandle isConscryptSSLEngine = null;
        if (PlatformDependent.javaVersion() < 15 || PlatformDependent.isAndroid()) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> providerClass = Class.forName("org.conscrypt.OpenSSLProvider", true, PlatformDependent.getClassLoader(ConscryptAlpnSslEngine.class));
                lookup.findConstructor(providerClass, MethodType.methodType(Void.TYPE)).invoke();
                Class<?> conscryptClass = Class.forName("org.conscrypt.Conscrypt", true, PlatformDependent.getClassLoader(ConscryptAlpnSslEngine.class));
                isConscryptSSLEngine = lookup.findStatic(conscryptClass, "isConscrypt", MethodType.methodType(Boolean.TYPE, SSLEngine.class));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        IS_CONSCRYPT_SSLENGINE = isConscryptSSLEngine;
    }
}

