/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ipfilter;

import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.concurrent.Future;
import java.net.SocketAddress;

public abstract class AbstractRemoteAddressFilter<T extends SocketAddress>
implements ChannelHandler {
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.handleNewChannel(ctx, true);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (!this.handleNewChannel(ctx, false)) {
            throw new IllegalStateException("cannot determine to accept or reject a channel: " + ctx.channel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleNewChannel(ChannelHandlerContext ctx, boolean register) throws Exception {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        boolean remove = false;
        try {
            if (remoteAddress == null) {
                boolean bl = false;
                return bl;
            }
            if (this.accept(ctx, remoteAddress)) {
                this.channelAccepted(ctx, remoteAddress);
                remove = true;
            } else {
                Future<Void> rejectedFuture = this.channelRejected(ctx, remoteAddress);
                if (rejectedFuture != null && !rejectedFuture.isDone()) {
                    rejectedFuture.addListener((Object)ctx, ChannelFutureListeners.CLOSE);
                } else {
                    ctx.close();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (!ctx.isRemoved()) {
                if (register) {
                    ctx.fireChannelRegistered();
                } else {
                    ctx.fireChannelActive();
                }
                if (remove) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
        }
    }

    protected abstract boolean accept(ChannelHandlerContext var1, T var2) throws Exception;

    protected void channelAccepted(ChannelHandlerContext ctx, T remoteAddress) {
    }

    protected Future<Void> channelRejected(ChannelHandlerContext ctx, T remoteAddress) {
        return null;
    }
}

