/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.flow;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ReadBufferAllocator;
import io.netty5.util.Resource;
import io.netty5.util.internal.ObjectPool;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public class FlowControlHandler
implements ChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FlowControlHandler.class);
    private final boolean releaseMessages;
    private RecyclableArrayDeque queue;
    private boolean shouldConsume;

    public FlowControlHandler() {
        this(true);
    }

    public FlowControlHandler(boolean releaseMessages) {
        this.releaseMessages = releaseMessages;
    }

    boolean isQueueEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    private void destroy() {
        if (this.queue != null) {
            if (!this.queue.isEmpty()) {
                logger.trace("Non-empty queue: {}", (Object)this.queue);
                if (this.releaseMessages) {
                    Object msg;
                    while ((msg = this.queue.poll()) != null) {
                        try {
                            Resource.dispose(msg);
                        }
                        catch (Exception e) {
                            logger.trace("Exception while disposing of message in flow control", (Throwable)e);
                        }
                    }
                }
            }
            this.queue.recycle();
            this.queue = null;
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (!this.isQueueEmpty()) {
            this.dequeue(ctx, this.queue.size());
        }
        this.destroy();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        ctx.fireChannelInactive();
    }

    public void read(ChannelHandlerContext ctx, ReadBufferAllocator readBufferAllocator) {
        if (this.dequeue(ctx, 1) == 0) {
            this.shouldConsume = true;
            ctx.read(readBufferAllocator);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.queue == null) {
            this.queue = RecyclableArrayDeque.newInstance();
        }
        this.queue.offer(msg);
        int minConsume = this.shouldConsume ? 1 : 0;
        this.shouldConsume = false;
        this.dequeue(ctx, minConsume);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.isQueueEmpty()) {
            ctx.fireChannelReadComplete();
        }
    }

    private int dequeue(ChannelHandlerContext ctx, int minConsume) {
        Object msg;
        int consumed;
        for (consumed = 0; this.queue != null && (consumed < minConsume || ((Boolean)ctx.channel().getOption(ChannelOption.AUTO_READ)).booleanValue()) && (msg = this.queue.poll()) != null; ++consumed) {
            ctx.fireChannelRead(msg);
        }
        if (this.queue != null && this.queue.isEmpty()) {
            this.queue.recycle();
            this.queue = null;
            if (consumed > 0) {
                ctx.fireChannelReadComplete();
            }
        }
        return consumed;
    }

    private static final class RecyclableArrayDeque
    extends ArrayDeque<Object> {
        private static final long serialVersionUID = 0L;
        private static final int DEFAULT_NUM_ELEMENTS = 2;
        private static final ObjectPool<RecyclableArrayDeque> RECYCLER = ObjectPool.newPool(handle -> new RecyclableArrayDeque(2, (ObjectPool.Handle<RecyclableArrayDeque>)handle));
        private final ObjectPool.Handle<RecyclableArrayDeque> handle;

        public static RecyclableArrayDeque newInstance() {
            return (RecyclableArrayDeque)RECYCLER.get();
        }

        private RecyclableArrayDeque(int numElements, ObjectPool.Handle<RecyclableArrayDeque> handle) {
            super(numElements);
            this.handle = handle;
        }

        public void recycle() {
            this.clear();
            this.handle.recycle((Object)this);
        }
    }
}

