/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.common.utils;

import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import java.util.List;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public class ParquetUtils {
    public static MessageType parseCollectionSchema(CollectionSchemaParam collectionSchema) {
        List<FieldType> fieldTypes = collectionSchema.getFieldTypes();
        Types.MessageTypeBuilder messageTypeBuilder = Types.buildMessage();
        for (FieldType fieldType : fieldTypes) {
            if (fieldType.isAutoID()) continue;
            switch (fieldType.getDataType()) {
                case FloatVector: {
                    messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.FLOAT).named(fieldType.getName());
                    break;
                }
                case BinaryVector: {
                    ((Types.BaseListBuilder.ElementBuilder)messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)8, (boolean)false))).named(fieldType.getName());
                    break;
                }
                case Array: {
                    ParquetUtils.fillArrayType(messageTypeBuilder, fieldType);
                    break;
                }
                case Int64: {
                    messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.INT64).named(fieldType.getName());
                    break;
                }
                case VarChar: 
                case JSON: {
                    ((Types.PrimitiveBuilder)messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(fieldType.getName());
                    break;
                }
                case Int8: {
                    ((Types.PrimitiveBuilder)messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)8, (boolean)true))).named(fieldType.getName());
                    break;
                }
                case Int16: {
                    ((Types.PrimitiveBuilder)messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)16, (boolean)true))).named(fieldType.getName());
                    break;
                }
                case Int32: {
                    messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.INT32).named(fieldType.getName());
                    break;
                }
                case Float: {
                    messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.FLOAT).named(fieldType.getName());
                    break;
                }
                case Double: {
                    messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.DOUBLE).named(fieldType.getName());
                    break;
                }
                case Bool: {
                    messageTypeBuilder.required(PrimitiveType.PrimitiveTypeName.BOOLEAN).named(fieldType.getName());
                }
            }
        }
        return messageTypeBuilder.named("schema");
    }

    private static void fillArrayType(Types.MessageTypeBuilder messageTypeBuilder, FieldType fieldType) {
        switch (fieldType.getElementType()) {
            case Int64: {
                messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.INT64).named(fieldType.getName());
                break;
            }
            case VarChar: {
                ((Types.BaseListBuilder.ElementBuilder)messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(fieldType.getName());
                break;
            }
            case Int8: {
                ((Types.BaseListBuilder.ElementBuilder)messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)8, (boolean)true))).named(fieldType.getName());
                break;
            }
            case Int16: {
                ((Types.BaseListBuilder.ElementBuilder)messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.IntLogicalTypeAnnotation.intType((int)16, (boolean)true))).named(fieldType.getName());
                break;
            }
            case Int32: {
                messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.INT32).named(fieldType.getName());
                break;
            }
            case Float: {
                messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.FLOAT).named(fieldType.getName());
                break;
            }
            case Double: {
                messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.DOUBLE).named(fieldType.getName());
                break;
            }
            case Bool: {
                messageTypeBuilder.requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.BOOLEAN).named(fieldType.getName());
            }
        }
    }
}

