/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.internal.sds.ClientSslContextProviderFactory;
import io.grpc.xds.internal.sds.ReferenceCountingSslContextProviderMap;
import io.grpc.xds.internal.sds.ServerSslContextProviderFactory;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;

public final class TlsContextManagerImpl
implements TlsContextManager {
    private static TlsContextManagerImpl instance;
    private final ReferenceCountingSslContextProviderMap<UpstreamTlsContext> mapForClients;
    private final ReferenceCountingSslContextProviderMap<DownstreamTlsContext> mapForServers;

    private TlsContextManagerImpl() {
        this(new ClientSslContextProviderFactory(), new ServerSslContextProviderFactory());
    }

    @VisibleForTesting
    TlsContextManagerImpl(ReferenceCountingSslContextProviderMap.SslContextProviderFactory<UpstreamTlsContext> clientFactory, ReferenceCountingSslContextProviderMap.SslContextProviderFactory<DownstreamTlsContext> serverFactory) {
        Preconditions.checkNotNull(clientFactory, (Object)"clientFactory");
        Preconditions.checkNotNull(serverFactory, (Object)"serverFactory");
        this.mapForClients = new ReferenceCountingSslContextProviderMap<UpstreamTlsContext>(clientFactory);
        this.mapForServers = new ReferenceCountingSslContextProviderMap<DownstreamTlsContext>(serverFactory);
    }

    public static synchronized TlsContextManagerImpl getInstance() {
        if (instance == null) {
            instance = new TlsContextManagerImpl();
        }
        return instance;
    }

    @Override
    public SslContextProvider<DownstreamTlsContext> findOrCreateServerSslContextProvider(DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        return this.mapForServers.get(downstreamTlsContext);
    }

    @Override
    public SslContextProvider<UpstreamTlsContext> findOrCreateClientSslContextProvider(UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        return this.mapForClients.get(upstreamTlsContext);
    }

    @Override
    public SslContextProvider<UpstreamTlsContext> releaseClientSslContextProvider(SslContextProvider<UpstreamTlsContext> sslContextProvider) {
        Preconditions.checkNotNull(sslContextProvider, (Object)"sslContextProvider");
        return this.mapForClients.release(sslContextProvider);
    }

    @Override
    public SslContextProvider<DownstreamTlsContext> releaseServerSslContextProvider(SslContextProvider<DownstreamTlsContext> sslContextProvider) {
        Preconditions.checkNotNull(sslContextProvider, (Object)"sslContextProvider");
        return this.mapForServers.release(sslContextProvider);
    }
}

