/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.XdsLoadBalancer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class XdsLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String XDS_POLICY_NAME = "xds_experimental";

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return XDS_POLICY_NAME;
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new XdsLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return XdsLoadBalancerProvider.parseLoadBalancingConfigPolicy(rawLoadBalancingPolicyConfig, LoadBalancerRegistry.getDefaultRegistry());
    }

    static NameResolver.ConfigOrError parseLoadBalancingConfigPolicy(Map<String, ?> rawLoadBalancingPolicyConfig, LoadBalancerRegistry registry) {
        try {
            String cluster = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"cluster");
            ServiceConfigUtil.LbConfig roundRobinConfig = new ServiceConfigUtil.LbConfig("round_robin", (Map)ImmutableMap.of());
            ArrayList<Object> endpointPickingConfigs = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects(rawLoadBalancingPolicyConfig, (String)"endpointPickingPolicy"));
            endpointPickingConfigs = endpointPickingConfigs == null ? new ArrayList<ServiceConfigUtil.LbConfig>(1) : new ArrayList(endpointPickingConfigs);
            endpointPickingConfigs.add(roundRobinConfig);
            NameResolver.ConfigOrError childConfigOrError = ServiceConfigUtil.selectLbPolicyFromList(endpointPickingConfigs, (LoadBalancerRegistry)registry);
            if (childConfigOrError.getError() != null) {
                return childConfigOrError;
            }
            ServiceConfigUtil.PolicySelection childPolicy = (ServiceConfigUtil.PolicySelection)childConfigOrError.getConfig();
            ArrayList<Object> fallbackConfigs = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects(rawLoadBalancingPolicyConfig, (String)"fallbackPolicy"));
            fallbackConfigs = fallbackConfigs == null ? new ArrayList<ServiceConfigUtil.LbConfig>(1) : new ArrayList(fallbackConfigs);
            fallbackConfigs.add(roundRobinConfig);
            NameResolver.ConfigOrError fallbackConfigOrError = ServiceConfigUtil.selectLbPolicyFromList(fallbackConfigs, (LoadBalancerRegistry)registry);
            if (fallbackConfigOrError.getError() != null) {
                return fallbackConfigOrError;
            }
            ServiceConfigUtil.PolicySelection fallbackPolicy = (ServiceConfigUtil.PolicySelection)fallbackConfigOrError.getConfig();
            String edsServiceName = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"edsServiceName");
            String lrsServerName = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"lrsLoadReportingServerName");
            return NameResolver.ConfigOrError.fromConfig((Object)new XdsConfig(cluster, childPolicy, fallbackPolicy, edsServiceName, lrsServerName));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.fromThrowable((Throwable)e).withDescription("Failed to parse XDS LB config: " + rawLoadBalancingPolicyConfig));
        }
    }

    static final class XdsConfig {
        @Nullable
        final String cluster;
        final ServiceConfigUtil.PolicySelection endpointPickingPolicy;
        @Nullable
        final ServiceConfigUtil.PolicySelection fallbackPolicy;
        @Nullable
        final String edsServiceName;
        @Nullable
        final String lrsServerName;

        XdsConfig(@Nullable String cluster, ServiceConfigUtil.PolicySelection endpointPickingPolicy, @Nullable ServiceConfigUtil.PolicySelection fallbackPolicy, @Nullable String edsServiceName, @Nullable String lrsServerName) {
            this.cluster = cluster;
            this.endpointPickingPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)endpointPickingPolicy, (Object)"endpointPickingPolicy");
            this.fallbackPolicy = fallbackPolicy;
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("endpointPickingPolicy", (Object)this.endpointPickingPolicy).add("fallbackPolicy", (Object)this.fallbackPolicy).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XdsConfig)) {
                return false;
            }
            XdsConfig that = (XdsConfig)obj;
            return Objects.equal((Object)this.cluster, (Object)that.cluster) && Objects.equal((Object)this.endpointPickingPolicy, (Object)that.endpointPickingPolicy) && Objects.equal((Object)this.fallbackPolicy, (Object)that.fallbackPolicy) && Objects.equal((Object)this.edsServiceName, (Object)that.edsServiceName) && Objects.equal((Object)this.lrsServerName, (Object)that.lrsServerName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.cluster, this.endpointPickingPolicy, this.fallbackPolicy, this.edsServiceName, this.lrsServerName});
        }
    }
}

