/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.ClientLoadCounter;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsStore;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.ClusterStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.EndpointLoadMetricStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.UpstreamLocalityStats;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class LoadStatsStoreImpl
implements LoadStatsStore {
    private final String clusterName;
    @Nullable
    private final String clusterServiceName;
    private final ConcurrentMap<EnvoyProtoData.Locality, ClientLoadCounter> localityLoadCounters;
    private final ConcurrentMap<String, AtomicLong> dropCounters;

    LoadStatsStoreImpl(String clusterName, @Nullable String clusterServiceName) {
        this(clusterName, clusterServiceName, new ConcurrentHashMap<EnvoyProtoData.Locality, ClientLoadCounter>(), new ConcurrentHashMap<String, AtomicLong>());
    }

    @VisibleForTesting
    LoadStatsStoreImpl(String clusterName, @Nullable String clusterServiceName, ConcurrentMap<EnvoyProtoData.Locality, ClientLoadCounter> localityLoadCounters, ConcurrentMap<String, AtomicLong> dropCounters) {
        this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
        this.clusterServiceName = clusterServiceName;
        this.localityLoadCounters = (ConcurrentMap)Preconditions.checkNotNull(localityLoadCounters, (Object)"localityLoadCounters");
        this.dropCounters = (ConcurrentMap)Preconditions.checkNotNull(dropCounters, (Object)"dropCounters");
    }

    @Override
    public ClusterStats generateLoadReport() {
        ClusterStats.Builder statsBuilder = ClusterStats.newBuilder();
        statsBuilder.setClusterName(this.clusterName);
        for (Map.Entry entry : this.localityLoadCounters.entrySet()) {
            ClientLoadCounter.ClientLoadSnapshot snapshot = ((ClientLoadCounter)entry.getValue()).snapshot();
            UpstreamLocalityStats.Builder localityStatsBuilder = UpstreamLocalityStats.newBuilder().setLocality(((EnvoyProtoData.Locality)entry.getKey()).toEnvoyProtoLocality());
            localityStatsBuilder.setTotalSuccessfulRequests(snapshot.getCallsSucceeded()).setTotalErrorRequests(snapshot.getCallsFailed()).setTotalRequestsInProgress(snapshot.getCallsInProgress()).setTotalIssuedRequests(snapshot.getCallsIssued());
            for (Map.Entry<String, ClientLoadCounter.MetricValue> metric : snapshot.getMetricValues().entrySet()) {
                localityStatsBuilder.addLoadMetricStats(EndpointLoadMetricStats.newBuilder().setMetricName(metric.getKey()).setNumRequestsFinishedWithMetric(metric.getValue().getNumReports()).setTotalMetricValue(metric.getValue().getTotalValue()));
            }
            statsBuilder.addUpstreamLocalityStats(localityStatsBuilder);
            if (((ClientLoadCounter)entry.getValue()).isActive() || snapshot.getCallsInProgress() != 0L) continue;
            this.localityLoadCounters.remove(entry.getKey());
        }
        long totalDrops = 0L;
        for (Map.Entry entry : this.dropCounters.entrySet()) {
            long drops = ((AtomicLong)entry.getValue()).getAndSet(0L);
            totalDrops += drops;
            statsBuilder.addDroppedRequests(ClusterStats.DroppedRequests.newBuilder().setCategory((String)entry.getKey()).setDroppedCount(drops));
        }
        statsBuilder.setTotalDroppedRequests(totalDrops);
        return statsBuilder.build();
    }

    @Override
    public void addLocality(EnvoyProtoData.Locality locality) {
        ClientLoadCounter counter = (ClientLoadCounter)this.localityLoadCounters.get(locality);
        Preconditions.checkState((counter == null || !counter.isActive() ? 1 : 0) != 0, (String)"An active counter for locality %s already exists", (Object)locality);
        if (counter == null) {
            this.localityLoadCounters.put(locality, new ClientLoadCounter());
        } else {
            counter.setActive(true);
        }
    }

    @Override
    public void removeLocality(EnvoyProtoData.Locality locality) {
        ClientLoadCounter counter = (ClientLoadCounter)this.localityLoadCounters.get(locality);
        Preconditions.checkState((counter != null && counter.isActive() ? 1 : 0) != 0, (String)"No active counter for locality %s exists", (Object)locality);
        counter.setActive(false);
    }

    @Override
    public ClientLoadCounter getLocalityCounter(EnvoyProtoData.Locality locality) {
        return (ClientLoadCounter)this.localityLoadCounters.get(locality);
    }

    @Override
    public void recordDroppedRequest(String category) {
        AtomicLong counter = (AtomicLong)this.dropCounters.get(category);
        if (counter == null && (counter = this.dropCounters.putIfAbsent(category, new AtomicLong())) == null) {
            counter = (AtomicLong)this.dropCounters.get(category);
        }
        counter.getAndIncrement();
    }
}

