/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.xds.EdsLoadBalancer;
import io.grpc.xds.XdsLoadBalancerProvider;
import java.util.Map;

@Internal
public class EdsLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "eds_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new EdsLoadBalancer(helper, new EdsLoadBalancer.ResourceUpdateCallback(){

            @Override
            public void onWorking() {
            }

            @Override
            public void onError() {
            }

            @Override
            public void onAllDrop() {
            }
        });
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return XdsLoadBalancerProvider.parseLoadBalancingConfigPolicy(rawLoadBalancingPolicyConfig, LoadBalancerRegistry.getDefaultRegistry());
    }
}

