/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsStore;
import io.grpc.xds.LoadStatsStoreImpl;
import io.grpc.xds.LocalityStore;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsLoadBalancerProvider;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class EdsLoadBalancer
extends LoadBalancer {
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final ResourceUpdateCallback resourceUpdateCallback;
    private final GracefulSwitchLoadBalancer switchingLoadBalancer;
    private final LoadBalancerRegistry lbRegistry;
    private final LocalityStore.LocalityStoreFactory localityStoreFactory;
    private final Bootstrapper bootstrapper;
    private final XdsClient.XdsChannelFactory channelFactory;
    private final LoadBalancer.Helper edsLbHelper;
    @Nullable
    private XdsLoadBalancerProvider.XdsConfig xdsConfig;
    @Nullable
    private ObjectPool<XdsClient> xdsClientPool;
    @Nullable
    private XdsClient xdsClient;
    @Nullable
    private String clusterName;

    EdsLoadBalancer(LoadBalancer.Helper edsLbHelper, ResourceUpdateCallback resourceUpdateCallback) {
        this(edsLbHelper, resourceUpdateCallback, LoadBalancerRegistry.getDefaultRegistry(), LocalityStore.LocalityStoreFactory.getInstance(), Bootstrapper.getInstance(), XdsClient.XdsChannelFactory.getInstance());
    }

    @VisibleForTesting
    EdsLoadBalancer(LoadBalancer.Helper edsLbHelper, ResourceUpdateCallback resourceUpdateCallback, LoadBalancerRegistry lbRegistry, LocalityStore.LocalityStoreFactory localityStoreFactory, Bootstrapper bootstrapper, XdsClient.XdsChannelFactory channelFactory) {
        this.edsLbHelper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)edsLbHelper, (Object)"edsLbHelper");
        this.resourceUpdateCallback = (ResourceUpdateCallback)Preconditions.checkNotNull((Object)resourceUpdateCallback, (Object)"resourceUpdateCallback");
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.localityStoreFactory = (LocalityStore.LocalityStoreFactory)Preconditions.checkNotNull((Object)localityStoreFactory, (Object)"localityStoreFactory");
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
        this.channelFactory = (XdsClient.XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory");
        this.switchingLoadBalancer = new GracefulSwitchLoadBalancer(edsLbHelper);
        this.logId = InternalLogId.allocate((String)"eds-lb", (String)edsLbHelper.getAuthority());
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        if (lbConfig == null) {
            this.edsLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Missing EDS lb config")));
            return;
        }
        XdsLoadBalancerProvider.XdsConfig newXdsConfig = (XdsLoadBalancerProvider.XdsConfig)lbConfig;
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS lb config: cluster={0}, child_policy={1}, fallback_policy={2}, eds_service_name={3}, report_load={4}", newXdsConfig.cluster, newXdsConfig.endpointPickingPolicy != null ? newXdsConfig.endpointPickingPolicy.getProvider().getPolicyName() : "", newXdsConfig.fallbackPolicy != null ? newXdsConfig.fallbackPolicy.getProvider().getPolicyName() : "", newXdsConfig.edsServiceName, newXdsConfig.lrsServerName != null);
        }
        if (this.xdsClientPool == null) {
            Attributes attributes = resolvedAddresses.getAttributes();
            this.xdsClientPool = (ObjectPool)attributes.get(XdsAttributes.XDS_CLIENT_POOL);
            if (this.xdsClientPool == null) {
                Bootstrapper.BootstrapInfo bootstrapInfo;
                try {
                    bootstrapInfo = this.bootstrapper.readBootstrap();
                }
                catch (Exception e) {
                    this.edsLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Failed to bootstrap").withCause((Throwable)e)));
                    return;
                }
                final List<Bootstrapper.ServerInfo> serverList = bootstrapInfo.getServers();
                final Node node = bootstrapInfo.getNode();
                if (serverList.isEmpty()) {
                    this.edsLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("No management server provided by bootstrap")));
                    return;
                }
                XdsClient.XdsClientFactory xdsClientFactory = new XdsClient.XdsClientFactory(){

                    @Override
                    XdsClient createXdsClient() {
                        return new XdsClientImpl(EdsLoadBalancer.this.edsLbHelper.getAuthority(), serverList, EdsLoadBalancer.this.channelFactory, node, EdsLoadBalancer.this.edsLbHelper.getSynchronizationContext(), EdsLoadBalancer.this.edsLbHelper.getScheduledExecutorService(), (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER);
                    }
                };
                this.xdsClientPool = new XdsClient.RefCountedXdsClientObjectPool(xdsClientFactory);
            } else {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Use xDS client from channel");
            }
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        String string = this.clusterName = newXdsConfig.cluster != null ? newXdsConfig.cluster : this.edsLbHelper.getAuthority();
        if (this.xdsConfig == null || !Objects.equals(newXdsConfig.edsServiceName, this.xdsConfig.edsServiceName)) {
            ClusterEndpointsBalancerFactory clusterEndpointsLoadBalancerFactory = new ClusterEndpointsBalancerFactory(newXdsConfig.edsServiceName);
            this.switchingLoadBalancer.switchTo((LoadBalancer.Factory)clusterEndpointsLoadBalancerFactory);
        }
        this.switchingLoadBalancer.handleResolvedAddresses(resolvedAddresses);
        this.xdsConfig = newXdsConfig;
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchingLoadBalancer.handleNameResolutionError(error);
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.switchingLoadBalancer.shutdown();
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private final class EndpointWatcherImpl
    implements XdsClient.EndpointWatcher {
        final LocalityStore localityStore;
        boolean firstEndpointUpdateReceived;

        EndpointWatcherImpl(LocalityStore localityStore) {
            this.localityStore = localityStore;
        }

        @Override
        public void onEndpointChanged(XdsClient.EndpointUpdate endpointUpdate) {
            EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update: {0}", endpointUpdate);
            if (EdsLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received endpoint update from xDS client {0}: cluster_name={1}, {2} localities, {3} drop categories", EdsLoadBalancer.this.xdsClient, endpointUpdate.getClusterName(), endpointUpdate.getLocalityLbEndpointsMap().size(), endpointUpdate.getDropPolicies().size());
            }
            if (!this.firstEndpointUpdateReceived) {
                this.firstEndpointUpdateReceived = true;
                EdsLoadBalancer.this.resourceUpdateCallback.onWorking();
            }
            List<EnvoyProtoData.DropOverload> dropOverloads = endpointUpdate.getDropPolicies();
            ImmutableList.Builder dropOverloadsBuilder = ImmutableList.builder();
            for (EnvoyProtoData.DropOverload dropOverload : dropOverloads) {
                dropOverloadsBuilder.add((Object)dropOverload);
                if (dropOverload.getDropsPerMillion() != 1000000) continue;
                EdsLoadBalancer.this.resourceUpdateCallback.onAllDrop();
                break;
            }
            this.localityStore.updateDropPercentage((List<EnvoyProtoData.DropOverload>)dropOverloadsBuilder.build());
            ImmutableMap.Builder localityEndpointsMapping = new ImmutableMap.Builder();
            for (Map.Entry<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> entry : endpointUpdate.getLocalityLbEndpointsMap().entrySet()) {
                int localityWeight = entry.getValue().getLocalityWeight();
                if (localityWeight == 0) continue;
                localityEndpointsMapping.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            this.localityStore.updateLocalityStore((Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints>)localityEndpointsMapping.build());
        }

        @Override
        public void onError(Status error) {
            EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}: {2}", EdsLoadBalancer.this.xdsClient, error.getCode(), error.getDescription());
            EdsLoadBalancer.this.resourceUpdateCallback.onError();
            if (!this.firstEndpointUpdateReceived) {
                EdsLoadBalancer.this.edsLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }
        }
    }

    static interface ResourceUpdateCallback {
        public void onWorking();

        public void onError();

        public void onAllDrop();
    }

    private final class ClusterEndpointsBalancerFactory
    extends LoadBalancer.Factory {
        @Nullable
        final String clusterServiceName;
        final LoadStatsStore loadStatsStore;

        ClusterEndpointsBalancerFactory(String clusterServiceName) {
            this.clusterServiceName = clusterServiceName;
            this.loadStatsStore = new LoadStatsStoreImpl(EdsLoadBalancer.this.clusterName, clusterServiceName);
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ClusterEndpointsBalancer(helper);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClusterEndpointsBalancerFactory)) {
                return false;
            }
            ClusterEndpointsBalancerFactory that = (ClusterEndpointsBalancerFactory)((Object)o);
            return Objects.equals(this.clusterServiceName, that.clusterServiceName);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.clusterServiceName);
        }

        final class ClusterEndpointsBalancer
        extends LoadBalancer {
            final String resourceName;
            final LoadBalancer.Helper helper;
            final EndpointWatcherImpl endpointWatcher;
            final LocalityStore localityStore;
            boolean isReportingLoad;

            ClusterEndpointsBalancer(LoadBalancer.Helper helper) {
                this.helper = helper;
                this.resourceName = ClusterEndpointsBalancerFactory.this.clusterServiceName != null ? ClusterEndpointsBalancerFactory.this.clusterServiceName : EdsLoadBalancer.this.clusterName;
                this.localityStore = EdsLoadBalancer.this.localityStoreFactory.newLocalityStore(EdsLoadBalancer.this.logId, helper, EdsLoadBalancer.this.lbRegistry, ClusterEndpointsBalancerFactory.this.loadStatsStore);
                this.endpointWatcher = new EndpointWatcherImpl(this.localityStore);
                EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start endpoint watcher on {0} with xDS client {1}", this.resourceName, EdsLoadBalancer.this.xdsClient);
                EdsLoadBalancer.this.xdsClient.watchEndpointData(this.resourceName, this.endpointWatcher);
            }

            public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                XdsLoadBalancerProvider.XdsConfig config = (XdsLoadBalancerProvider.XdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
                if (config.lrsServerName != null) {
                    if (!config.lrsServerName.equals("")) {
                        throw new AssertionError((Object)"Can only report load to the same management server");
                    }
                    if (!this.isReportingLoad) {
                        EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start reporting loads for cluster: {0}, cluster_service: {1}", EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName);
                        EdsLoadBalancer.this.xdsClient.reportClientStats(EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName, ClusterEndpointsBalancerFactory.this.loadStatsStore);
                        this.isReportingLoad = true;
                    }
                } else if (this.isReportingLoad) {
                    EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop reporting loads for cluster: {0}, cluster_service: {1}", EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName);
                    EdsLoadBalancer.this.xdsClient.cancelClientStatsReport(EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName);
                    this.isReportingLoad = false;
                }
            }

            public void handleNameResolutionError(Status error) {
                if (!this.endpointWatcher.firstEndpointUpdateReceived) {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }

            public boolean canHandleEmptyAddressListFromNameResolution() {
                return true;
            }

            public void shutdown() {
                if (this.isReportingLoad) {
                    EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop reporting loads for cluster: {0}, cluster_service: {1}", EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName);
                    EdsLoadBalancer.this.xdsClient.cancelClientStatsReport(EdsLoadBalancer.this.clusterName, ClusterEndpointsBalancerFactory.this.clusterServiceName);
                    this.isReportingLoad = false;
                }
                this.localityStore.reset();
                EdsLoadBalancer.this.xdsClient.cancelEndpointDataWatch(this.resourceName, this.endpointWatcher);
                EdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled endpoint watcher on {0} with xDS client {1}", this.resourceName, EdsLoadBalancer.this.xdsClient);
            }
        }
    }
}

