/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ClientStreamTracer;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.util.ForwardingClientStreamTracer;
import io.grpc.xds.OrcaOobUtil;
import io.grpc.xds.OrcaPerRequestUtil;
import io.grpc.xds.shaded.com.github.udpa.udpa.data.orca.v1.OrcaLoadReport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
final class ClientLoadCounter {
    private static final int THREAD_BALANCING_FACTOR = 64;
    private final AtomicLong callsInProgress = new AtomicLong();
    private final AtomicLong callsSucceeded = new AtomicLong();
    private final AtomicLong callsFailed = new AtomicLong();
    private final AtomicLong callsIssued = new AtomicLong();
    private final MetricRecorder[] metricRecorders = new MetricRecorder[64];
    private boolean active;

    ClientLoadCounter() {
        for (int i = 0; i < 64; ++i) {
            this.metricRecorders[i] = new MetricRecorder();
        }
        this.active = true;
    }

    @VisibleForTesting
    ClientLoadCounter(long callsSucceeded, long callsInProgress, long callsFailed, long callsIssued) {
        this();
        this.callsSucceeded.set(callsSucceeded);
        this.callsInProgress.set(callsInProgress);
        this.callsFailed.set(callsFailed);
        this.callsIssued.set(callsIssued);
    }

    void recordCallStarted() {
        this.callsIssued.getAndIncrement();
        this.callsInProgress.getAndIncrement();
    }

    void recordCallFinished(Status status) {
        this.callsInProgress.getAndDecrement();
        if (status.isOk()) {
            this.callsSucceeded.getAndIncrement();
        } else {
            this.callsFailed.getAndIncrement();
        }
    }

    void recordMetric(String name, double value) {
        MetricRecorder recorder = this.metricRecorders[(int)(Thread.currentThread().getId() % 64L)];
        recorder.addValue(name, value);
    }

    ClientLoadSnapshot snapshot() {
        HashMap<String, MetricValue> aggregatedValues = new HashMap<String, MetricValue>();
        for (MetricRecorder recorder : this.metricRecorders) {
            Map<String, MetricValue> map = recorder.takeAll();
            for (Map.Entry<String, MetricValue> entry : map.entrySet()) {
                MetricValue curr = (MetricValue)aggregatedValues.get(entry.getKey());
                if (curr == null) {
                    curr = new MetricValue();
                    aggregatedValues.put(entry.getKey(), curr);
                }
                MetricValue diff = entry.getValue();
                curr.numReports += diff.numReports;
                curr.totalValue += diff.totalValue;
            }
        }
        return new ClientLoadSnapshot(this.callsSucceeded.getAndSet(0L), this.callsInProgress.get(), this.callsFailed.getAndSet(0L), this.callsIssued.getAndSet(0L), aggregatedValues);
    }

    void setActive(boolean value) {
        this.active = value;
    }

    boolean isActive() {
        return this.active;
    }

    @ThreadSafe
    static final class MetricsObservingSubchannelPicker
    extends TracerWrappingSubchannelPicker {
        private final OrcaPerRequestUtil.OrcaPerRequestReportListener listener;
        private final LoadBalancer.SubchannelPicker delegate;
        private final OrcaPerRequestUtil orcaPerRequestUtil;

        MetricsObservingSubchannelPicker(OrcaPerRequestUtil.OrcaPerRequestReportListener listener, LoadBalancer.SubchannelPicker delegate, OrcaPerRequestUtil orcaPerRequestUtil) {
            this.listener = (OrcaPerRequestUtil.OrcaPerRequestReportListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            this.delegate = (LoadBalancer.SubchannelPicker)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.orcaPerRequestUtil = (OrcaPerRequestUtil)Preconditions.checkNotNull((Object)orcaPerRequestUtil, (Object)"orcaPerRequestUtil");
        }

        @Override
        protected LoadBalancer.SubchannelPicker delegate() {
            return this.delegate;
        }

        @Override
        protected ClientStreamTracer.Factory wrapTracerFactory(ClientStreamTracer.Factory originFactory) {
            return this.orcaPerRequestUtil.newOrcaClientStreamTracerFactory(originFactory, this.listener);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(MetricsObservingSubchannelPicker.class).add("delegate", (Object)this.delegate).toString();
        }
    }

    @ThreadSafe
    static final class LoadRecordingSubchannelPicker
    extends TracerWrappingSubchannelPicker {
        private final ClientLoadCounter counter;
        private final LoadBalancer.SubchannelPicker delegate;

        LoadRecordingSubchannelPicker(ClientLoadCounter counter, LoadBalancer.SubchannelPicker delegate) {
            this.counter = (ClientLoadCounter)Preconditions.checkNotNull((Object)counter, (Object)"counter");
            this.delegate = (LoadBalancer.SubchannelPicker)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        protected LoadBalancer.SubchannelPicker delegate() {
            return this.delegate;
        }

        @Override
        protected ClientStreamTracer.Factory wrapTracerFactory(ClientStreamTracer.Factory originFactory) {
            return new LoadRecordingStreamTracerFactory(this.counter, originFactory);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(LoadRecordingSubchannelPicker.class).add("delegate", (Object)this.delegate).toString();
        }
    }

    @VisibleForTesting
    static abstract class TracerWrappingSubchannelPicker
    extends LoadBalancer.SubchannelPicker {
        private static final ClientStreamTracer NOOP_CLIENT_STREAM_TRACER = new ClientStreamTracer(){};
        private static final ClientStreamTracer.Factory NOOP_CLIENT_STREAM_TRACER_FACTORY = new ClientStreamTracer.Factory(){

            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                return NOOP_CLIENT_STREAM_TRACER;
            }
        };

        TracerWrappingSubchannelPicker() {
        }

        protected abstract LoadBalancer.SubchannelPicker delegate();

        protected abstract ClientStreamTracer.Factory wrapTracerFactory(ClientStreamTracer.Factory var1);

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            LoadBalancer.PickResult result = this.delegate().pickSubchannel(args);
            if (!result.getStatus().isOk()) {
                return result;
            }
            if (result.getSubchannel() == null) {
                return result;
            }
            ClientStreamTracer.Factory originFactory = result.getStreamTracerFactory();
            if (originFactory == null) {
                originFactory = NOOP_CLIENT_STREAM_TRACER_FACTORY;
            }
            return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)result.getSubchannel(), (ClientStreamTracer.Factory)this.wrapTracerFactory(originFactory));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("delegate", (Object)this.delegate()).toString();
        }
    }

    @ThreadSafe
    static final class MetricsRecordingListener
    implements OrcaPerRequestUtil.OrcaPerRequestReportListener,
    OrcaOobUtil.OrcaOobReportListener {
        private final ClientLoadCounter counter;

        MetricsRecordingListener(ClientLoadCounter counter) {
            this.counter = (ClientLoadCounter)Preconditions.checkNotNull((Object)counter, (Object)"counter");
        }

        @Override
        public void onLoadReport(OrcaLoadReport report) {
            this.counter.recordMetric("cpu_utilization", report.getCpuUtilization());
            this.counter.recordMetric("mem_utilization", report.getMemUtilization());
            for (Map.Entry<String, Double> entry : report.getRequestCostMap().entrySet()) {
                this.counter.recordMetric(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Double> entry : report.getUtilizationMap().entrySet()) {
                this.counter.recordMetric(entry.getKey(), entry.getValue());
            }
        }

        @VisibleForTesting
        ClientLoadCounter getCounter() {
            return this.counter;
        }
    }

    @ThreadSafe
    @VisibleForTesting
    static final class LoadRecordingStreamTracerFactory
    extends ClientStreamTracer.Factory {
        private final ClientStreamTracer.Factory delegate;
        private final ClientLoadCounter counter;

        LoadRecordingStreamTracerFactory(ClientLoadCounter counter, ClientStreamTracer.Factory delegate) {
            this.counter = (ClientLoadCounter)Preconditions.checkNotNull((Object)counter, (Object)"counter");
            this.delegate = (ClientStreamTracer.Factory)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            this.counter.recordCallStarted();
            final ClientStreamTracer delegateTracer = this.delegate.newClientStreamTracer(info, headers);
            return new ForwardingClientStreamTracer(){

                protected ClientStreamTracer delegate() {
                    return delegateTracer;
                }

                public void streamClosed(Status status) {
                    LoadRecordingStreamTracerFactory.this.counter.recordCallFinished(status);
                    this.delegate().streamClosed(status);
                }
            };
        }

        @VisibleForTesting
        ClientLoadCounter getCounter() {
            return this.counter;
        }

        @VisibleForTesting
        ClientStreamTracer.Factory delegate() {
            return this.delegate;
        }
    }

    private static class MetricRecorder {
        private Map<String, MetricValue> metricValues = new HashMap<String, MetricValue>();

        private MetricRecorder() {
        }

        synchronized void addValue(String metricName, double value) {
            MetricValue currValue = this.metricValues.get(metricName);
            if (currValue == null) {
                currValue = new MetricValue();
            }
            currValue.numReports++;
            currValue.totalValue += value;
            this.metricValues.put(metricName, currValue);
        }

        synchronized Map<String, MetricValue> takeAll() {
            Map<String, MetricValue> ret = this.metricValues;
            this.metricValues = new HashMap<String, MetricValue>();
            return ret;
        }
    }

    static final class MetricValue {
        private int numReports;
        private double totalValue;

        private MetricValue() {
            this(0, 0.0);
        }

        @VisibleForTesting
        MetricValue(int numReports, double totalValue) {
            this.numReports = numReports;
            this.totalValue = totalValue;
        }

        long getNumReports() {
            return this.numReports;
        }

        double getTotalValue() {
            return this.totalValue;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("numReports", this.numReports).add("totalValue", this.totalValue).toString();
        }
    }

    static final class ClientLoadSnapshot {
        @VisibleForTesting
        static final ClientLoadSnapshot EMPTY_SNAPSHOT = new ClientLoadSnapshot(0L, 0L, 0L, 0L, Collections.EMPTY_MAP);
        private final long callsSucceeded;
        private final long callsInProgress;
        private final long callsFailed;
        private final long callsIssued;
        private final Map<String, MetricValue> metricValues;

        @VisibleForTesting
        ClientLoadSnapshot(long callsSucceeded, long callsInProgress, long callsFailed, long callsIssued, Map<String, MetricValue> metricValues) {
            this.callsSucceeded = callsSucceeded;
            this.callsInProgress = callsInProgress;
            this.callsFailed = callsFailed;
            this.callsIssued = callsIssued;
            this.metricValues = (Map)Preconditions.checkNotNull(metricValues, (Object)"metricValues");
        }

        long getCallsSucceeded() {
            return this.callsSucceeded;
        }

        long getCallsInProgress() {
            return this.callsInProgress;
        }

        long getCallsFailed() {
            return this.callsFailed;
        }

        long getCallsIssued() {
            return this.callsIssued;
        }

        Map<String, MetricValue> getMetricValues() {
            return Collections.unmodifiableMap(this.metricValues);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("callsSucceeded", this.callsSucceeded).add("callsInProgress", this.callsInProgress).add("callsFailed", this.callsFailed).add("callsIssued", this.callsIssued).add("metricValues", this.metricValues).toString();
        }
    }
}

