/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.a2a.spec.SecurityScheme;
import io.a2a.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class HTTPAuthSecurityScheme
implements SecurityScheme {
    public static final String HTTP = "http";
    private final String bearerFormat;
    private final String scheme;
    private final String description;
    private final String type;

    public HTTPAuthSecurityScheme(String bearerFormat, String scheme, String description) {
        this(bearerFormat, scheme, description, HTTP);
    }

    @JsonCreator
    public HTTPAuthSecurityScheme(@JsonProperty(value="bearerFormat") String bearerFormat, @JsonProperty(value="scheme") String scheme, @JsonProperty(value="description") String description, @JsonProperty(value="type") String type) {
        Assert.checkNotNullParam((String)"scheme", (Object)scheme);
        if (!type.equals(HTTP)) {
            throw new IllegalArgumentException("Invalid type for HTTPAuthSecurityScheme");
        }
        this.bearerFormat = bearerFormat;
        this.scheme = scheme;
        this.description = description;
        this.type = type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getType() {
        return this.type;
    }

    public static class Builder {
        private String bearerFormat;
        private String scheme;
        private String description;

        public Builder bearerFormat(String bearerFormat) {
            this.bearerFormat = bearerFormat;
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public HTTPAuthSecurityScheme build() {
            return new HTTPAuthSecurityScheme(this.bearerFormat, this.scheme, this.description);
        }
    }
}

