/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

public class AuthConfig {
    public static final AuthConfig EMPTY_AUTH_CONFIG = new AuthConfig("", "", "", "");
    private final String username;
    private final String password;
    private final String email;
    private final String auth;
    private final String authEncoded;

    public AuthConfig(Map<String, String> params) {
        this(params.get("username"), params.get("password"), params.get("email"), params.get("auth"));
    }

    public AuthConfig(String username, String password, String email, String auth) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.auth = auth;
        this.authEncoded = this.createAuthEncoded();
    }

    public AuthConfig(String credentialsEncoded, String email) {
        String credentials = new String(Base64.decodeBase64((String)credentialsEncoded));
        String[] parsedCreds = credentials.split(":", 2);
        this.username = parsedCreds[0];
        this.password = parsedCreds[1];
        this.email = email;
        this.auth = null;
        this.authEncoded = this.createAuthEncoded();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAuth() {
        return this.auth;
    }

    public String toHeaderValue() {
        return this.authEncoded;
    }

    private String createAuthEncoded() {
        JSONObject ret = new JSONObject();
        this.putNonNull(ret, "username", this.username);
        this.putNonNull(ret, "password", this.password);
        this.putNonNull(ret, "email", this.email);
        this.putNonNull(ret, "auth", this.auth);
        try {
            return Base64.encodeBase64String((byte[])ret.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return Base64.encodeBase64String((byte[])ret.toString().getBytes());
        }
    }

    private void putNonNull(JSONObject ret, String key, String value) {
        if (value != null) {
            ret.put(key, (Object)value);
        }
    }
}

