/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.sjavac.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;

class PortFile {
    private static final int magicNr = 4468;
    private String filename;
    private File file;
    private File stopFile;
    private RandomAccessFile rwfile;
    private FileChannel channel;
    private FileLock lock;
    private boolean containsPortInfo;
    private int serverPort;
    private long serverCookie;
    private int myServerPort;
    private long myServerCookie;

    public PortFile(String string) throws FileNotFoundException {
        this.filename = string;
        this.file = new File(this.filename);
        this.stopFile = new File(this.filename + ".stop");
        this.rwfile = new RandomAccessFile(this.file, "rw");
        this.channel = this.rwfile.getChannel();
        this.containsPortInfo = false;
        this.lock = null;
    }

    void lock() throws IOException {
        this.lock = this.channel.lock();
    }

    public void getValues() {
        this.containsPortInfo = false;
        if (this.lock == null) {
            return;
        }
        try {
            if (this.rwfile.length() > 0L) {
                this.rwfile.seek(0L);
                int n = this.rwfile.readInt();
                this.serverPort = this.rwfile.readInt();
                this.serverCookie = this.rwfile.readLong();
                this.containsPortInfo = n == 4468;
            }
        }
        catch (Exception exception) {
            this.containsPortInfo = false;
        }
    }

    public boolean containsPortInfo() {
        return this.containsPortInfo;
    }

    public int getPort() {
        assert (this.containsPortInfo);
        return this.serverPort;
    }

    public long getCookie() {
        assert (this.containsPortInfo);
        return this.serverCookie;
    }

    public void setValues(int n, long l) throws IOException {
        assert (this.lock != null);
        this.rwfile.seek(0L);
        this.rwfile.writeInt(4468);
        this.rwfile.writeInt(n);
        this.rwfile.writeLong(l);
        this.myServerPort = n;
        this.myServerCookie = l;
    }

    public void delete() throws IOException {
        this.rwfile.close();
        this.file.delete();
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean markedForStop() throws IOException {
        if (this.stopFile.exists()) {
            try {
                this.stopFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void unlock() throws IOException {
        assert (this.lock != null);
        this.lock.release();
        this.lock = null;
    }

    public synchronized boolean waitForValidValues() throws IOException, FileNotFoundException {
        for (int i = 0; i < 50; ++i) {
            this.lock();
            this.getValues();
            this.unlock();
            if (this.containsPortInfo) {
                Log.debug("Found valid values in port file after waiting " + i * 100 + "ms");
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.debug("Gave up waiting for valid values in port file");
        return false;
    }

    /*
     * Loose catch block
     */
    public synchronized boolean stillMyValues() throws IOException, FileNotFoundException {
        while (true) {
            try {
                this.lock();
                this.getValues();
                this.unlock();
                if (this.containsPortInfo) {
                    return this.serverPort == this.myServerPort && this.serverCookie == this.myServerCookie;
                }
                return false;
            }
            catch (FileLockInterruptionException fileLockInterruptionException) {
                continue;
            }
            break;
        }
        catch (ClosedChannelException closedChannelException) {
            return false;
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

