/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.server.CompilerPool;
import com.sun.tools.sjavac.server.CompilerThread;
import com.sun.tools.sjavac.server.PortFile;
import com.sun.tools.sjavac.server.SysInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class JavacServer {
    private final ServerSocket serverSocket;
    private final long myCookie;
    private long serverStart = System.currentTimeMillis();
    private long totalBuildTime;
    PrintWriter theLog;
    CompilerPool compilerPool;
    private static Map<String, PortFile> allPortFiles;
    private static Map<String, Long> maxServerMemory;
    static final int ERROR_FATAL = -1;
    static final int ERROR_BUT_TRY_AGAIN = -4712;
    static final String PROTOCOL_COOKIE_VERSION = "----THE-COOKIE-V2----";
    static final String PROTOCOL_CWD = "----THE-CWD----";
    static final String PROTOCOL_ID = "----THE-ID----";
    static final String PROTOCOL_ARGS = "----THE-ARGS----";
    static final String PROTOCOL_SOURCES_TO_COMPILE = "----THE-SOURCES-TO-COMPILE----";
    static final String PROTOCOL_VISIBLE_SOURCES = "----THE-VISIBLE-SOURCES----";
    static final String PROTOCOL_END = "----THE-END----";
    static final String PROTOCOL_STDOUT = "----THE-STDOUT----";
    static final String PROTOCOL_STDERR = "----THE-STDERR----";
    static final String PROTOCOL_PACKAGE_ARTIFACTS = "----THE-PACKAGE_ARTIFACTS----";
    static final String PROTOCOL_PACKAGE_DEPENDENCIES = "----THE-PACKAGE_DEPENDENCIES----";
    static final String PROTOCOL_PACKAGE_PUBLIC_APIS = "----THE-PACKAGE-PUBLIC-APIS----";
    static final String PROTOCOL_SYSINFO = "----THE-SYSINFO----";
    static final String PROTOCOL_RETURN_CODE = "----THE-RETURN-CODE----";
    static int CHECK_PORTFILE_INTERVAL;
    static int CONNECTION_TIMEOUT;
    static int WAIT_BETWEEN_CONNECT_ATTEMPTS;
    static int MAX_NUM_CONNECT_ATTEMPTS;

    private static synchronized PortFile getPortFile(String string) throws FileNotFoundException {
        PortFile portFile;
        if (allPortFiles == null) {
            allPortFiles = new HashMap<String, PortFile>();
        }
        if ((portFile = allPortFiles.get(string)) == null) {
            portFile = new PortFile(string);
            allPortFiles.put(string, portFile);
        }
        return portFile;
    }

    long getCookie() {
        return this.myCookie;
    }

    int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void addBuildTime(long l) {
        this.totalBuildTime += l;
    }

    public void log(String string) {
        if (this.theLog != null) {
            this.theLog.println(string);
        } else {
            System.err.println(string);
        }
    }

    public void flushLog() {
        if (this.theLog != null) {
            this.theLog.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startServer(String string, PrintStream printStream) {
        try {
            JavacServer javacServer;
            PortFile portFile;
            int n;
            String string2 = Util.extractStringOption("portfile", string);
            String string3 = Util.extractStringOption("logfile", string);
            String string4 = Util.extractStringOption("stdouterrfile", string);
            int n2 = Util.extractIntOption("poolsize", string);
            if (n2 <= 0) {
                n2 = Runtime.getRuntime().availableProcessors();
            }
            if ((n = Util.extractIntOption("keepalive", string)) <= 0) {
                n = 120;
            }
            PortFile portFile2 = portFile = JavacServer.getPortFile(string2);
            synchronized (portFile2) {
                portFile.lock();
                portFile.getValues();
                if (portFile.containsPortInfo()) {
                    printStream.println("Javac server not started because portfile exists!");
                    portFile.unlock();
                    return -1;
                }
                javacServer = new JavacServer(n2, string3);
                portFile.setValues(javacServer.getPort(), javacServer.getCookie());
                portFile.unlock();
            }
            javacServer.run(portFile, printStream, n);
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int useServer(String string, String[] stringArray, Set<URI> set, Set<URI> set2, Map<URI, Set<String>> map, Map<String, Set<URI>> map2, Map<String, Set<String>> map3, Map<String, String> map4, SysInfo sysInfo, PrintStream printStream, PrintStream printStream2) {
        try {
            String string2 = Util.extractStringOption("id", string);
            String string3 = Util.extractStringOption("portfile", string);
            String string4 = Util.extractStringOption("logfile", string);
            String string5 = Util.extractStringOption("stdouterrfile", string);
            String string6 = Util.extractStringOption("background", string);
            if (string6 == null || !string6.equals("false")) {
                string6 = "true";
            }
            String string7 = Util.extractStringOption("sjavac", string);
            int n = Util.extractIntOption("poolsize", string);
            int n2 = Util.extractIntOption("keepalive", string);
            if (n2 <= 0) {
                n2 = 120;
            }
            if (string3 == null) {
                printStream2.println("No portfile was specified!");
                return -1;
            }
            if (string4 == null) {
                string4 = string3 + ".javaclog";
            }
            if (string5 == null) {
                string5 = string3 + ".stdouterr";
            }
            if (string7 == null) {
                string7 = "sjavac";
            }
            int n3 = 0;
            int n4 = -1;
            do {
                PortFile portFile = JavacServer.getPortFile(string3);
                Object object = portFile;
                synchronized (object) {
                    portFile.lock();
                    portFile.getValues();
                    portFile.unlock();
                }
                if (!portFile.containsPortInfo()) {
                    object = JavacServer.fork(string7, portFile.getFilename(), string4, n, n2, printStream2, string5, string6);
                    if (string6.equals("true") && !portFile.waitForValidValues()) {
                        JavacServer.printFailedAttempt((String)object, string5, printStream2);
                        return -1;
                    }
                }
                if ((n4 = JavacServer.connectAndCompile(portFile, string2, stringArray, set, set2, map2, map3, map4, sysInfo, printStream, printStream2)) != -4712) continue;
                ++n3;
                try {
                    Thread.sleep(WAIT_BETWEEN_CONNECT_ATTEMPTS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (n4 == -4712 && n3 < MAX_NUM_CONNECT_ATTEMPTS);
            return n4;
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream2);
            return -1;
        }
    }

    private static void printFailedAttempt(String string, String string2, PrintStream printStream) {
        printStream.println("---- Failed to start javac server with this command -----");
        printStream.println(string);
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            printStream.println("---- stdout/stderr output from attempt to start javac server -----");
            while ((string3 = bufferedReader.readLine()) != null) {
                printStream.println(string3);
            }
            printStream.println("------------------------------------------------------------------");
        }
        catch (Exception exception) {
            printStream.println("The stdout/stderr output in file " + string2 + " does not exist and the server did not start.");
        }
    }

    private JavacServer(int n, String string) throws IOException {
        this.serverSocket = new ServerSocket(0, 128, InetAddress.getByName(null));
        this.compilerPool = new CompilerPool(n, this);
        Random random = new Random();
        this.myCookie = random.nextLong();
        this.theLog = new PrintWriter(string);
        this.log("Javac server started. port=" + this.getPort() + " date=" + new Date() + " with poolsize=" + n);
        this.flushLog();
    }

    private static String fork(String string, String string2, String string3, int n, int n2, final PrintStream printStream, String string4, String string5) throws IOException, ProblemException {
        if (string4 != null && string4.trim().equals("")) {
            string4 = null;
        }
        final String string6 = "--startserver:portfile=" + string2 + ",logfile=" + string3 + ",stdouterrfile=" + string4 + ",poolsize=" + n + ",keepalive=" + n2;
        if (string5.equals("true")) {
            Object object;
            string = string + "%20" + string6;
            string = string.replaceAll("%20", " ");
            string = string.replaceAll("%2C", ",");
            String[] stringArray = new String[]{"/bin/sh", "-c", string + " >> " + string4 + " 2>&1"};
            if (!new File("/bin/sh").canExecute()) {
                object = new ArrayList<String>();
                ((ArrayList)object).add("cmd");
                ((ArrayList)object).add("/c");
                ((ArrayList)object).add("start");
                ((ArrayList)object).add("cmd");
                ((ArrayList)object).add("/c");
                ((ArrayList)object).add(string + " >> " + string4 + " 2>&1");
                stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
            }
            object = null;
            try {
                object = Runtime.getRuntime().exec(stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
                exception.printStackTrace(new PrintWriter(string4));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string7 : stringArray) {
                stringBuilder.append(string7 + " ");
            }
            return stringBuilder.toString();
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JavacServer.startServer(string6, printStream);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(printStream);
                }
            }
        };
        thread.start();
        return "";
    }

    private static boolean expect(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = bufferedReader.readLine();
        return string2 != null && string2.equals(string);
    }

    public static SysInfo connectGetSysInfo(String string, PrintStream printStream, PrintStream printStream2) {
        SysInfo sysInfo = new SysInfo(-1, -1L);
        String string2 = Util.extractStringOption("id", string);
        String string3 = Util.extractStringOption("portfile", string);
        try {
            PortFile portFile = JavacServer.getPortFile(string3);
            JavacServer.useServer(string, new String[0], new HashSet<URI>(), new HashSet<URI>(), new HashMap<URI, Set<String>>(), new HashMap<String, Set<URI>>(), new HashMap<String, Set<String>>(), new HashMap<String, String>(), sysInfo, printStream, printStream2);
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream2);
        }
        return sysInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static int connectAndCompile(PortFile portFile, String string, String[] stringArray, Set<URI> set, Set<URI> set2, Map<String, Set<URI>> map, Map<String, Set<String>> map2, Map<String, String> map3, SysInfo sysInfo, PrintStream printStream, PrintStream printStream2) {
        int n = -3;
        try {
            Object object;
            Object object3;
            Object object2;
            Object object4;
            int n2;
            int n3 = n2 = portFile.containsPortInfo() ? portFile.getPort() : 0;
            if (n2 == 0) {
                return -4712;
            }
            long l = portFile.getCookie();
            InetAddress inetAddress = InetAddress.getByName(null);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
            Socket socket = new Socket();
            int n4 = CONNECTION_TIMEOUT * 1000;
            try {
                socket.connect(inetSocketAddress, n4);
            }
            catch (ConnectException connectException) {
                printStream2.println("Could not connect to javac server found in portfile: " + portFile.getFilename() + " " + connectException);
                return -4712;
            }
            if (!socket.isConnected()) {
                printStream2.println("Could not connect to javac server found in portfile: " + portFile.getFilename());
                return -4712;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
            printWriter.println(PROTOCOL_COOKIE_VERSION);
            printWriter.println("" + l);
            printWriter.println(PROTOCOL_CWD);
            printWriter.println(System.getProperty("user.dir"));
            printWriter.println(PROTOCOL_ID);
            printWriter.println(string);
            printWriter.println(PROTOCOL_ARGS);
            for (String object62 : stringArray) {
                object4 = new StringBuffer();
                object2 = object62.split(File.pathSeparator);
                int n5 = 0;
                for (String string2 : object2) {
                    File file = new File(string2);
                    if (file.isFile() || file.isDirectory()) {
                        ((StringBuffer)object4).append(file.getAbsolutePath());
                        if (++n5 >= ((String[])object2).length) continue;
                        ((StringBuffer)object4).append(File.pathSeparator);
                        continue;
                    }
                    object4 = new StringBuffer(object62);
                    break;
                }
                printWriter.println(((StringBuffer)object4).toString());
            }
            printWriter.println(PROTOCOL_SOURCES_TO_COMPILE);
            for (URI uRI : set) {
                printWriter.println(uRI.toString());
            }
            printWriter.println(PROTOCOL_VISIBLE_SOURCES);
            for (URI uRI : set2) {
                printWriter.println(uRI.toString());
            }
            printWriter.println(PROTOCOL_END);
            printWriter.flush();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (!JavacServer.expect(bufferedReader, PROTOCOL_STDOUT)) {
                return -1;
            }
            while (true) {
                if ((object3 = bufferedReader.readLine()) == null) {
                    return -1;
                }
                if (((String)object3).equals(PROTOCOL_STDERR)) break;
                stringBuffer.append((String)object3);
                stringBuffer.append('\n');
            }
            while (true) {
                if ((object3 = bufferedReader.readLine()) == null) {
                    return -1;
                }
                if (((String)object3).equals(PROTOCOL_PACKAGE_ARTIFACTS)) break;
                stringBuffer2.append((String)object3);
                stringBuffer2.append('\n');
            }
            object3 = null;
            while (true) {
                String string3;
                if ((string3 = bufferedReader.readLine()) == null) {
                    return -1;
                }
                if (string3.equals(PROTOCOL_PACKAGE_DEPENDENCIES)) break;
                if (string3.length() > 1 && string3.charAt(0) == '+') {
                    object4 = string3.substring(1);
                    object3 = new HashSet();
                    map.put((String)object4, (Set<URI>)object3);
                    continue;
                }
                if (string3.length() <= 1 || object3 == null) continue;
                object3.add(new URI(string3.substring(1)));
            }
            Object var24_32 = null;
            while (true) {
                void var24_33;
                if ((object4 = bufferedReader.readLine()) == null) {
                    return -1;
                }
                if (((String)object4).equals(PROTOCOL_PACKAGE_PUBLIC_APIS)) break;
                if (((String)object4).length() > 1 && ((String)object4).charAt(0) == '+') {
                    object2 = ((String)object4).substring(1);
                    HashSet hashSet = new HashSet();
                    map2.put((String)object2, hashSet);
                    continue;
                }
                if (((String)object4).length() <= 1 || var24_33 == null) continue;
                var24_33.add(((String)object4).substring(1));
            }
            object4 = new HashMap();
            object2 = null;
            while (true) {
                if ((object = bufferedReader.readLine()) == null) {
                    return -1;
                }
                if (((String)object).equals(PROTOCOL_SYSINFO)) break;
                if (((String)object).length() > 1 && ((String)object).charAt(0) == '+') {
                    String string4 = ((String)object).substring(1);
                    object2 = new StringBuffer();
                    object4.put(string4, object2);
                    continue;
                }
                if (((String)object).length() <= 1 || object2 == null) continue;
                ((StringBuffer)object2).append(((String)object).substring(1));
                ((StringBuffer)object2).append("\n");
            }
            object = object4.keySet().iterator();
            while (object.hasNext()) {
                String string5 = (String)object.next();
                assert (map3.get(string5) == null);
                String string6 = ((StringBuffer)object4.get(string5)).toString();
                map3.put(string5, string6);
            }
            while (true) {
                if ((object = bufferedReader.readLine()) == null) {
                    return -1;
                }
                if (((String)object).equals(PROTOCOL_RETURN_CODE)) break;
                if (((String)object).startsWith("num_cores=") && sysInfo != null) {
                    sysInfo.numCores = Integer.parseInt(((String)object).substring(10));
                }
                if (!((String)object).startsWith("max_memory=") || sysInfo == null) continue;
                sysInfo.maxMemory = Long.parseLong(((String)object).substring(11));
            }
            object = bufferedReader.readLine();
            if (object == null) {
                printStream2.println("No return value from the server!");
                return -1;
            }
            n = Integer.parseInt((String)object);
            printStream.print(stringBuffer);
            printStream2.print(stringBuffer2);
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(PortFile portFile, PrintStream printStream, int n) {
        boolean bl = false;
        try {
            this.serverSocket.setSoTimeout(CHECK_PORTFILE_INTERVAL * 1000);
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.serverSocket.accept();
                        CompilerThread compilerThread = this.compilerPool.grabCompilerThread();
                        compilerThread.setSocket(socket);
                        this.compilerPool.execute(compilerThread);
                        this.flushLog();
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (this.compilerPool.numActiveRequests() > 0) continue;
                    if (bl) {
                        this.log("Quitting because of " + (n + CHECK_PORTFILE_INTERVAL) + " seconds of inactivity!");
                    } else if (!portFile.exists()) {
                        this.log("Quitting because portfile was deleted!");
                        this.flushLog();
                    } else if (portFile.markedForStop()) {
                        this.log("Quitting because a portfile.stop file was found!");
                        portFile.delete();
                        this.flushLog();
                    } else if (!portFile.stillMyValues()) {
                        this.log("Quitting because portfile is now owned by another javac server!");
                        this.flushLog();
                    } else {
                        long l = System.currentTimeMillis() - this.compilerPool.lastRequestFinished();
                        if (l < (long)(n * 1000)) continue;
                        portFile.delete();
                        bl = true;
                        this.log("" + n + " seconds of inactivity quitting in " + CHECK_PORTFILE_INTERVAL + " seconds!");
                        this.flushLog();
                        continue;
                    }
                    this.compilerPool.shutdown();
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream);
            exception.printStackTrace(this.theLog);
            this.flushLog();
        }
        finally {
            this.compilerPool.shutdown();
        }
        long l = System.currentTimeMillis() - this.serverStart;
        this.log("Shutting down.");
        this.log("Total wall clock time " + l + "ms build time " + this.totalBuildTime + "ms");
        this.flushLog();
    }

    public static void cleanup(String ... stringArray) {
        String string = Util.findServerSettings(stringArray);
        if (string == null) {
            return;
        }
        String string2 = Util.extractStringOption("portfile", string);
        String string3 = Util.extractStringOption("background", string);
        if (string3 != null && string3.equals("false")) {
            File file = new File(string2);
            file.delete();
        }
    }

    static {
        CHECK_PORTFILE_INTERVAL = 5;
        CONNECTION_TIMEOUT = 2;
        WAIT_BETWEEN_CONNECT_ATTEMPTS = 1;
        MAX_NUM_CONNECT_ATTEMPTS = 3;
    }
}

