/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.sjavac.comp.Dependencies;
import com.sun.tools.sjavac.comp.JavaCompilerWithDeps;
import com.sun.tools.sjavac.comp.ResolveWithDeps;
import com.sun.tools.sjavac.comp.SmartFileManager;
import com.sun.tools.sjavac.server.CompilerPool;
import com.sun.tools.sjavac.server.JavacServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class CompilerThread
implements Runnable {
    private JavacServer javacServer;
    private CompilerPool compilerPool;
    private List<Future<?>> subTasks;
    private Socket socket;
    private JavacTool compiler;
    private StandardJavaFileManager fileManager;
    private BaseFileManager fileManagerBase;
    private SmartFileManager smartFileManager;
    private Context context;
    private boolean inUse = false;
    String id = "";
    PrintWriter stdout;
    PrintWriter stderr;
    int forcedExitCode = 0;

    CompilerThread(CompilerPool compilerPool) {
        this.compilerPool = compilerPool;
        this.javacServer = compilerPool.getJavacServer();
    }

    public synchronized void executeSubtask(Runnable runnable) {
        this.subTasks.add(this.compilerPool.executeSubtask(this, runnable));
    }

    public synchronized int numActiveSubTasks() {
        int n = 0;
        for (Future<?> future : this.subTasks) {
            if (future.isDone() || future.isCancelled()) continue;
            ++n;
        }
        return n;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized void use() {
        assert (!this.inUse);
        this.inUse = true;
        this.compiler = JavacTool.create();
        this.fileManager = this.compiler.getStandardFileManager((DiagnosticListener)null, (Locale)null, (Charset)null);
        this.fileManagerBase = (BaseFileManager)((Object)this.fileManager);
        this.smartFileManager = new SmartFileManager(this.fileManager);
        this.context = new Context();
        this.context.put(JavaFileManager.class, this.smartFileManager);
        ResolveWithDeps.preRegister(this.context);
        JavaCompilerWithDeps.preRegister(this.context, this);
        this.subTasks = new ArrayList();
    }

    public synchronized void unuse() {
        assert (this.inUse);
        this.inUse = false;
        this.compiler = null;
        this.fileManager = null;
        this.fileManagerBase = null;
        this.smartFileManager = null;
        this.context = null;
        this.subTasks = null;
    }

    private static boolean expect(BufferedReader bufferedReader, String string) throws IOException {
        String string2 = bufferedReader.readLine();
        return string2 != null && string2.equals(string);
    }

    public String currentRequestId() {
        return this.id;
    }

    public void logError(String string) {
        this.stderr.println(string);
        this.forcedExitCode = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = this.compilerPool.startRequest();
        long l = System.currentTimeMillis();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        this.use();
        PrintWriter printWriter = null;
        try {
            Map<String, String> map;
            String[] stringArray;
            Object object;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            this.javacServer.log("<" + n + "> Connect from " + this.socket.getRemoteSocketAddress() + " activethreads=" + this.compilerPool.numActiveRequests());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            printWriter = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            if (!CompilerThread.expect(bufferedReader, "----THE-COOKIE-V2----")) {
                this.javacServer.log("<" + n + "> Bad protocol from ip " + this.socket.getRemoteSocketAddress());
                return;
            }
            String string = bufferedReader.readLine();
            if (string == null || !string.equals("" + this.javacServer.getCookie())) {
                this.javacServer.log("<" + n + "> Bad cookie from ip " + this.socket.getRemoteSocketAddress());
                return;
            }
            if (!CompilerThread.expect(bufferedReader, "----THE-CWD----")) {
                return;
            }
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return;
            }
            if (!CompilerThread.expect(bufferedReader, "----THE-ID----")) {
                return;
            }
            this.id = bufferedReader.readLine();
            if (this.id == null) {
                return;
            }
            if (!CompilerThread.expect(bufferedReader, "----THE-ARGS----")) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            List<File> list = Arrays.asList(new File(string2));
            while (true) {
                if ((object11 = bufferedReader.readLine()) == null) {
                    return;
                }
                if (((String)object11).equals("----THE-SOURCES-TO-COMPILE----")) break;
                if (((String)object11).startsWith("--server:")) continue;
                if (!((String)object11).startsWith("-") && ((String)object11).endsWith(".java")) {
                    arrayList2.add(new File((String)object11));
                    ++n2;
                    continue;
                }
                arrayList.add((String)object11);
            }
            object11 = new HashSet();
            while (true) {
                if ((object10 = bufferedReader.readLine()) == null) {
                    return;
                }
                if (((String)object10).equals("----THE-VISIBLE-SOURCES----")) break;
                try {
                    object11.add(new URI((String)object10));
                    ++n2;
                }
                catch (URISyntaxException uRISyntaxException) {
                    try {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        if (!this.socket.isClosed()) {
                            this.socket.close();
                        }
                        this.socket = null;
                    }
                    catch (Exception exception) {
                        this.javacServer.log("ERROR " + exception);
                        exception.printStackTrace();
                    }
                    this.compilerPool.stopRequest();
                    long l2 = System.currentTimeMillis() - l;
                    this.javacServer.addBuildTime(l2);
                    float f = (float)n2 * (1000.0f / (float)l2);
                    this.javacServer.log(this.id + " <" + n + "> " + stringBuilder + " duration " + l2 + " ms    num_classes=" + n2 + "     classpersec=" + f + " subtasks=" + this.subTasks.size());
                    this.javacServer.flushLog();
                    this.unuse();
                    this.compilerPool.returnCompilerThread(this);
                    return;
                }
            }
            object10 = new HashSet();
            boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
            while (true) {
                if ((object9 = bufferedReader.readLine()) == null) {
                    return;
                }
                if (((String)object9).equals("----THE-END----")) break;
                try {
                    String object72;
                    object8 = new URI((String)object9);
                    if (bl && (object72 = ((URI)object8).toString()).startsWith("file:/") && Character.isUpperCase(object72.charAt(6))) {
                        object8 = new URI("file:/" + Character.toLowerCase(object72.charAt(6)) + object72.substring(7));
                    }
                    object10.add(object8);
                }
                catch (URISyntaxException uRISyntaxException) {
                    try {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        if (!this.socket.isClosed()) {
                            this.socket.close();
                        }
                        this.socket = null;
                    }
                    catch (Exception exception) {
                        this.javacServer.log("ERROR " + exception);
                        exception.printStackTrace();
                    }
                    this.compilerPool.stopRequest();
                    long l2 = System.currentTimeMillis() - l;
                    this.javacServer.addBuildTime(l2);
                    float f = (float)n2 * (1000.0f / (float)l2);
                    this.javacServer.log(this.id + " <" + n + "> " + stringBuilder + " duration " + l2 + " ms    num_classes=" + n2 + "     classpersec=" + f + " subtasks=" + this.subTasks.size());
                    this.javacServer.flushLog();
                    this.unuse();
                    this.compilerPool.returnCompilerThread(this);
                    return;
                }
            }
            object9 = new ListBuffer();
            for (JavaFileObject javaFileObject : this.fileManager.getJavaFileObjectsFromFiles(arrayList2)) {
                ((ListBuffer)object9).append(javaFileObject);
            }
            object8 = new ListBuffer<File>();
            Iterator iterator = object11.iterator();
            while (iterator.hasNext()) {
                URI uRI = (URI)iterator.next();
                ((ListBuffer)object8).append(new File(uRI));
            }
            for (JavaFileObject javaFileObject : this.fileManager.getJavaFileObjectsFromFiles((Iterable<? extends File>)object8)) {
                ((ListBuffer)object9).append(javaFileObject);
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string3 : arrayList) {
                stringBuilder2.append(">").append(string3).append("< ");
            }
            this.javacServer.log(this.id + " <" + n + "> options " + stringBuilder2.toString());
            this.forcedExitCode = 0;
            StringWriter stringWriter = new StringWriter();
            StringWriter stringWriter2 = new StringWriter();
            this.stdout = new PrintWriter(stringWriter);
            this.stderr = new PrintWriter(stringWriter2);
            Main.Result result = Main.Result.OK;
            try {
                if (((ListBuffer)object9).size() > 0) {
                    this.context.put(Log.outKey, this.stderr);
                    Log.instance(this.context).setWriter(Log.WriterKind.NOTICE, this.stdout);
                    Log.instance(this.context).setWriter(Log.WriterKind.WARNING, this.stderr);
                    Log.instance(this.context).setWriter(Log.WriterKind.ERROR, this.stderr);
                    JavacTool.processOptions(this.context, this.smartFileManager, arrayList);
                    this.fileManagerBase.setContext(this.context);
                    this.smartFileManager.setVisibleSources((Set<URI>)object10);
                    this.smartFileManager.cleanArtifacts();
                    this.smartFileManager.setLog(this.stdout);
                    Dependencies.instance(this.context).reset();
                    object = new Main("javacTask", this.stderr);
                    stringArray = arrayList.toArray(new String[0]);
                    result = ((Main)object).compile(stringArray, this.context, ((ListBuffer)object9).toList(), null);
                    while (this.numActiveSubTasks() > 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.smartFileManager.flush();
                }
            }
            catch (Exception exception) {
                this.stderr.println(exception.getMessage());
                this.forcedExitCode = -1;
            }
            printWriter.println("----THE-STDOUT----");
            printWriter.print(stringWriter);
            printWriter.println("----THE-STDERR----");
            printWriter.print(stringWriter2);
            printWriter.println("----THE-PACKAGE_ARTIFACTS----");
            object = this.smartFileManager.getPackageArtifacts();
            for (String string4 : object.keySet()) {
                printWriter.println("+" + string4);
                map = object.get(string4);
                Iterator<String> iterator2 = map.iterator();
                while (iterator2.hasNext()) {
                    URI uRI = (URI)iterator2.next();
                    printWriter.println(" " + uRI.toString());
                }
            }
            stringArray = Dependencies.instance(this.context);
            printWriter.println("----THE-PACKAGE_DEPENDENCIES----");
            Map<String, Set<String>> map2 = stringArray.getDependencies();
            for (Iterator<String> iterator2 : map2.keySet()) {
                printWriter.println("+" + iterator2);
                Set<String> set = map2.get(iterator2);
                if (!set.contains(":java.lang")) {
                    set.add(":java.lang");
                }
                for (String string5 : set) {
                    printWriter.println(" " + string5);
                }
            }
            printWriter.println("----THE-PACKAGE-PUBLIC-APIS----");
            map = stringArray.getPubapis();
            for (String string6 : map.keySet()) {
                printWriter.println("+" + string6);
                String string7 = map.get(string6);
                printWriter.println(string7);
                stringBuilder.append(string6 + " ");
            }
            printWriter.println("----THE-SYSINFO----");
            printWriter.println("num_cores=" + Runtime.getRuntime().availableProcessors());
            printWriter.println("max_memory=" + Runtime.getRuntime().maxMemory());
            printWriter.println("----THE-RETURN-CODE----");
            int n3 = result.exitCode;
            if (n3 == 0 && this.forcedExitCode != 0) {
                n3 = this.forcedExitCode;
            }
            printWriter.println("" + n3);
            printWriter.println("----THE-END----");
            printWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
                this.socket = null;
            }
            catch (Exception exception) {
                this.javacServer.log("ERROR " + exception);
                exception.printStackTrace();
            }
            this.compilerPool.stopRequest();
            long l4 = System.currentTimeMillis() - l;
            this.javacServer.addBuildTime(l4);
            float f = (float)n2 * (1000.0f / (float)l4);
            this.javacServer.log(this.id + " <" + n + "> " + stringBuilder + " duration " + l4 + " ms    num_classes=" + n2 + "     classpersec=" + f + " subtasks=" + this.subTasks.size());
            this.javacServer.flushLog();
            this.unuse();
            this.compilerPool.returnCompilerThread(this);
        }
    }
}

