/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;

public class PubapiVisitor
extends ElementScanner6<Void, Void> {
    StringBuffer sb;
    int indent = 1;

    public PubapiVisitor(StringBuffer stringBuffer) {
        this.sb = stringBuffer;
    }

    String depth(int n) {
        return "                                              ".substring(0, n);
    }

    @Override
    public Void visitType(TypeElement typeElement, Void void_) {
        if (typeElement.getModifiers().contains((Object)Modifier.PUBLIC) || typeElement.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.sb.append(this.depth(this.indent) + "TYPE " + typeElement.getQualifiedName() + "\n");
            this.indent += 2;
            Void void_2 = (Void)super.visitType(typeElement, void_);
            this.indent -= 2;
            return void_2;
        }
        return null;
    }

    @Override
    public Void visitVariable(VariableElement variableElement, Void void_) {
        if (variableElement.getModifiers().contains((Object)Modifier.PUBLIC) || variableElement.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.sb.append(this.depth(this.indent)).append("VAR ").append(this.makeVariableString(variableElement)).append("\n");
        }
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement executableElement, Void void_) {
        if (executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.sb.append(this.depth(this.indent)).append("METHOD ").append(this.makeMethodString(executableElement)).append("\n");
        }
        return null;
    }

    protected String makeMethodString(ExecutableElement executableElement) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Modifier object : executableElement.getModifiers()) {
            stringBuilder.append(object.toString());
            stringBuilder.append(" ");
        }
        stringBuilder.append(executableElement.getReturnType().toString());
        stringBuilder.append(" ");
        stringBuilder.append(executableElement.toString());
        List<? extends TypeMirror> list = executableElement.getThrownTypes();
        if (!list.isEmpty()) {
            stringBuilder.append(" throws ");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TypeMirror typeMirror = (TypeMirror)iterator.next();
                stringBuilder.append(typeMirror.toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    protected String makeVariableString(VariableElement variableElement) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Modifier modifier : variableElement.getModifiers()) {
            stringBuilder.append(modifier.toString());
            stringBuilder.append(" ");
        }
        stringBuilder.append(variableElement.asType().toString());
        stringBuilder.append(" ");
        stringBuilder.append(variableElement.toString());
        Object object = variableElement.getConstantValue();
        if (object != null) {
            stringBuilder.append(" = ");
            if (variableElement.asType().toString().equals("char")) {
                char c = object.toString().charAt(0);
                stringBuilder.append("'\\u" + Integer.toString(c, 16) + "'");
            } else {
                stringBuilder.append(object.toString());
            }
        }
        return stringBuilder.toString();
    }
}

