/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Source;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Package
implements Comparable<Package> {
    private Module mod;
    private String name;
    private String dirname;
    private Set<String> dependencies = new HashSet<String>();
    private Set<String> dependents = new HashSet<String>();
    private List<String> pubapi = new ArrayList<String>();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Map<String, File> artifacts = new HashMap<String, File>();

    public Package(Module module, String string) {
        int n = string.indexOf(":");
        assert (n != -1);
        String string2 = string.substring(0, n);
        assert (module.name().equals(module.name()));
        this.name = string;
        this.dirname = string.replace('.', File.separatorChar);
        if (module.name().length() > 0) {
            this.dirname = module.dirname() + File.separatorChar + this.dirname;
        }
    }

    public Module mod() {
        return this.mod;
    }

    public String name() {
        return this.name;
    }

    public String dirname() {
        return this.dirname;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public Map<String, File> artifacts() {
        return this.artifacts;
    }

    public List<String> pubapi() {
        return this.pubapi;
    }

    public Set<String> dependencies() {
        return this.dependencies;
    }

    public Set<String> dependents() {
        return this.dependents;
    }

    public boolean equals(Object object) {
        return object instanceof Package && this.name.equals(((Package)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Package package_) {
        return this.name.compareTo(package_.name);
    }

    public void addSource(Source source) {
        this.sources.put(source.file().getPath(), source);
    }

    public void addDependency(String string) {
        this.dependencies.add(string);
    }

    public void addDependent(String string) {
        this.dependents.add(string);
    }

    public void addPubapi(String string) {
        this.pubapi.add(string);
    }

    public boolean existsInJavacState() {
        return this.artifacts.size() > 0 || this.pubapi.size() > 0;
    }

    public static List<String> pubapiToList(String string) {
        String[] stringArray = string.split("\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public boolean hasPubapiChanged(List<String> list) {
        Iterator<String> iterator = list.iterator();
        Iterator<String> iterator2 = this.pubapi.iterator();
        int n = 0;
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string;
            String string2 = iterator.next();
            if (!string2.equals(string = iterator2.next())) {
                Log.debug("Change in pubapi for package " + this.name + " line " + n);
                Log.debug("Old: " + string);
                Log.debug("New: " + string2);
                return true;
            }
            ++n;
        }
        if (iterator.hasNext() && !iterator2.hasNext() || !iterator.hasNext() && iterator2.hasNext()) {
            Log.debug("Change in pubapi for package " + this.name);
            if (iterator.hasNext()) {
                Log.debug("New has more lines!");
            } else {
                Log.debug("Old has more lines!");
            }
            return true;
        }
        return false;
    }

    public void setPubapi(List<String> list) {
        this.pubapi = list;
    }

    public void setDependencies(Set<String> set) {
        this.dependencies = set;
    }

    public void save(StringBuilder stringBuilder) {
        stringBuilder.append("P ").append(this.name).append("\n");
        Source.saveSources(this.sources, stringBuilder);
        this.saveDependencies(stringBuilder);
        this.savePubapi(stringBuilder);
        this.saveArtifacts(stringBuilder);
    }

    public static Package load(Module module, String string) {
        String string2 = string.substring(2);
        return new Package(module, string2);
    }

    public void loadDependency(String string) {
        String string2 = string.substring(2);
        this.addDependency(string2);
    }

    public void loadPubapi(String string) {
        String string2 = string.substring(2);
        this.addPubapi(string2);
    }

    public void saveDependencies(StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.dependencies) {
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            stringBuilder.append("D " + string + "\n");
        }
    }

    public void savePubapi(StringBuilder stringBuilder) {
        for (String string : this.pubapi) {
            stringBuilder.append("I " + string + "\n");
        }
    }

    public static void savePackages(Map<String, Package> map, StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Package package_ = map.get(string);
            package_.save(stringBuilder);
        }
    }

    public void addArtifact(String string) {
        this.artifacts.put(string, new File(string));
    }

    public void addArtifact(File file) {
        this.artifacts.put(file.getPath(), file);
    }

    public void addArtifacts(Set<URI> set) {
        for (URI uRI : set) {
            this.addArtifact(new File(uRI));
        }
    }

    public void setArtifacts(Set<URI> set) {
        assert (!this.artifacts.isEmpty());
        this.artifacts = new HashMap<String, File>();
        this.addArtifacts(set);
    }

    public void loadArtifact(String string) {
        int n = string.indexOf(32, 2);
        String string2 = string.substring(2, n);
        long l = Long.parseLong(string.substring(n + 1));
        File file = new File(string2);
        if (file.exists() && file.lastModified() != l) {
            Log.debug("Removing " + file.getPath() + " since its timestamp does not match javac_state.");
            file.delete();
        }
        this.artifacts.put(file.getPath(), file);
    }

    public void saveArtifacts(StringBuilder stringBuilder) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : this.artifacts.values()) {
            arrayList.add(file);
        }
        Collections.sort(arrayList);
        for (File file : arrayList) {
            stringBuilder.append("A " + file.getPath() + " " + file.lastModified() + "\n");
        }
    }

    public void deleteArtifacts() {
        for (File file : this.artifacts.values()) {
            file.delete();
        }
    }
}

