/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.JavacState;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.server.JavacServer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private File bin_dir;
    private File gensrc_dir;
    private File header_dir;
    private File makefile_source_list;
    private JavacState javac_state;
    Map<String, Transformer> suffix_rules;

    public static void main(String ... stringArray) {
        if (stringArray.length > 0 && stringArray[0].startsWith("--startserver:")) {
            if (stringArray.length > 1) {
                Log.error("When spawning a background server, only a single --startserver argument is allowed.");
                return;
            }
            int n = JavacServer.startServer(stringArray[0], System.err);
            System.exit(n);
        }
        Main main = new Main();
        int n = main.go(stringArray, System.out, System.err);
        JavacServer.cleanup(stringArray);
        System.exit(n);
    }

    private void printHelp() {
        System.out.println("Usage: sjavac <options>\nwhere required options are:\ndir                        Compile all sources in dir recursively\n-d dir                     Store generated classes here and the javac_state file\n--server:portfile=/tmp/abc Use a background sjavac server\n\nAll other arguments as javac, except -implicit:none which is forced by default.\nNo java source files can be supplied on the command line, nor can an @file be supplied.\n\nWarning!\nThis tool might disappear at any time, and its command line options might change at any time!");
    }

    public int go(String[] stringArray, PrintStream printStream, PrintStream printStream2) {
        try {
            boolean bl;
            if (stringArray.length == 0 || this.findJavaSourceFiles(stringArray) || this.findAtFile(stringArray) || null == Util.findServerSettings(stringArray)) {
                this.printHelp();
                return 0;
            }
            Log.setLogLevel(this.findLogLevel(stringArray), printStream, printStream2);
            String string = Util.findServerSettings(stringArray);
            stringArray = Main.verifyImplicitOption(stringArray);
            stringArray = Main.addSrcBeforeDirectories(stringArray);
            Main.checkSrcOption(stringArray);
            this.bin_dir = Main.findDirectoryOption(stringArray, "-d", "output", true, false, true);
            this.gensrc_dir = Main.findDirectoryOption(stringArray, "-s", "gensrc", false, false, true);
            this.header_dir = Main.findDirectoryOption(stringArray, "-h", "headers", false, false, true);
            this.makefile_source_list = Main.findFileOption(stringArray, "--compare-found-sources", "makefile source list", false);
            this.javac_state = JavacState.load(stringArray, this.bin_dir, this.gensrc_dir, this.header_dir, Main.findBooleanOption(stringArray, "--permit-unidentified-artifacts"), printStream, printStream2);
            this.suffix_rules = this.javac_state.getJavaSuffixRule();
            Main.findTranslateOptions(stringArray, this.suffix_rules);
            if (this.suffix_rules.keySet().size() > 1 && this.gensrc_dir == null) {
                Log.error("You have translators but no gensrc dir (-s) specified!");
                return -1;
            }
            this.findCopyOptions(stringArray, this.suffix_rules);
            HashMap<String, Module> hashMap = new HashMap<String, Module>();
            Module module = new Module("", "");
            hashMap.put("", module);
            HashMap<String, Source> hashMap2 = new HashMap<String, Source>();
            this.findFiles(stringArray, "-src", this.suffix_rules.keySet(), hashMap2, hashMap, module, false);
            if (hashMap2.isEmpty()) {
                Log.error("Found nothing to compile!");
                return -1;
            }
            HashMap<String, Source> hashMap3 = new HashMap<String, Source>();
            this.findFiles(stringArray, "-src", Util.set(".java"), hashMap3, hashMap, module, true);
            this.findFiles(stringArray, "-sourcepath", Util.set(".java"), hashMap3, hashMap, module, true);
            Main.rewriteOptions(stringArray, "-src", "-sourcepath");
            this.javac_state.now().flattenPackagesSourcesAndArtifacts(hashMap);
            this.javac_state.now().checkInternalState("checking sources", false, hashMap2);
            this.javac_state.now().checkInternalState("checking linked sources", true, hashMap3);
            this.javac_state.setVisibleSources(hashMap3);
            this.javac_state.checkSourceStatus(false);
            this.javac_state.findAllArtifacts();
            if (!Main.findBooleanOption(stringArray, "--permit-unidentified-artifacts")) {
                this.javac_state.removeUnidentifiedArtifacts();
            }
            this.javac_state.taintPackagesThatMissArtifacts();
            this.javac_state.deleteClassArtifactsInTaintedPackages();
            this.javac_state.performCopying(this.bin_dir, this.suffix_rules);
            this.javac_state.performTranslation(this.gensrc_dir, this.suffix_rules);
            HashMap<String, Source> hashMap4 = new HashMap<String, Source>();
            Source.scanRoot(this.gensrc_dir, Util.set(".java"), null, null, null, null, hashMap4, hashMap, module, false, true, false);
            this.javac_state.now().flattenPackagesSourcesAndArtifacts(hashMap);
            this.javac_state.checkSourceStatus(true);
            this.javac_state.compareWithMakefileList(this.makefile_source_list);
            HashSet<String> hashSet = new HashSet<String>();
            boolean[] blArray = new boolean[1];
            do {
                this.javac_state.deleteClassArtifactsInTaintedPackages();
                bl = this.javac_state.performJavaCompilations(this.bin_dir, string, stringArray, hashSet, blArray);
            } while (blArray[0] && bl);
            if (blArray[0]) {
                this.javac_state.save();
                this.javac_state.now().flattenArtifacts(hashMap);
                this.javac_state.removeSuperfluousArtifacts(hashSet);
            }
            return blArray[0] ? 0 : -1;
        }
        catch (ProblemException problemException) {
            Log.error(problemException.getMessage());
            return -1;
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream2);
            return -1;
        }
    }

    private boolean findJavaSourceFiles(String[] stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            if (string2.endsWith(".java") && !string.equals("-xf") && !string.equals("-if")) {
                return true;
            }
            string = string2;
        }
        return false;
    }

    private boolean findAtFile(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.startsWith("@")) continue;
            return true;
        }
        return false;
    }

    private String findLogLevel(String[] stringArray) {
        for (String string : stringArray) {
            if (string.startsWith("--log=") && string.length() > 6) {
                return string.substring(6);
            }
            if (!string.equals("-verbose")) continue;
            return "info";
        }
        return "info";
    }

    static String[] removeWrapperArgs(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-src") || stringArray[i].equals("-x") || stringArray[i].equals("-i") || stringArray[i].equals("-xf") || stringArray[i].equals("-if") || stringArray[i].equals("-copy") || stringArray[i].equals("-tr") || stringArray[i].equals("-j")) {
                ++i;
                continue;
            }
            if (stringArray[i].startsWith("--server:") || stringArray[i].startsWith("--log=") || stringArray[i].equals("--permit-unidentified-artifacts") || stringArray[i].equals("--permit-sources-without-package")) continue;
            if (stringArray[i].equals("--compare-found-sources")) {
                ++i;
                continue;
            }
            if (stringArray[i].equals("-sourcepath")) {
                if (n == -1) {
                    n = n4;
                    stringArray2[n4] = stringArray[i];
                    stringArray2[n4 + 1] = stringArray[i + 1];
                    n4 += 2;
                    ++i;
                    continue;
                }
                stringArray2[n + 1] = stringArray2[n + 1] + File.pathSeparatorChar + stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equals("-classpath") || stringArray[i].equals("-cp")) {
                if (n2 == -1) {
                    n2 = n4;
                    stringArray2[n4] = stringArray[i];
                    stringArray2[n4 + 1] = stringArray[i + 1];
                    n4 += 2;
                    ++i;
                    continue;
                }
                stringArray2[n2 + 1] = stringArray2[n2 + 1] + File.pathSeparatorChar + stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equals("-modulepath")) {
                if (n3 == -1) {
                    n3 = n4;
                    stringArray2[n4] = stringArray[i];
                    stringArray2[n4 + 1] = stringArray[i + 1];
                    n4 += 2;
                    ++i;
                    continue;
                }
                stringArray2[n3 + 1] = stringArray2[n3 + 1] + File.pathSeparatorChar + stringArray[i + 1];
                ++i;
                continue;
            }
            stringArray2[n4] = stringArray[i];
            ++n4;
        }
        String[] stringArray3 = new String[n4];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n4);
        return stringArray3;
    }

    private static boolean makeSureExists(File file) {
        if (!file.exists() && !file.mkdirs()) {
            Log.error("Could not create the directory " + file.getPath());
            return false;
        }
        return true;
    }

    private static void checkPattern(String string) throws ProblemException {
        Pattern pattern = Pattern.compile("[a-zA-Z_]{1}[a-zA-Z0-9_]*(\\.[a-zA-Z_]{1}[a-zA-Z0-9_]*)*(\\.\\*)?+");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new ProblemException("The string \"" + string + "\" is not a proper package name pattern.");
        }
    }

    private static void checkTranslatePattern(String string) throws ProblemException {
        Pattern pattern = Pattern.compile("\\.[a-zA-Z_]{1}[a-zA-Z0-9_]*=[a-z_]{1}[a-z0-9_]*(\\.[a-z_]{1}[a-z0-9_]*)*(\\.[a-zA-Z_]{1}[a-zA-Z0-9_]*)(,.*)?");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new ProblemException("The string \"" + string + "\" is not a proper translate pattern.");
        }
    }

    private static void checkCopyPattern(String string) throws ProblemException {
        Pattern pattern = Pattern.compile("\\.[a-zA-Z_]{1}[a-zA-Z0-9_]*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new ProblemException("The string \"" + string + "\" is not a proper suffix.");
        }
    }

    private static void checkFilePattern(String string) throws ProblemException {
        Pattern pattern = null;
        if (File.separatorChar == '\\') {
            pattern = Pattern.compile("\\*?(.+\\\\)*.+");
        } else if (File.separatorChar == '/') {
            pattern = Pattern.compile("\\*?(.+/)*.+");
        } else {
            throw new ProblemException("This platform uses the unsupported " + File.separatorChar + " as file separator character. Please add support for it!");
        }
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new ProblemException("The string \"" + string + "\" is not a proper file name.");
        }
    }

    private static boolean hasOption(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String[] verifyImplicitOption(String[] stringArray) throws ProblemException {
        boolean bl = false;
        for (String string : stringArray) {
            if (!string.startsWith("-implicit:")) continue;
            bl = true;
            if (string.equals("-implicit:none")) continue;
            throw new ProblemException("The only allowed setting for sjavac is -implicit:none, it is also the default.");
        }
        if (bl) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = "-implicit:none";
        return stringArray2;
    }

    private static void rewriteOptions(String[] stringArray, String string, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            stringArray[i] = string2;
        }
    }

    private static File findDirectoryOption(String[] stringArray, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws ProblemException, ProblemException {
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            if (file != null) {
                throw new ProblemException("You have already specified the " + string2 + " dir!");
            }
            if (i + 1 >= stringArray.length) {
                throw new ProblemException("You have to specify a directory following " + string + ".");
            }
            if (stringArray[i + 1].indexOf(File.pathSeparatorChar) != -1) {
                throw new ProblemException("You must only specify a single directory for " + string + ".");
            }
            file = new File(stringArray[i + 1]);
            if (!file.exists()) {
                if (!bl3) {
                    throw new ProblemException("This directory does not exist: " + file.getPath());
                }
                if (!Main.makeSureExists(file)) {
                    throw new ProblemException("Cannot create directory " + file.getPath());
                }
            }
            if (file.isDirectory()) continue;
            throw new ProblemException("\"" + stringArray[i + 1] + "\" is not a directory.");
        }
        if (file == null && bl) {
            throw new ProblemException("You have to specify " + string);
        }
        try {
            if (file != null) {
                return file.getCanonicalFile();
            }
        }
        catch (IOException iOException) {
            throw new ProblemException("" + iOException);
        }
        return null;
    }

    private static boolean shouldBeFollowedByPath(String string) {
        return string.equals("-s") || string.equals("-h") || string.equals("-d") || string.equals("-sourcepath") || string.equals("-classpath") || string.equals("-cp") || string.equals("-bootclasspath") || string.equals("-src");
    }

    private static String[] addSrcBeforeDirectories(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (file.exists() && file.isDirectory() && (i == 0 || !Main.shouldBeFollowedByPath(stringArray[i - 1]))) {
                arrayList.add("-src");
            }
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    private static void checkSrcOption(String[] stringArray) throws ProblemException {
        HashSet<File> hashSet = new HashSet<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-src")) continue;
            if (i + 1 >= stringArray.length) {
                throw new ProblemException("You have to specify a directory following -src.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i + 1], File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                File file = new File(stringTokenizer.nextToken());
                if (!file.exists()) {
                    throw new ProblemException("This directory does not exist: " + file.getPath());
                }
                if (!file.isDirectory()) {
                    throw new ProblemException("\"" + file.getPath() + "\" is not a directory.");
                }
                if (hashSet.contains(file)) {
                    throw new ProblemException("The src directory \"" + file.getPath() + "\" is specified more than once!");
                }
                hashSet.add(file);
            }
        }
        if (hashSet.isEmpty()) {
            throw new ProblemException("You have to specify -src.");
        }
    }

    private static File findFileOption(String[] stringArray, String string, String string2, boolean bl) throws ProblemException, ProblemException {
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            if (file != null) {
                throw new ProblemException("You have already specified the " + string2 + " file!");
            }
            if (i + 1 >= stringArray.length) {
                throw new ProblemException("You have to specify a file following " + string + ".");
            }
            file = new File(stringArray[i + 1]);
            if (file.isDirectory()) {
                throw new ProblemException("\"" + stringArray[i + 1] + "\" is not a file.");
            }
            if (file.exists() || !bl) continue;
            throw new ProblemException("The file \"" + stringArray[i + 1] + "\" does not exist.");
        }
        if (file == null && bl) {
            throw new ProblemException("You have to specify " + string);
        }
        return file;
    }

    public static boolean findBooleanOption(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int findNumberOption(String[] stringArray, String string) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string) || stringArray.length <= i + 1) continue;
            n = Integer.parseInt(stringArray[i + 1]);
        }
        return n;
    }

    private static void findTranslateOptions(String[] stringArray, Map<String, Transformer> map) throws ProblemException, ProblemException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-tr")) continue;
            if (i + 1 >= stringArray.length) {
                throw new ProblemException("You have to specify a translate rule following -tr.");
            }
            String string = stringArray[i + 1];
            Main.checkTranslatePattern(string);
            int n = string.indexOf("=");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (map.get(string2) != null) {
                throw new ProblemException("You have already specified a rule for the suffix " + string2);
            }
            if (string.equals(".class")) {
                throw new ProblemException("You cannot have a translator for .class files!");
            }
            if (string.equals(".java")) {
                throw new ProblemException("You cannot have a translator for .java files!");
            }
            String string4 = null;
            int n2 = string3.indexOf(",");
            if (n2 != -1) {
                string4 = string3.substring(n2 + 1);
                string3 = string3.substring(0, n2);
            }
            try {
                Class<?> clazz = Class.forName(string3);
                Transformer transformer = (Transformer)clazz.newInstance();
                transformer.setExtra(string4);
                map.put(string2, transformer);
                continue;
            }
            catch (Exception exception) {
                throw new ProblemException("Cannot use " + string3 + " as a translator!");
            }
        }
    }

    private void findCopyOptions(String[] stringArray, Map<String, Transformer> map) throws ProblemException, ProblemException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-copy")) continue;
            if (i + 1 >= stringArray.length) {
                throw new ProblemException("You have to specify a translate rule following -tr.");
            }
            String string = stringArray[i + 1];
            Main.checkCopyPattern(string);
            if (map.get(string) != null) {
                throw new ProblemException("You have already specified a rule for the suffix " + string);
            }
            if (string.equals(".class")) {
                throw new ProblemException("You cannot have a copy rule for .class files!");
            }
            if (string.equals(".java")) {
                throw new ProblemException("You cannot have a copy rule for .java files!");
            }
            map.put(string, this.javac_state.getCopier());
        }
    }

    private String fixupSeparator(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replaceAll("/", "\\\\");
    }

    private boolean findFiles(String[] stringArray, String string, Set<String> set, Map<String, Source> map, Map<String, Module> map2, Module module, boolean bl) throws ProblemException, ProblemException {
        HashSet<File> hashSet = new HashSet<File>();
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        LinkedList<String> linkedList4 = new LinkedList<String>();
        LinkedList<String> linkedList5 = new LinkedList<String>();
        linkedList5.add("module-info.java");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (stringArray[i].equals("-i")) {
                if (i + 1 >= stringArray.length) {
                    throw new ProblemException("You have to specify a package pattern following -i");
                }
                stringArray2 = stringArray[i + 1];
                Main.checkPattern((String)stringArray2);
                linkedList.add((String)stringArray2);
            }
            if (stringArray[i].equals("-x")) {
                if (i + 1 >= stringArray.length) {
                    throw new ProblemException("You have to specify a package pattern following -x");
                }
                stringArray2 = stringArray[i + 1];
                Main.checkPattern((String)stringArray2);
                linkedList2.add((String)stringArray2);
            }
            if (stringArray[i].equals("-xf")) {
                if (i + 1 >= stringArray.length) {
                    throw new ProblemException("You have to specify a file following -xf");
                }
                stringArray2 = stringArray[i + 1];
                Main.checkFilePattern((String)stringArray2);
                stringArray2 = Util.normalizeDriveLetter((String)stringArray2);
                linkedList3.add(this.fixupSeparator((String)stringArray2));
            }
            if (stringArray[i].equals("-if")) {
                if (i + 1 >= stringArray.length) {
                    throw new ProblemException("You have to specify a file following -xf");
                }
                stringArray2 = stringArray[i + 1];
                Main.checkFilePattern((String)stringArray2);
                stringArray2 = Util.normalizeDriveLetter((String)stringArray2);
                linkedList4.add(this.fixupSeparator((String)stringArray2));
            }
            if (stringArray[i].equals(string)) {
                if (i + 1 >= stringArray.length) {
                    throw new ProblemException("You have to specify a directory following " + string);
                }
                for (String string2 : stringArray2 = stringArray[i + 1].split(File.pathSeparator)) {
                    File file = new File(string2);
                    if (!file.isDirectory()) {
                        throw new ProblemException("\"" + string2 + "\" is not a directory.");
                    }
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        throw new ProblemException("" + iOException);
                    }
                    if (hashSet.contains(file)) {
                        throw new ProblemException("\"" + string2 + "\" has already been used for " + string);
                    }
                    if (file.equals(this.bin_dir)) {
                        throw new ProblemException("\"" + string2 + "\" cannot be used both for " + string + " and -d");
                    }
                    if (file.equals(this.gensrc_dir)) {
                        throw new ProblemException("\"" + string2 + "\" cannot be used both for " + string + " and -s");
                    }
                    if (file.equals(this.header_dir)) {
                        throw new ProblemException("\"" + string2 + "\" cannot be used both for " + string + " and -h");
                    }
                    hashSet.add(file);
                    Source.scanRoot(file, set, linkedList2, linkedList, linkedList3, linkedList4, map, map2, module, Main.findBooleanOption(stringArray, "--permit-sources-without-package"), false, bl);
                }
            }
            if (!stringArray[i].equals("-src") && !stringArray[i].equals("-sourcepath") && !stringArray[i].equals("-modulepath") && !stringArray[i].equals("-classpath") && !stringArray[i].equals("-cp")) continue;
            linkedList = new LinkedList();
            linkedList2 = new LinkedList();
            linkedList3 = new LinkedList();
            linkedList4 = new LinkedList();
        }
        return true;
    }
}

