/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.BuildState;
import com.sun.tools.sjavac.CompileJavaPackages;
import com.sun.tools.sjavac.CopyFile;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Main;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavacState {
    String theArgs;
    int numCores;
    private String javacStateFilename;
    private File javacState;
    private BuildState prev;
    private BuildState now;
    private boolean needsSaving;
    private boolean newJavacState;
    private Set<String> taintedPackages;
    private Set<String> packagesWithChangedPublicApis;
    private Set<String> taintedModules;
    private Set<String> recompiledPackages;
    private File binDir;
    private File gensrcDir;
    private File headerDir;
    private Set<File> binArtifacts;
    private Set<File> gensrcArtifacts;
    private Set<File> headerArtifacts;
    Set<Source> removedSources = null;
    Set<Source> addedSources = null;
    Set<Source> modifiedSources = null;
    Set<URI> visibleSrcs;
    Map<URI, Set<String>> visibleClasses;
    private CopyFile copyFiles = new CopyFile();
    private CompileJavaPackages compileJavaPackages = new CompileJavaPackages();
    private PrintStream out;
    private PrintStream err;

    JavacState(String[] stringArray, File file, File file2, File file3, boolean bl, boolean bl2, PrintStream printStream, PrintStream printStream2) {
        this.out = printStream;
        this.err = printStream2;
        this.numCores = Main.findNumberOption(stringArray, "-j");
        this.theArgs = "";
        for (String string : JavacState.removeArgsNotAffectingState(stringArray)) {
            this.theArgs = this.theArgs + string + " ";
        }
        this.binDir = file;
        this.gensrcDir = file2;
        this.headerDir = file3;
        this.javacStateFilename = this.binDir.getPath() + File.separator + "javac_state";
        this.javacState = new File(this.javacStateFilename);
        if (bl2 && this.javacState.exists()) {
            this.javacState.delete();
        }
        this.newJavacState = false;
        if (!this.javacState.exists()) {
            this.newJavacState = true;
            if (!bl) {
                JavacState.deleteContents(this.binDir);
                JavacState.deleteContents(this.gensrcDir);
                JavacState.deleteContents(this.headerDir);
            }
            this.needsSaving = true;
        }
        this.prev = new BuildState();
        this.now = new BuildState();
        this.taintedPackages = new HashSet<String>();
        this.recompiledPackages = new HashSet<String>();
        this.packagesWithChangedPublicApis = new HashSet<String>();
    }

    public BuildState prev() {
        return this.prev;
    }

    public BuildState now() {
        return this.now;
    }

    static String[] removeArgsNotAffectingState(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-j")) {
                ++i;
                continue;
            }
            if (stringArray[i].startsWith("--server:") || stringArray[i].startsWith("--log=")) continue;
            if (stringArray[i].equals("--compare-found-sources")) {
                ++i;
                continue;
            }
            stringArray2[n] = stringArray[i];
            ++n;
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        return stringArray3;
    }

    public void setVisibleSources(Map<String, Source> map) {
        this.visibleSrcs = new HashSet<URI>();
        for (String string : map.keySet()) {
            Source source = map.get(string);
            this.visibleSrcs.add(source.file().toURI());
        }
    }

    public void setVisibleClasses(Map<String, Source> map) {
        this.visibleSrcs = new HashSet<URI>();
        for (String string : map.keySet()) {
            Source source = map.get(string);
            this.visibleSrcs.add(source.file().toURI());
        }
    }

    public boolean isIncremental() {
        return !this.prev.sources().isEmpty();
    }

    public void findAllArtifacts() {
        this.binArtifacts = JavacState.findAllFiles(this.binDir);
        this.gensrcArtifacts = JavacState.findAllFiles(this.gensrcDir);
        this.headerArtifacts = JavacState.findAllFiles(this.headerDir);
    }

    private Map<String, File> fetchPrevArtifacts(String string) {
        Package package_ = this.prev.packages().get(string);
        if (package_ != null) {
            return package_.artifacts();
        }
        return new HashMap<String, File>();
    }

    public void deleteClassArtifactsInTaintedPackages() {
        for (String string : this.taintedPackages) {
            Map<String, File> map = this.fetchPrevArtifacts(string);
            for (File file : map.values()) {
                if (!file.exists() || !file.getName().endsWith(".class")) continue;
                file.delete();
            }
        }
    }

    private void needsSaving() {
        this.needsSaving = true;
    }

    public void save() throws IOException {
        if (!this.needsSaving) {
            return;
        }
        try (FileWriter fileWriter = new FileWriter(this.javacStateFilename);){
            StringBuilder stringBuilder = new StringBuilder();
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            stringBuilder.append("# javac_state ver 0.3 generated " + l + " " + simpleDateFormat.format(date) + "\n");
            stringBuilder.append("# This format might change at any time. Please do not depend on it.\n");
            stringBuilder.append("# M module\n");
            stringBuilder.append("# P package\n");
            stringBuilder.append("# S C source_tobe_compiled timestamp\n");
            stringBuilder.append("# S L link_only_source timestamp\n");
            stringBuilder.append("# G C generated_source timestamp\n");
            stringBuilder.append("# A artifact timestamp\n");
            stringBuilder.append("# D dependency\n");
            stringBuilder.append("# I pubapi\n");
            stringBuilder.append("# R arguments\n");
            stringBuilder.append("R ").append(this.theArgs).append("\n");
            this.now.copyPackagesExcept(this.prev, this.recompiledPackages, new HashSet<String>());
            Module.saveModules(this.now.modules(), stringBuilder);
            String string = stringBuilder.toString();
            fileWriter.write(string, 0, string.length());
        }
    }

    public static JavacState load(String[] stringArray, File file, File file2, File file3, boolean bl, PrintStream printStream, PrintStream printStream2) {
        JavacState javacState = new JavacState(stringArray, file, file2, file3, bl, false, printStream, printStream2);
        Module module = null;
        Package package_ = null;
        Source source = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(javacState.javacStateFilename));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.length() < 3 || string.charAt(1) != ' ') continue;
                char c = string.charAt(0);
                if (c == 'M') {
                    module = javacState.prev.loadModule(string);
                    continue;
                }
                if (c == 'P') {
                    if (module == null) {
                        bl5 = true;
                        break;
                    }
                    package_ = javacState.prev.loadPackage(module, string);
                    continue;
                }
                if (c == 'D') {
                    if (module == null || package_ == null) {
                        bl5 = true;
                        break;
                    }
                    package_.loadDependency(string);
                    continue;
                }
                if (c == 'I') {
                    if (module == null || package_ == null) {
                        bl5 = true;
                        break;
                    }
                    package_.loadPubapi(string);
                    continue;
                }
                if (c == 'A') {
                    if (module == null || package_ == null) {
                        bl5 = true;
                        break;
                    }
                    package_.loadArtifact(string);
                    continue;
                }
                if (c == 'S') {
                    if (module == null || package_ == null) {
                        bl5 = true;
                        break;
                    }
                    source = javacState.prev.loadSource(package_, string, false);
                    continue;
                }
                if (c == 'G') {
                    if (module == null || package_ == null) {
                        bl5 = true;
                        break;
                    }
                    source = javacState.prev.loadSource(package_, string, true);
                    continue;
                }
                if (c == 'R') {
                    String string2 = "R " + javacState.theArgs;
                    if (string.equals(string2)) continue;
                    bl4 = true;
                    continue;
                }
                if (c != '#' || !string.startsWith("# javac_state ver ") || (n = string.indexOf(" ", 18)) == -1) continue;
                String string3 = string.substring(18, n);
                if (!string3.equals("0.3")) {
                    break;
                }
                bl3 = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl2 = true;
        }
        catch (IOException iOException) {
            Log.info("Dropping old javac_state because of errors when reading it.");
            javacState = new JavacState(stringArray, file, file2, file3, bl, true, printStream, printStream2);
            bl3 = true;
            bl4 = false;
            bl5 = false;
        }
        if (!bl3 && !bl2) {
            Log.info("Dropping old javac_state since it is of an old version.");
            javacState = new JavacState(stringArray, file, file2, file3, bl, true, printStream, printStream2);
        } else if (bl4 && !bl2) {
            Log.info("Dropping old javac_state since a new command line is used!");
            javacState = new JavacState(stringArray, file, file2, file3, bl, true, printStream, printStream2);
        } else if (bl5) {
            Log.info("Dropping old javac_state since it contains syntax errors.");
            javacState = new JavacState(stringArray, file, file2, file3, bl, true, printStream, printStream2);
        }
        javacState.prev.calculateDependents();
        return javacState;
    }

    public void taintPackage(String string, String string2) {
        if (!this.taintedPackages.contains(string)) {
            if (string2 != null) {
                Log.debug("Tainting " + Util.justPackageName(string) + " because " + string2);
            }
            this.taintedPackages.add(string);
            this.needsSaving();
            Package package_ = this.now.packages().get(string);
            if (package_ != null) {
                for (String string3 : package_.dependents()) {
                    this.taintPackage(string3, string2);
                }
            }
        }
    }

    public Set<String> taintedPackages() {
        return this.taintedPackages;
    }

    public void clearTaintedPackages() {
        this.taintedPackages = new HashSet<String>();
    }

    public void checkSourceStatus(boolean bl) {
        this.removedSources = this.calculateRemovedSources();
        for (Source source : this.removedSources) {
            if (source.isGenerated() && !bl) continue;
            this.taintPackage(source.pkg().name(), "source " + source.name() + " was removed");
        }
        this.addedSources = this.calculateAddedSources();
        for (Source source : this.addedSources) {
            String string = null;
            if (this.isIncremental()) {
                string = "source " + source.name() + " was added";
            }
            if (source.isGenerated() && !bl) continue;
            this.taintPackage(source.pkg().name(), string);
        }
        this.modifiedSources = this.calculateModifiedSources();
        for (Source source : this.modifiedSources) {
            if (source.isGenerated() && !bl) continue;
            this.taintPackage(source.pkg().name(), "source " + source.name() + " was modified");
        }
    }

    public Map<String, Transformer> getJavaSuffixRule() {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        hashMap.put(".java", this.compileJavaPackages);
        return hashMap;
    }

    public Transformer getCopier() {
        return this.copyFiles;
    }

    public void taintPackagesThatMissArtifacts() {
        for (Package package_ : this.prev.packages().values()) {
            for (File file : package_.artifacts().values()) {
                if (file.exists()) continue;
                this.taintPackage(package_.name(), "" + file + " is missing.");
            }
        }
    }

    public void taintPackagesDependingOnChangedPackages(Set<String> set, Set<String> set2) {
        for (Package package_ : this.prev.packages().values()) {
            for (String string : package_.dependencies()) {
                if (!set.contains(string) || set2.contains(package_.name())) continue;
                this.taintPackage(package_.name(), " its depending on " + string);
            }
        }
    }

    public void removeUnidentifiedArtifacts() {
        HashSet<File> hashSet = new HashSet<File>();
        for (Package comparable : this.prev.packages().values()) {
            for (File file : comparable.artifacts().values()) {
                hashSet.add(file);
            }
        }
        hashSet.add(this.javacState);
        for (File file : this.binArtifacts) {
            if (hashSet.contains(file)) continue;
            Log.debug("Removing " + file.getPath() + " since it is unknown to the javac_state.");
            file.delete();
        }
        for (File file : this.headerArtifacts) {
            if (hashSet.contains(file)) continue;
            Log.debug("Removing " + file.getPath() + " since it is unknown to the javac_state.");
            file.delete();
        }
        for (File file : this.gensrcArtifacts) {
            if (hashSet.contains(file)) continue;
            Log.debug("Removing " + file.getPath() + " since it is unknown to the javac_state.");
            file.delete();
        }
    }

    public void removeSuperfluousArtifacts(Set<String> set) {
        if (set.size() == 0) {
            return;
        }
        for (String string : this.now.packages().keySet()) {
            if (!set.contains(string)) continue;
            Collection<File> collection = this.now.artifacts().values();
            for (File file : this.fetchPrevArtifacts(string).values()) {
                if (collection.contains(file)) continue;
                Log.debug("Removing " + file.getPath() + " since it is now superfluous!");
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    private Set<Source> calculateRemovedSources() {
        HashSet<Source> hashSet = new HashSet<Source>();
        for (String string : this.prev.sources().keySet()) {
            if (this.now.sources().get(string) != null) continue;
            hashSet.add(this.prev.sources().get(string));
        }
        return hashSet;
    }

    private Set<Source> calculateAddedSources() {
        HashSet<Source> hashSet = new HashSet<Source>();
        for (String string : this.now.sources().keySet()) {
            if (this.prev.sources().get(string) != null) continue;
            hashSet.add(this.now.sources().get(string));
        }
        return hashSet;
    }

    private Set<Source> calculateModifiedSources() {
        HashSet<Source> hashSet = new HashSet<Source>();
        for (String string : this.now.sources().keySet()) {
            Source source = this.now.sources().get(string);
            Source source2 = this.prev.sources().get(string);
            if (this.prev.sources().get(string) == null || source2 == null) continue;
            if (source.lastModified() > source2.lastModified()) {
                hashSet.add(source);
                continue;
            }
            if (source.lastModified() >= source2.lastModified()) continue;
            hashSet.add(source);
            Log.warn("The source file " + source.name() + " timestamp has moved backwards in time.");
        }
        return hashSet;
    }

    private static void deleteContents(File file) {
        if (file != null && file.exists()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    JavacState.deleteContents(file2);
                }
                file2.delete();
            }
        }
    }

    public void performCopying(File file, Map<String, Transformer> map) {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        for (Map.Entry<String, Transformer> entry : map.entrySet()) {
            if (entry.getValue() != this.copyFiles) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this.perform(file, hashMap);
    }

    public void performTranslation(File file, Map<String, Transformer> map) {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        for (Map.Entry<String, Transformer> entry : map.entrySet()) {
            if (entry.getValue() == this.copyFiles || entry.getValue() == this.compileJavaPackages) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this.perform(file, hashMap);
    }

    public boolean performJavaCompilations(File file, String string, String[] stringArray, Set<String> set, boolean[] blArray) {
        HashMap<String, Transformer> hashMap = new HashMap<String, Transformer>();
        hashMap.put(".java", this.compileJavaPackages);
        this.compileJavaPackages.setExtra(string);
        this.compileJavaPackages.setExtra(stringArray);
        blArray[0] = this.perform(file, hashMap);
        set.addAll(this.taintedPackages());
        this.clearTaintedPackages();
        boolean bl = !this.packagesWithChangedPublicApis.isEmpty();
        this.taintPackagesDependingOnChangedPackages(this.packagesWithChangedPublicApis, set);
        this.packagesWithChangedPublicApis = new HashSet<String>();
        return bl && blArray[0];
    }

    private void addFileToTransform(Map<Transformer, Map<String, Set<URI>>> map, Transformer transformer, Source source) {
        Set<URI> set;
        Map<String, Set<URI>> map2 = map.get(transformer);
        if (map2 == null) {
            map2 = new HashMap<String, Set<URI>>();
            map.put(transformer, map2);
        }
        if ((set = map2.get(source.pkg().name())) == null) {
            set = new HashSet<URI>();
            map2.put(source.pkg().name(), set);
        }
        set.add(source.file().toURI());
    }

    private boolean perform(File file, Map<String, Transformer> map) {
        Transformer transformer;
        boolean bl = true;
        HashMap<Transformer, Map<String, Set<URI>>> hashMap = new HashMap<Transformer, Map<String, Set<URI>>>();
        for (Source object : this.now.sources().values()) {
            transformer = map.get(object.suffix());
            if (transformer == null || !this.taintedPackages.contains(object.pkg().name()) || object.isLinkedOnly()) continue;
            this.addFileToTransform(hashMap, transformer, object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object;
            Object object2;
            transformer = (Transformer)entry.getKey();
            Map map2 = (Map)entry.getValue();
            Map<String, Set<URI>> map3 = Collections.synchronizedMap(new HashMap());
            Map<String, Set<String>> map4 = Collections.synchronizedMap(new HashMap());
            Map<String, String> map5 = Collections.synchronizedMap(new HashMap());
            boolean bl2 = transformer.transform(map2, this.visibleSrcs, this.visibleClasses, this.prev.dependents(), file.toURI(), map3, map4, map5, 0, this.isIncremental(), this.numCores, this.out, this.err);
            if (!bl2) {
                bl = false;
            }
            for (String string : map2.keySet()) {
                this.recompiledPackages.add(string);
            }
            for (Map.Entry entry2 : map3.entrySet()) {
                object2 = this.now.findModuleFromPackageName((String)entry2.getKey());
                ((Module)object2).addArtifacts((String)entry2.getKey(), (Set)entry2.getValue());
            }
            for (Map.Entry entry3 : map4.entrySet()) {
                object2 = (Set)entry3.getValue();
                object = this.now.findModuleFromPackageName((String)entry3.getKey());
                ((Module)object).setDependencies((String)entry3.getKey(), (Set<String>)object2);
            }
            for (Map.Entry entry4 : map5.entrySet()) {
                object2 = this.prev.findModuleFromPackageName((String)entry4.getKey());
                object = Package.pubapiToList((String)entry4.getValue());
                Module module = this.now.findModuleFromPackageName((String)entry4.getKey());
                module.setPubapi((String)entry4.getKey(), (List<String>)object);
                if (!((Module)object2).hasPubapiChanged((String)entry4.getKey(), (List<String>)object) || !((Module)object2).lookupPackage((String)entry4.getKey()).existsInJavacState()) continue;
                this.packagesWithChangedPublicApis.add((String)entry4.getKey());
                Log.info("The pubapi of " + Util.justPackageName((String)entry4.getKey()) + " has changed!");
            }
        }
        return bl;
    }

    private static Set<File> findAllFiles(File file) {
        HashSet<File> hashSet = new HashSet<File>();
        if (file == null) {
            return hashSet;
        }
        JavacState.recurse(file, hashSet);
        return hashSet;
    }

    private static void recurse(File file, Set<File> set) {
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                set.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            JavacState.recurse(file2, set);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void compareWithMakefileList(File file) throws ProblemException {
        boolean bl;
        boolean bl2 = bl = File.pathSeparatorChar == ';';
        if (file == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<void> hashSet2 = new HashSet<void>();
        for (Source object : this.now.sources().values()) {
            if (object.isLinkedOnly()) continue;
            hashSet.add(object.file().getPath());
        }
        try {
            String string;
            Iterator iterator = new BufferedReader(new FileReader(file));
            while ((string = ((BufferedReader)((Object)iterator)).readLine()) != null) {
                void var6_17;
                String string2 = string.trim();
                if (bl) {
                    void var6_15;
                    if (string2.indexOf(":") != 1 || string2.indexOf("\\") != 2) {
                        if (string2.indexOf(":") == 1 && string2.indexOf("/") == 2) {
                            String string3 = string2.replaceAll("/", "\\\\");
                        } else if (string2.charAt(0) == '/' && string2.indexOf("/", 1) != -1) {
                            int n = string2.indexOf("/", 1);
                            String string5 = string2.replaceAll("/", "\\\\");
                            string5 = "" + string5.charAt(n + 1) + ":" + string5.substring(n + 2);
                        }
                    }
                    if (Character.isLowerCase(var6_15.charAt(0))) {
                        String string6 = Character.toUpperCase(var6_15.charAt(0)) + var6_15.substring(1);
                    }
                }
                hashSet2.add(var6_17);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ProblemException("Could not open " + file.getPath() + " since it does not exist!");
        }
        catch (IOException iOException) {
            throw new ProblemException("Could not read " + file.getPath());
        }
        for (String string : hashSet2) {
            if (hashSet.contains(string)) continue;
            throw new ProblemException("The makefile listed source " + string + " was not calculated by the smart javac wrapper!");
        }
        for (String string : hashSet) {
            if (hashSet2.contains(string)) continue;
            throw new ProblemException("The smart javac wrapper calculated source " + string + " was not listed by the makefiles!");
        }
    }
}

