/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.Source;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BuildState {
    private Map<String, Module> modules = new HashMap<String, Module>();
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Map<String, File> artifacts = new HashMap<String, File>();
    private Map<String, Set<String>> dependents = new HashMap<String, Set<String>>();

    public Map<String, Module> modules() {
        return this.modules;
    }

    public Map<String, Package> packages() {
        return this.packages;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public Map<String, File> artifacts() {
        return this.artifacts;
    }

    public Map<String, Set<String>> dependents() {
        return this.dependents;
    }

    public Module lookupModule(String string) {
        Module module = this.modules.get(string);
        if (module == null) {
            module = new Module(string, "???");
            this.modules.put(string, module);
        }
        return module;
    }

    Module findModuleFromPackageName(String string) {
        int n = string.indexOf(58);
        assert (n != -1);
        String string2 = string.substring(0, n);
        return this.lookupModule(string2);
    }

    public void flattenPackagesSourcesAndArtifacts(Map<String, Module> map) {
        this.modules = map;
        for (Module module : this.modules.values()) {
            for (Map.Entry<String, Package> entry : module.packages().entrySet()) {
                Comparable<Source> comparable;
                Package package_ = this.packages.get(entry.getKey());
                assert (package_ == null || package_ == entry.getValue());
                if (package_ == null) {
                    package_ = entry.getValue();
                    this.packages.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Source> entry2 : package_.sources().entrySet()) {
                    comparable = this.sources.get(entry2.getKey());
                    assert (comparable == null || comparable == entry2.getValue());
                    if (comparable != null) continue;
                    comparable = entry2.getValue();
                    this.sources.put(entry2.getKey(), entry2.getValue());
                }
                for (Map.Entry<String, Comparable<Source>> entry3 : package_.artifacts().entrySet()) {
                    comparable = this.artifacts.get(entry3.getKey());
                    assert (comparable == null || comparable == entry3.getValue());
                    if (comparable != null) continue;
                    comparable = (File)entry3.getValue();
                    this.artifacts.put(entry3.getKey(), (File)entry3.getValue());
                }
            }
        }
    }

    public void flattenArtifacts(Map<String, Module> map) {
        this.modules = map;
        for (Module module : this.modules.values()) {
            for (Map.Entry<String, Package> entry : module.packages().entrySet()) {
                Package package_ = this.packages.get(entry.getKey());
                assert (package_ == null || package_ == entry.getValue());
                package_ = entry.getValue();
                this.packages.put(entry.getKey(), entry.getValue());
                for (Map.Entry<String, File> entry2 : package_.artifacts().entrySet()) {
                    File file = this.artifacts.get(entry2.getKey());
                    assert (file == null || file == entry2.getValue());
                    this.artifacts.put(entry2.getKey(), entry2.getValue());
                }
            }
        }
    }

    public void calculateDependents() {
        this.dependents = new HashMap<String, Set<String>>();
        for (String string : this.packages.keySet()) {
            Package package_ = this.packages.get(string);
            for (String string2 : package_.dependencies()) {
                Set<String> set = this.dependents.get(string2);
                if (set == null) {
                    set = new HashSet<String>();
                    this.dependents.put(string2, set);
                }
                set.add(string);
                Package package_2 = this.packages.get(string2);
                if (package_2 == null) continue;
                package_2.addDependent(package_.name());
            }
        }
    }

    public void checkInternalState(String string, boolean bl, Map<String, Source> map) {
        Source source;
        Source source2;
        boolean bl2 = false;
        HashMap<String, Source> hashMap = new HashMap<String, Source>();
        HashMap<String, Source> hashMap2 = new HashMap<String, Source>();
        for (String string2 : this.sources.keySet()) {
            source2 = this.sources.get(string2);
            if (source2.isLinkedOnly() != bl) continue;
            hashMap2.put(string2, source2);
        }
        for (String string2 : map.keySet()) {
            source2 = map.get(string2);
            if (source2.isLinkedOnly() != bl) continue;
            hashMap.put(string2, source2);
        }
        if (hashMap.size() != hashMap2.size()) {
            Log.error("INTERNAL ERROR " + string + " original and calculated are not the same size!");
            bl2 = true;
        }
        if (!hashMap.keySet().equals(hashMap2.keySet())) {
            Log.error("INTERNAL ERROR " + string + " original and calculated do not have the same domain!");
            bl2 = true;
        }
        if (!bl2) {
            for (String string2 : hashMap.keySet()) {
                source2 = (Source)hashMap.get(string2);
                source = (Source)hashMap2.get(string2);
                if (source2 == null || source == null || !source2.equals(source)) {
                    Log.error("INTERNAL ERROR " + string + " original and calculated have differing elements for " + string2);
                }
                bl2 = true;
            }
        }
        if (bl2) {
            for (String string2 : hashMap.keySet()) {
                source2 = (Source)hashMap.get(string2);
                source = (Source)hashMap2.get(string2);
                if (source != null) continue;
                Log.error("The file " + string2 + " does not exist in calculated tree of sources.");
            }
            for (String string2 : hashMap2.keySet()) {
                source2 = (Source)hashMap2.get(string2);
                source = (Source)hashMap.get(string2);
                if (source != null) continue;
                Log.error("The file " + string2 + " does not exist in original set of found sources.");
            }
        }
    }

    public Module loadModule(String string) {
        Module module = Module.load(string);
        this.modules.put(module.name(), module);
        return module;
    }

    public Package loadPackage(Module module, String string) {
        Package package_ = Package.load(module, string);
        module.addPackage(package_);
        this.packages.put(package_.name(), package_);
        return package_;
    }

    public Source loadSource(Package package_, String string, boolean bl) {
        Source source = Source.load(package_, string, bl);
        package_.addSource(source);
        this.sources.put(source.name(), source);
        return source;
    }

    public void copyPackagesExcept(BuildState buildState, Set<String> set, Set<String> set2) {
        for (String string : buildState.packages().keySet()) {
            if (set.contains(string) || set2.contains(string)) continue;
            Module module = this.findModuleFromPackageName(string);
            Package package_ = buildState.packages().get(string);
            module.addPackage(package_);
            this.packages.put(string, package_);
        }
    }
}

