/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.Annotation;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.RuntimeAnnotations_attribute;
import com.sun.tools.jdeps.ClassFileReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;

enum Profile {
    COMPACT1("compact1", 1),
    COMPACT2("compact2", 2),
    COMPACT3("compact3", 3),
    FULL_JRE("Full JRE", 4);

    final String name;
    final int profile;
    final Set<String> packages;
    final Set<String> proprietaryPkgs;

    private Profile(String string2, int n2) {
        this.name = string2;
        this.profile = n2;
        this.packages = new HashSet<String>();
        this.proprietaryPkgs = new HashSet<String>();
    }

    public String toString() {
        return this.name;
    }

    public static int getProfileCount() {
        return PackageToProfile.map.values().size();
    }

    public static Profile getProfile(String string) {
        Profile profile = PackageToProfile.map.get(string);
        return profile != null && profile.packages.contains(string) ? profile : null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            if (Profile.getProfileCount() == 0) {
                System.err.println("No profile is present in this JDK");
            }
            for (Profile profile : Profile.values()) {
                String string = profile.name;
                TreeSet<String> treeSet = new TreeSet<String>(profile.packages);
                for (String string2 : treeSet) {
                    if (PackageToProfile.map.get(string2) == profile) {
                        System.out.format("%2d: %-10s  %s%n", profile.profile, string, string2);
                        string = "";
                        continue;
                    }
                    System.err.format("Split package: %s in %s and %s %n", string2, PackageToProfile.map.get((Object)string2).name, profile.name);
                }
            }
        }
        for (String string : stringArray) {
            System.out.format("%s in %s%n", new Object[]{string, Profile.getProfile(string)});
        }
    }

    static class PackageToProfile {
        static String[] JAVAX_CRYPTO_PKGS = new String[]{"javax.crypto", "javax.crypto.interfaces", "javax.crypto.spec"};
        static Map<String, Profile> map = PackageToProfile.initProfiles();
        private static final String PROFILE_ANNOTATION = "Ljdk/Profile+Annotation;";
        private static final String PROPRIETARY_ANNOTATION = "Lsun/Proprietary+Annotation;";

        PackageToProfile() {
        }

        /*
         * WARNING - void declaration
         */
        private static Map<String, Profile> initProfiles() {
            Object object;
            block20: {
                try {
                    void var1_4;
                    Path path;
                    object = System.getProperty("jdeps.profiles");
                    if (object != null) {
                        PackageToProfile.initProfilesFromProperties((String)object);
                        break block20;
                    }
                    Path object2 = Paths.get(System.getProperty("java.home"), new String[0]);
                    if (object2.endsWith("jre")) {
                        Path path2 = object2.getParent();
                    }
                    if (!Files.exists(path = var1_4.resolve("lib").resolve("ct.sym"), new LinkOption[0])) break block20;
                    Throwable throwable = null;
                    try (JarFile jarFile = new JarFile(path.toFile());){
                        ClassFileReader classFileReader = ClassFileReader.newInstance(path, jarFile);
                        for (ClassFile classFile : classFileReader.getClassFiles()) {
                            PackageToProfile.findProfile(classFile);
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    Collections.addAll(Profile.COMPACT1.packages, JAVAX_CRYPTO_PKGS);
                }
                catch (ConstantPoolException | IOException exception) {
                    throw new Error(exception);
                }
            }
            object = new HashMap();
            for (Profile profile : Profile.values()) {
                for (String string : profile.packages) {
                    if (((HashMap)object).containsKey(string)) continue;
                    ((HashMap)object).put(string, profile);
                }
                for (String string : profile.proprietaryPkgs) {
                    if (((HashMap)object).containsKey(string)) continue;
                    ((HashMap)object).put(string, profile);
                }
            }
            return object;
        }

        private static Profile findProfile(ClassFile classFile) throws ConstantPoolException {
            Object object;
            RuntimeAnnotations_attribute runtimeAnnotations_attribute = (RuntimeAnnotations_attribute)classFile.attributes.get("RuntimeInvisibleAnnotations");
            int n = 0;
            boolean bl = false;
            if (runtimeAnnotations_attribute != null) {
                for (int i = 0; i < runtimeAnnotations_attribute.annotations.length; ++i) {
                    object = runtimeAnnotations_attribute.annotations[i];
                    String string = classFile.constant_pool.getUTF8Value(((Annotation)object).type_index);
                    if (PROFILE_ANNOTATION.equals(string)) {
                        int n2 = 0;
                        if (n2 >= ((Annotation)object).num_element_value_pairs) continue;
                        Annotation.element_value_pair element_value_pair2 = ((Annotation)object).element_value_pairs[n2];
                        Annotation.Primitive_element_value primitive_element_value = (Annotation.Primitive_element_value)element_value_pair2.value;
                        ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info = (ConstantPool.CONSTANT_Integer_info)classFile.constant_pool.get(primitive_element_value.const_value_index);
                        n = cONSTANT_Integer_info.value;
                        continue;
                    }
                    if (!PROPRIETARY_ANNOTATION.equals(string)) continue;
                    bl = true;
                }
            }
            Profile profile = null;
            switch (n) {
                case 1: {
                    profile = COMPACT1;
                    break;
                }
                case 2: {
                    profile = COMPACT2;
                    break;
                }
                case 3: {
                    profile = COMPACT3;
                    break;
                }
                case 4: {
                    profile = FULL_JRE;
                    break;
                }
                default: {
                    return null;
                }
            }
            object = classFile.getName();
            int n3 = ((String)object).lastIndexOf(47);
            Object object2 = object = n3 > 0 ? ((String)object).substring(0, n3).replace('/', '.') : "";
            if (bl) {
                profile.proprietaryPkgs.add((String)object);
            } else {
                profile.packages.add((String)object);
            }
            return profile;
        }

        private static void initProfilesFromProperties(String string) throws IOException {
            Properties properties = new Properties();
            try (Profile[] profileArray = new FileReader(string);){
                properties.load((Reader)profileArray);
            }
            for (Profile profile : Profile.values()) {
                String[] stringArray;
                int n = profile.profile;
                String string2 = properties.getProperty("profile." + n + ".name");
                if (string2 == null) {
                    throw new RuntimeException(string2 + " missing in " + string);
                }
                String string3 = properties.getProperty("profile." + n + ".packages");
                for (String string4 : stringArray = string3.split("\\s+")) {
                    if (string4.isEmpty()) continue;
                    profile.packages.add(string4);
                }
            }
        }
    }
}

