/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.jdeps.Archive;
import com.sun.tools.jdeps.ClassFileReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

class PlatformClassPath {
    private static final List<Archive> javaHomeArchives = PlatformClassPath.init();

    PlatformClassPath() {
    }

    static List<Archive> getArchives() {
        return javaHomeArchives;
    }

    private static List<Archive> init() {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        Path path = Paths.get(System.getProperty("java.home"), new String[0]);
        try {
            if (path.endsWith("jre")) {
                arrayList.addAll(PlatformClassPath.addJarFiles(path.resolve("lib")));
            } else if (Files.exists(path.resolve("lib"), new LinkOption[0])) {
                Path path2 = path.resolve("classes");
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    arrayList.add(new JDKArchive(path2, ClassFileReader.newInstance(path2)));
                }
                arrayList.addAll(PlatformClassPath.addJarFiles(path.resolve("lib")));
            } else {
                throw new RuntimeException("\"" + path + "\" not a JDK home");
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private static List<Archive> addJarFiles(final Path path) throws IOException {
        final ArrayList<Archive> arrayList = new ArrayList<Archive>();
        final Path path2 = path.resolve("ext");
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                if (path3.equals(path) || path3.equals(path2)) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                String string = path3.getFileName().toString();
                if (string.endsWith(".jar")) {
                    arrayList.add(string.equals("jfxrt.jar") ? new Archive(path3, ClassFileReader.newInstance(path3)) : new JDKArchive(path3, ClassFileReader.newInstance(path3)));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return arrayList;
    }

    static class JDKArchive
    extends Archive {
        JDKArchive(Path path, ClassFileReader classFileReader) {
            super(path, classFileReader);
        }
    }
}

