/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Dependencies;
import com.sun.tools.classfile.Dependency;
import com.sun.tools.jdeps.Analyzer;
import com.sun.tools.jdeps.Archive;
import com.sun.tools.jdeps.ClassFileReader;
import com.sun.tools.jdeps.PlatformClassPath;
import com.sun.tools.jdeps.Profile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;

class JdepsTask {
    static Option[] recognizedOptions = new Option[]{new Option(false, new String[]{"-h", "-?", "-help"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.help = true;
        }
    }, new Option(true, new String[]{"-dotoutput"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            Path path = Paths.get(string2, new String[0]);
            if (!(!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path))) {
                throw new BadArgs("err.dot.output.path", string2);
            }
            ((JdepsTask)jdepsTask).options.dotOutputDir = string2;
        }
    }, new Option(false, new String[]{"-s", "-summary"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.showSummary = true;
            ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.SUMMARY;
        }
    }, new Option(false, new String[]{"-v", "-verbose", "-verbose:package", "-verbose:class"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            switch (string) {
                case "-v": 
                case "-verbose": {
                    ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.VERBOSE;
                    break;
                }
                case "-verbose:package": {
                    ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.PACKAGE;
                    break;
                }
                case "-verbose:class": {
                    ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.CLASS;
                    break;
                }
                default: {
                    throw new BadArgs("err.invalid.arg.for.option", string);
                }
            }
        }
    }, new Option(true, new String[]{"-cp", "-classpath"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.classpath = string2;
        }
    }, new Option(true, new String[]{"-p", "-package"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.packageNames.add(string2);
        }
    }, new Option(true, new String[]{"-e", "-regex"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.regex = string2;
        }
    }, new Option(true, new String[]{"-include"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            ((JdepsTask)jdepsTask).options.includePattern = Pattern.compile(string2);
        }
    }, new Option(false, new String[]{"-P", "-profile"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            ((JdepsTask)jdepsTask).options.showProfile = true;
            if (Profile.getProfileCount() == 0) {
                throw new BadArgs("err.option.unsupported", string, JdepsTask.getMessage("err.profiles.msg", new Object[0]));
            }
        }
    }, new Option(false, new String[]{"-apionly"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.apiOnly = true;
        }
    }, new Option(false, new String[]{"-R", "-recursive"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.depth = 0;
        }
    }, new Option(false, new String[]{"-jdkinternals"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.findJDKInternals = true;
            ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.CLASS;
            if (((JdepsTask)jdepsTask).options.includePattern == null) {
                ((JdepsTask)jdepsTask).options.includePattern = Pattern.compile(".*");
            }
        }
    }, new Option(false, new String[]{"-version"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.version = true;
        }
    }, new HiddenOption(false, new String[]{"-fullversion"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.fullVersion = true;
        }
    }, new HiddenOption(false, new String[]{"-showlabel"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.showLabel = true;
        }
    }, new HiddenOption(true, new String[]{"-depth"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            try {
                ((JdepsTask)jdepsTask).options.depth = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadArgs("err.invalid.arg.for.option", string);
            }
        }
    }};
    private static final String PROGNAME = "jdeps";
    private final Options options = new Options();
    private final List<String> classes = new ArrayList<String>();
    private PrintWriter log;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private final List<Archive> sourceLocations = new ArrayList<Archive>();

    JdepsTask() {
    }

    void setLog(PrintWriter printWriter) {
        this.log = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] stringArray) {
        if (this.log == null) {
            this.log = new PrintWriter(System.out);
        }
        try {
            this.handleOptions(stringArray);
            if (this.options.help) {
                this.showHelp();
            }
            if (this.options.version || this.options.fullVersion) {
                this.showVersion(this.options.fullVersion);
            }
            if (this.classes.isEmpty() && this.options.includePattern == null) {
                if (this.options.help || this.options.version || this.options.fullVersion) {
                    int n = 0;
                    return n;
                }
                this.showHelp();
                int n = 2;
                return n;
            }
            if (this.options.regex != null && this.options.packageNames.size() > 0) {
                this.showHelp();
                int n = 2;
                return n;
            }
            if (this.options.findJDKInternals && (this.options.regex != null || this.options.packageNames.size() > 0 || this.options.showSummary)) {
                this.showHelp();
                int n = 2;
                return n;
            }
            if (this.options.showSummary && this.options.verbose != Analyzer.Type.SUMMARY) {
                this.showHelp();
                int n = 2;
                return n;
            }
            boolean bl = this.run();
            int n = bl ? 0 : 1;
            return n;
        }
        catch (BadArgs badArgs) {
            this.reportError(badArgs.key, badArgs.args);
            if (badArgs.showUsage) {
                this.log.println(JdepsTask.getMessage("main.usage.summary", PROGNAME));
            }
            int n = 2;
            return n;
        }
        catch (IOException iOException) {
            int n = 4;
            return n;
        }
        finally {
            this.log.flush();
        }
    }

    private boolean run() throws IOException {
        this.findDependencies();
        Analyzer analyzer = new Analyzer(this.options.verbose);
        analyzer.run(this.sourceLocations);
        if (this.options.dotOutputDir != null) {
            Path path = Paths.get(this.options.dotOutputDir, new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            this.generateDotFiles(path, analyzer);
        } else {
            this.printRawOutput(this.log, analyzer);
        }
        return true;
    }

    private void generateDotFiles(Path path, Analyzer analyzer) throws IOException {
        Path path2 = path.resolve("summary.dot");
        boolean bl = this.options.verbose == Analyzer.Type.VERBOSE;
        DotGraph dotGraph = bl ? new DotSummaryForPackage() : new DotSummaryForArchive();
        for (Archive object2 : this.sourceLocations) {
            analyzer.visitArchiveDependences(object2, dotGraph);
            if (!bl && !this.options.showLabel) continue;
            analyzer.visitDependences(object2, dotGraph);
        }
        Throwable throwable = null;
        try (Iterator<Archive> iterator = new PrintWriter(Files.newOutputStream(path2, new OpenOption[0]));){
            dotGraph.writeTo((PrintWriter)((Object)iterator));
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (this.options.verbose != Analyzer.Type.SUMMARY) {
            for (Archive archive : this.sourceLocations) {
                if (!analyzer.hasDependences(archive)) continue;
                Path path3 = path.resolve(archive.getFileName() + ".dot");
                PrintWriter printWriter = new PrintWriter(Files.newOutputStream(path3, new OpenOption[0]));
                Throwable throwable4 = null;
                try {
                    DotFileFormatter dotFileFormatter = new DotFileFormatter(printWriter, archive);
                    Throwable throwable5 = null;
                    try {
                        analyzer.visitDependences(archive, dotFileFormatter);
                    }
                    catch (Throwable throwable6) {
                        throwable5 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (dotFileFormatter == null) continue;
                        if (throwable5 != null) {
                            try {
                                dotFileFormatter.close();
                            }
                            catch (Throwable throwable7) {
                                throwable5.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        dotFileFormatter.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable4 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (printWriter == null) continue;
                    if (throwable4 != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable9) {
                            throwable4.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    printWriter.close();
                }
            }
        }
    }

    private void printRawOutput(PrintWriter printWriter, Analyzer analyzer) {
        for (Archive archive : this.sourceLocations) {
            RawOutputFormatter rawOutputFormatter = new RawOutputFormatter(printWriter);
            analyzer.visitArchiveDependences(archive, rawOutputFormatter);
            if (this.options.verbose == Analyzer.Type.SUMMARY) continue;
            analyzer.visitDependences(archive, rawOutputFormatter);
        }
    }

    private boolean isValidClassName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private Dependency.Filter getDependencyFilter() {
        if (this.options.regex != null) {
            return Dependencies.getRegexFilter(Pattern.compile(this.options.regex));
        }
        if (this.options.packageNames.size() > 0) {
            return Dependencies.getPackageFilter(this.options.packageNames, false);
        }
        return new Dependency.Filter(){

            @Override
            public boolean accepts(Dependency dependency) {
                return !dependency.getOrigin().equals(dependency.getTarget());
            }
        };
    }

    private boolean matches(String string, AccessFlags accessFlags) {
        if (this.options.apiOnly && !accessFlags.is(1)) {
            return false;
        }
        if (this.options.includePattern != null) {
            return this.options.includePattern.matcher(string.replace('/', '.')).matches();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void findDependencies() throws IOException {
        int n;
        Object object;
        ClassFile classFile;
        Object object2;
        Iterable<Path> iterable;
        Dependency.Finder finder = this.options.apiOnly ? Dependencies.getAPIFinder(4) : Dependencies.getClassDependencyFinder();
        Dependency.Filter filter = this.getDependencyFilter();
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String object32 : this.classes) {
            iterable = Paths.get(object32, new String[0]);
            if (Files.exists((Path)iterable, new LinkOption[0])) {
                arrayList.add(new Archive((Path)iterable, ClassFileReader.newInstance((Path)iterable)));
                continue;
            }
            if (this.isValidClassName(object32)) {
                linkedList.add(object32);
                continue;
            }
            this.warning("warn.invalid.arg", object32);
        }
        this.sourceLocations.addAll(arrayList);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(this.getClassPathArchives(this.options.classpath));
        if (this.options.includePattern != null) {
            arrayList.addAll(arrayList2);
        }
        arrayList2.addAll(PlatformClassPath.getArchives());
        this.sourceLocations.addAll(arrayList2);
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        iterable = new HashSet();
        for (Archive archive : arrayList) {
            object2 = archive.reader().getClassFiles().iterator();
            while (object2.hasNext()) {
                classFile = object2.next();
                try {
                    object = classFile.getName();
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new Dependencies.ClassFileError(constantPoolException);
                }
                if (!this.matches((String)object, classFile.access_flags)) continue;
                if (!iterable.contains(object)) {
                    iterable.add((Object)object);
                }
                for (Dependency dependency : finder.findDependencies(classFile)) {
                    if (!filter.accepts(dependency)) continue;
                    String string = dependency.getTarget().getName();
                    if (!iterable.contains(string) && !linkedList2.contains(string)) {
                        linkedList2.add(string);
                    }
                    archive.addClass(dependency.getOrigin(), dependency.getTarget());
                }
            }
        }
        Object object3 = linkedList;
        int n2 = n = this.options.depth > 0 ? this.options.depth : Integer.MAX_VALUE;
        while (true) {
            void var6_8;
            if ((object2 = (String)object3.poll()) != null) {
                if (iterable.contains(object2)) continue;
                classFile = null;
                object = arrayList2.iterator();
                block9: while (object.hasNext()) {
                    String string;
                    Archive archive = (Archive)object.next();
                    classFile = archive.reader().getClassFile((String)object2);
                    if (classFile == null) continue;
                    try {
                        string = classFile.getName();
                    }
                    catch (ConstantPoolException constantPoolException) {
                        throw new Dependencies.ClassFileError(constantPoolException);
                    }
                    if (iterable.contains(string)) break;
                    iterable.add((String)string);
                    for (Dependency dependency : finder.findDependencies(classFile)) {
                        if (n == 0) {
                            archive.addClass(dependency.getOrigin());
                            break block9;
                        }
                        if (!filter.accepts(dependency)) continue;
                        archive.addClass(dependency.getOrigin(), dependency.getTarget());
                        String string2 = dependency.getTarget().getName();
                        if (iterable.contains(string2) || var6_8.contains(string2)) continue;
                        var6_8.add(string2);
                    }
                }
                if (classFile != null) continue;
                iterable.add((Object)object2);
                continue;
            }
            object3 = var6_8;
            LinkedList linkedList3 = new LinkedList();
            if (object3.isEmpty() || n-- <= 0) break;
        }
    }

    public void handleOptions(String[] stringArray) throws BadArgs {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].charAt(0) == '-') {
                string = stringArray[i];
                Option option = this.getOption(string);
                String string2 = null;
                if (option.hasArg) {
                    if (string.startsWith("-") && string.indexOf(61) > 0) {
                        string2 = string.substring(string.indexOf(61) + 1, string.length());
                    } else if (i + 1 < stringArray.length) {
                        string2 = stringArray[++i];
                    }
                    if (string2 == null || string2.isEmpty() || string2.charAt(0) == '-') {
                        throw new BadArgs("err.missing.arg", string).showUsage(true);
                    }
                }
                option.process(this, string, string2);
                if (!option.ignoreRest()) continue;
                i = stringArray.length;
                continue;
            }
            while (i < stringArray.length) {
                string = stringArray[i];
                if (string.charAt(0) == '-') {
                    throw new BadArgs("err.option.after.class", string).showUsage(true);
                }
                this.classes.add(string);
                ++i;
            }
        }
    }

    private Option getOption(String string) throws BadArgs {
        for (Option option : recognizedOptions) {
            if (!option.matches(string)) continue;
            return option;
        }
        throw new BadArgs("err.unknown.option", string).showUsage(true);
    }

    private void reportError(String string, Object ... objectArray) {
        this.log.println(JdepsTask.getMessage("error.prefix", new Object[0]) + " " + JdepsTask.getMessage(string, objectArray));
    }

    private void warning(String string, Object ... objectArray) {
        this.log.println(JdepsTask.getMessage("warn.prefix", new Object[0]) + " " + JdepsTask.getMessage(string, objectArray));
    }

    private void showHelp() {
        this.log.println(JdepsTask.getMessage("main.usage", PROGNAME));
        for (Option option : recognizedOptions) {
            String string = option.aliases[0].substring(1);
            String string2 = string = string.charAt(0) == '-' ? string.substring(1) : string;
            if (option.isHidden() || string.equals("h")) continue;
            this.log.println(JdepsTask.getMessage("main.opt." + string, new Object[0]));
        }
    }

    private void showVersion(boolean bl) {
        this.log.println(this.version(bl ? "full" : "release"));
    }

    private String version(String string) {
        if (ResourceBundleHelper.versionRB == null) {
            return System.getProperty("java.version");
        }
        try {
            return ResourceBundleHelper.versionRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return JdepsTask.getMessage("version.unknown", System.getProperty("java.version"));
        }
    }

    static String getMessage(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(ResourceBundleHelper.bundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            throw new InternalError("Missing message: " + string);
        }
    }

    private List<Archive> getArchives(List<String> list) throws IOException {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        for (String string : list) {
            Path path = Paths.get(string, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                arrayList.add(new Archive(path, ClassFileReader.newInstance(path)));
                continue;
            }
            this.warning("warn.file.not.exist", string);
        }
        return arrayList;
    }

    private List<Archive> getClassPathArchives(String string) throws IOException {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        if (string.isEmpty()) {
            return arrayList;
        }
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.length() <= 0) continue;
            ArrayList<Path> arrayList2 = new ArrayList<Path>();
            int n = string2.lastIndexOf(".*");
            if (n > 0) {
                Path path = Paths.get(string2.substring(0, n), new String[0]);
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "*.jar");){
                    for (Path path2 : directoryStream) {
                        arrayList2.add(path2);
                    }
                }
            } else {
                arrayList2.add(Paths.get(string2, new String[0]));
            }
            for (Path path : arrayList2) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                arrayList.add(new Archive(path, ClassFileReader.newInstance(path)));
            }
        }
        return arrayList;
    }

    private String getProfileArchiveInfo(Archive archive, Profile profile) {
        if (this.options.showProfile && profile != null) {
            return profile.toString();
        }
        if (archive instanceof PlatformClassPath.JDKArchive) {
            return profile == null ? "JDK internal API (" + archive.getFileName() + ")" : "";
        }
        return archive.getFileName();
    }

    private String profileName(Archive archive, Profile profile) {
        if (archive instanceof PlatformClassPath.JDKArchive) {
            return Objects.toString((Object)profile, "JDK internal API");
        }
        return "";
    }

    abstract class DotGraph<T>
    implements Analyzer.Visitor {
        private final Set<Edge> edges = new LinkedHashSet<Edge>();
        private Edge curEdge;

        DotGraph() {
        }

        public void writeTo(PrintWriter printWriter) {
            printWriter.format("digraph \"summary\" {%n", new Object[0]);
            for (Edge edge : this.edges) {
                this.writeEdge(printWriter, edge);
            }
            printWriter.println("}");
        }

        void writeEdge(PrintWriter printWriter, Edge edge) {
            printWriter.format("   %-50s -> \"%s\"%s;%n", String.format("\"%s\"", edge.from.toString()), edge.tag.isEmpty() ? edge.to : String.format("%s (%s)", edge.to, edge.tag), this.getLabel(edge));
        }

        Edge addEdge(T t, T t2, String string) {
            Edge edge = new Edge(t, t2, string);
            if (edge.equals(this.curEdge)) {
                return this.curEdge;
            }
            if (this.edges.contains(edge)) {
                for (Edge edge2 : this.edges) {
                    if (!edge.equals(edge2)) continue;
                    this.curEdge = edge2;
                }
            } else {
                this.edges.add(edge);
                this.curEdge = edge;
            }
            return this.curEdge;
        }

        Edge findEdge(T t, T t2) {
            for (Edge edge : this.edges) {
                if (!edge.from.equals(t) || !edge.to.equals(t2)) continue;
                return edge;
            }
            return null;
        }

        String getLabel(Edge edge) {
            String string = edge.label.toString();
            return string.isEmpty() ? "" : String.format("[label=\"%s\",fontsize=9]", string);
        }

        class Edge {
            final T from;
            final T to;
            final String tag;
            final StringBuilder label = new StringBuilder();

            Edge(T t, T t2, String string) {
                this.from = t;
                this.to = t2;
                this.tag = string;
            }

            void addLabel(String string) {
                this.label.append(string).append("\\n");
            }

            void addLabel(String string, String string2, String string3) {
                this.label.append(string).append(" -> ").append(string2);
                if (!string3.isEmpty()) {
                    this.label.append(" (" + string3 + ")");
                }
                this.label.append("\\n");
            }

            public boolean equals(Object object) {
                if (object instanceof Edge) {
                    Edge edge = (Edge)object;
                    return this.from.equals(edge.from) && this.to.equals(edge.to) && this.tag.equals(edge.tag);
                }
                return false;
            }

            public int hashCode() {
                int n = 7;
                n = 67 * n + Objects.hashCode(this.from) + Objects.hashCode(this.to) + Objects.hashCode(this.tag);
                return n;
            }
        }
    }

    class DotSummaryForPackage
    extends DotGraph<String> {
        DotSummaryForPackage() {
        }

        private String packageOf(String string) {
            int n = string.lastIndexOf(46);
            return n > 0 ? string.substring(0, n) : "<unnamed>";
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2, Profile profile) {
            String string3 = this.packageOf(string);
            String string4 = this.packageOf(string2);
            DotGraph.Edge edge = this.addEdge(string3, string4, JdepsTask.this.getProfileArchiveInfo(archive2, profile));
            if (!((JdepsTask)JdepsTask.this).options.showLabel || profile == Profile.COMPACT1) {
                return;
            }
            int n = string.lastIndexOf(46);
            String string5 = n < 0 ? string : string.substring(n + 1);
            edge.addLabel(string5, string2, JdepsTask.this.profileName(archive2, profile));
        }

        @Override
        public void visitArchiveDependence(Archive archive, Archive archive2, Profile profile) {
        }
    }

    class DotSummaryForArchive
    extends DotGraph<Archive> {
        DotSummaryForArchive() {
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2, Profile profile) {
            DotGraph.Edge edge = this.findEdge(archive, archive2);
            assert (edge != null);
            if (profile == Profile.COMPACT1) {
                return;
            }
            edge.addLabel(string, string2, JdepsTask.this.profileName(archive2, profile));
        }

        @Override
        public void visitArchiveDependence(Archive archive, Archive archive2, Profile profile) {
            DotGraph.Edge edge = this.addEdge(archive, archive2, "");
            if (archive2 instanceof PlatformClassPath.JDKArchive) {
                if (profile == null) {
                    edge.addLabel("JDK internal API");
                } else if (((JdepsTask)JdepsTask.this).options.showProfile && !((JdepsTask)JdepsTask.this).options.showLabel) {
                    edge.addLabel(profile.toString());
                }
            }
        }
    }

    class DotFileFormatter
    extends DotGraph<String>
    implements AutoCloseable {
        private final PrintWriter writer;
        private final String name;

        DotFileFormatter(PrintWriter printWriter, Archive archive) {
            this.writer = printWriter;
            this.name = archive.getFileName();
            printWriter.format("digraph \"%s\" {%n", this.name);
            printWriter.format("    // Path: %s%n", archive.getPathName());
        }

        @Override
        public void close() {
            this.writer.println("}");
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2, Profile profile) {
            if (((JdepsTask)JdepsTask.this).options.findJDKInternals && (!(archive2 instanceof PlatformClassPath.JDKArchive) || profile != null)) {
                return;
            }
            String string3 = JdepsTask.this.getProfileArchiveInfo(archive2, profile);
            this.writeEdge(this.writer, new DotGraph.Edge(string, string2, JdepsTask.this.getProfileArchiveInfo(archive2, profile)));
        }

        @Override
        public void visitArchiveDependence(Archive archive, Archive archive2, Profile profile) {
            throw new UnsupportedOperationException();
        }
    }

    class RawOutputFormatter
    implements Analyzer.Visitor {
        private final PrintWriter writer;
        private String pkg = "";

        RawOutputFormatter(PrintWriter printWriter) {
            this.writer = printWriter;
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2, Profile profile) {
            if (((JdepsTask)JdepsTask.this).options.findJDKInternals && (!(archive2 instanceof PlatformClassPath.JDKArchive) || profile != null)) {
                return;
            }
            if (((JdepsTask)JdepsTask.this).options.verbose == Analyzer.Type.VERBOSE) {
                this.writer.format("   %-50s -> %-50s %s%n", string, string2, JdepsTask.this.getProfileArchiveInfo(archive2, profile));
            } else {
                if (!string.equals(this.pkg)) {
                    this.pkg = string;
                    this.writer.format("   %s (%s)%n", string, archive.getFileName());
                }
                this.writer.format("      -> %-50s %s%n", string2, JdepsTask.this.getProfileArchiveInfo(archive2, profile));
            }
        }

        @Override
        public void visitArchiveDependence(Archive archive, Archive archive2, Profile profile) {
            this.writer.format("%s -> %s", archive.getPathName(), archive2.getPathName());
            if (((JdepsTask)JdepsTask.this).options.showProfile && profile != null) {
                this.writer.format(" (%s)%n", new Object[]{profile});
            } else {
                this.writer.format("%n", new Object[0]);
            }
        }
    }

    private static class ResourceBundleHelper {
        static final ResourceBundle versionRB;
        static final ResourceBundle bundle;

        private ResourceBundleHelper() {
        }

        static {
            Locale locale = Locale.getDefault();
            try {
                bundle = ResourceBundle.getBundle("com.sun.tools.jdeps.resources.jdeps", locale);
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError("Cannot find jdeps resource bundle for locale " + locale);
            }
            try {
                versionRB = ResourceBundle.getBundle("com.sun.tools.jdeps.resources.version");
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError("version.resource.missing");
            }
        }
    }

    private static class Options {
        boolean help;
        boolean version;
        boolean fullVersion;
        boolean showProfile;
        boolean showSummary;
        boolean wildcard;
        boolean apiOnly;
        boolean showLabel;
        boolean findJDKInternals;
        String dotOutputDir;
        String classpath = "";
        int depth = 1;
        Analyzer.Type verbose = Analyzer.Type.PACKAGE;
        Set<String> packageNames = new HashSet<String>();
        String regex;
        Pattern includePattern;

        private Options() {
        }
    }

    static abstract class HiddenOption
    extends Option {
        HiddenOption(boolean bl, String ... stringArray) {
            super(bl, stringArray);
        }

        @Override
        boolean isHidden() {
            return true;
        }
    }

    static abstract class Option {
        final boolean hasArg;
        final String[] aliases;

        Option(boolean bl, String ... stringArray) {
            this.hasArg = bl;
            this.aliases = stringArray;
        }

        boolean isHidden() {
            return false;
        }

        boolean matches(String string) {
            for (String string2 : this.aliases) {
                if (string2.equals(string)) {
                    return true;
                }
                if (!this.hasArg || !string.startsWith(string2 + "=")) continue;
                return true;
            }
            return false;
        }

        boolean ignoreRest() {
            return false;
        }

        abstract void process(JdepsTask var1, String var2, String var3) throws BadArgs;
    }

    static class BadArgs
    extends Exception {
        static final long serialVersionUID = 8765093759964640721L;
        final String key;
        final Object[] args;
        boolean showUsage;

        BadArgs(String string, Object ... objectArray) {
            super(JdepsTask.getMessage(string, objectArray));
            this.key = string;
            this.args = objectArray;
        }

        BadArgs showUsage(boolean bl) {
            this.showUsage = bl;
            return this;
        }
    }
}

