/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Dependencies;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFileReader {
    protected final Path path;
    protected final String baseFileName;

    public static ClassFileReader newInstance(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(path.toString());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new DirectoryReader(path);
        }
        if (path.getFileName().toString().endsWith(".jar")) {
            return new JarFileReader(path);
        }
        return new ClassFileReader(path);
    }

    public static ClassFileReader newInstance(Path path, JarFile jarFile) throws IOException {
        return new JarFileReader(path, jarFile);
    }

    private ClassFileReader(Path path) {
        this.path = path;
        this.baseFileName = path.getFileName() != null ? path.getFileName().toString() : path.toString();
    }

    public String getFileName() {
        return this.baseFileName;
    }

    public ClassFile getClassFile(String string) throws IOException {
        if (string.indexOf(46) > 0) {
            int n = string.lastIndexOf(46);
            String string2 = string.replace('.', File.separatorChar) + ".class";
            if (this.baseFileName.equals(string2) || this.baseFileName.equals(string2.substring(0, n) + "$" + string2.substring(n + 1, string2.length()))) {
                return this.readClassFile(this.path);
            }
        } else if (this.baseFileName.equals(string.replace('/', File.separatorChar) + ".class")) {
            return this.readClassFile(this.path);
        }
        return null;
    }

    public Iterable<ClassFile> getClassFiles() throws IOException {
        return new Iterable<ClassFile>(){

            @Override
            public Iterator<ClassFile> iterator() {
                return new FileIterator();
            }
        };
    }

    protected ClassFile readClassFile(Path path) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            ClassFile classFile = ClassFile.read(inputStream);
            return classFile;
        }
    }

    public String toString() {
        return this.path.toString();
    }

    private static class JarFileReader
    extends ClassFileReader {
        final JarFile jarfile;

        JarFileReader(Path path) throws IOException {
            this(path, new JarFile(path.toFile()));
        }

        JarFileReader(Path path, JarFile jarFile) throws IOException {
            super(path);
            this.jarfile = jarFile;
        }

        @Override
        public ClassFile getClassFile(String string) throws IOException {
            if (string.indexOf(46) > 0) {
                int n = string.lastIndexOf(46);
                String string2 = string.replace('.', '/') + ".class";
                JarEntry jarEntry = this.jarfile.getJarEntry(string2);
                if (jarEntry == null) {
                    jarEntry = this.jarfile.getJarEntry(string2.substring(0, n) + "$" + string2.substring(n + 1, string2.length()));
                }
                if (jarEntry != null) {
                    return this.readClassFile(jarEntry);
                }
            } else {
                JarEntry jarEntry = this.jarfile.getJarEntry(string + ".class");
                if (jarEntry != null) {
                    return this.readClassFile(jarEntry);
                }
            }
            return null;
        }

        private ClassFile readClassFile(JarEntry jarEntry) throws IOException {
            try (InputStream inputStream = null;){
                inputStream = this.jarfile.getInputStream(jarEntry);
                ClassFile classFile = ClassFile.read(inputStream);
                return classFile;
            }
        }

        @Override
        public Iterable<ClassFile> getClassFiles() throws IOException {
            final JarFileIterator jarFileIterator = new JarFileIterator();
            return new Iterable<ClassFile>(){

                @Override
                public Iterator<ClassFile> iterator() {
                    return jarFileIterator;
                }
            };
        }

        class JarFileIterator
        implements Iterator<ClassFile> {
            private Enumeration<JarEntry> entries;
            private JarEntry nextEntry;

            JarFileIterator() {
                this.entries = JarFileReader.this.jarfile.entries();
                while (this.entries.hasMoreElements()) {
                    JarEntry jarEntry = this.entries.nextElement();
                    String string = jarEntry.getName();
                    if (!string.endsWith(".class")) continue;
                    this.nextEntry = jarEntry;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            @Override
            public ClassFile next() {
                ClassFile classFile;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    classFile = JarFileReader.this.readClassFile(this.nextEntry);
                }
                catch (IOException iOException) {
                    throw new Dependencies.ClassFileError(iOException);
                }
                JarEntry jarEntry = this.nextEntry;
                this.nextEntry = null;
                while (this.entries.hasMoreElements()) {
                    JarEntry jarEntry2 = this.entries.nextElement();
                    String string = jarEntry2.getName();
                    if (!string.endsWith(".class")) continue;
                    this.nextEntry = jarEntry2;
                    break;
                }
                return classFile;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    private static class DirectoryReader
    extends ClassFileReader {
        DirectoryReader(Path path) throws IOException {
            super(path);
        }

        @Override
        public ClassFile getClassFile(String string) throws IOException {
            if (string.indexOf(46) > 0) {
                int n = string.lastIndexOf(46);
                String string2 = string.replace('.', File.separatorChar) + ".class";
                Path path = this.path.resolve(string2);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = this.path.resolve(string2.substring(0, n) + "$" + string2.substring(n + 1, string2.length()));
                }
                if (Files.exists(path, new LinkOption[0])) {
                    return this.readClassFile(path);
                }
            } else {
                Path path = this.path.resolve(string + ".class");
                if (Files.exists(path, new LinkOption[0])) {
                    return this.readClassFile(path);
                }
            }
            return null;
        }

        @Override
        public Iterable<ClassFile> getClassFiles() throws IOException {
            final DirectoryIterator directoryIterator = new DirectoryIterator();
            return new Iterable<ClassFile>(){

                @Override
                public Iterator<ClassFile> iterator() {
                    return directoryIterator;
                }
            };
        }

        private List<Path> walkTree(Path path) throws IOException {
            final ArrayList<Path> arrayList = new ArrayList<Path>();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (path.getFileName().toString().endsWith(".class")) {
                        arrayList.add(path);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return arrayList;
        }

        class DirectoryIterator
        implements Iterator<ClassFile> {
            private List<Path> entries;
            private int index = 0;

            DirectoryIterator() throws IOException {
                this.entries = DirectoryReader.this.walkTree(DirectoryReader.this.path);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index != this.entries.size();
            }

            @Override
            public ClassFile next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Path path = this.entries.get(this.index++);
                try {
                    return DirectoryReader.this.readClassFile(path);
                }
                catch (IOException iOException) {
                    throw new Dependencies.ClassFileError(iOException);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    class FileIterator
    implements Iterator<ClassFile> {
        int count = 0;

        FileIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count == 0 && ClassFileReader.this.baseFileName.endsWith(".class");
        }

        @Override
        public ClassFile next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                ClassFile classFile = ClassFileReader.this.readClassFile(ClassFileReader.this.path);
                ++this.count;
                return classFile;
            }
            catch (IOException iOException) {
                throw new Dependencies.ClassFileError(iOException);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

