/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.Dependency;
import com.sun.tools.jdeps.ClassFileReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Archive {
    private final Path path;
    private final String filename;
    private final ClassFileReader reader;
    private final Map<Dependency.Location, Set<Dependency.Location>> deps = new HashMap<Dependency.Location, Set<Dependency.Location>>();

    public Archive(String string) {
        this.path = null;
        this.filename = string;
        this.reader = null;
    }

    public Archive(Path path, ClassFileReader classFileReader) {
        this.path = path;
        this.filename = this.path.getFileName().toString();
        this.reader = classFileReader;
    }

    public ClassFileReader reader() {
        return this.reader;
    }

    public String getFileName() {
        return this.filename;
    }

    public void addClass(Dependency.Location location) {
        Set<Dependency.Location> set = this.deps.get(location);
        if (set == null) {
            set = new HashSet<Dependency.Location>();
            this.deps.put(location, set);
        }
    }

    public void addClass(Dependency.Location location, Dependency.Location location2) {
        Set<Dependency.Location> set = this.deps.get(location);
        if (set == null) {
            set = new HashSet<Dependency.Location>();
            this.deps.put(location, set);
        }
        set.add(location2);
    }

    public Set<Dependency.Location> getClasses() {
        return this.deps.keySet();
    }

    public void visitDependences(Visitor visitor) {
        for (Map.Entry<Dependency.Location, Set<Dependency.Location>> entry : this.deps.entrySet()) {
            for (Dependency.Location location : entry.getValue()) {
                visitor.visit(entry.getKey(), location);
            }
        }
    }

    public String getPathName() {
        return this.path != null ? this.path.toString() : this.filename;
    }

    public String toString() {
        return this.filename;
    }

    static interface Visitor {
        public void visit(Dependency.Location var1, Dependency.Location var2);
    }
}

