/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.Dependency;
import com.sun.tools.jdeps.Archive;
import com.sun.tools.jdeps.JdepsTask;
import com.sun.tools.jdeps.PlatformClassPath;
import com.sun.tools.jdeps.Profile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Analyzer {
    private final Type type;
    private final Map<Archive, ArchiveDeps> results = new HashMap<Archive, ArchiveDeps>();
    private final Map<Dependency.Location, Archive> map = new HashMap<Dependency.Location, Archive>();
    private final Archive NOT_FOUND = new Archive(JdepsTask.getMessage("artifact.not.found", new Object[0]));

    public Analyzer(Type type) {
        this.type = type;
    }

    public void run(List<Archive> list) {
        for (Archive archive : list) {
            for (Dependency.Location location : archive.getClasses()) {
                if (this.map.containsKey(location)) continue;
                this.map.put(location, archive);
            }
        }
        for (Archive archive : list) {
            ArchiveDeps archiveDeps = this.type == Type.CLASS || this.type == Type.VERBOSE ? new ClassVisitor(archive) : new PackageVisitor(archive);
            archive.visitDependences(archiveDeps);
            this.results.put(archive, archiveDeps);
        }
    }

    public boolean hasDependences(Archive archive) {
        if (this.results.containsKey(archive)) {
            return this.results.get((Object)archive).deps.size() > 0;
        }
        return false;
    }

    public void visitArchiveDependences(Archive archive, Visitor visitor) {
        ArchiveDeps archiveDeps = this.results.get(archive);
        for (ArchiveDeps.Dep dep : archiveDeps.requireArchives()) {
            visitor.visitArchiveDependence(archiveDeps.archive, dep.archive, dep.profile);
        }
    }

    public void visitDependences(Archive archive, Visitor visitor) {
        ArchiveDeps archiveDeps = this.results.get(archive);
        for (Map.Entry<String, SortedSet<ArchiveDeps.Dep>> entry : archiveDeps.deps.entrySet()) {
            String string = entry.getKey();
            for (ArchiveDeps.Dep dep : entry.getValue()) {
                if (this.type != Type.VERBOSE && dep.archive == archive) continue;
                visitor.visitDependence(string, archive, dep.target, dep.archive, dep.profile);
            }
        }
    }

    private class PackageVisitor
    extends ArchiveDeps {
        PackageVisitor(Archive archive) {
            super(archive);
        }

        @Override
        public void visit(Dependency.Location location, Dependency.Location location2) {
            Archive archive;
            Archive archive2 = archive = this.archive.getClasses().contains(location2) ? this.archive : (Archive)Analyzer.this.map.get(location2);
            if (archive == null) {
                archive = Analyzer.this.NOT_FOUND;
                Analyzer.this.map.put(location2, archive);
            }
            String string = this.packageOf(location);
            String string2 = this.packageOf(location2);
            this.add(string, string2, archive, location2.getPackageName());
        }

        public String packageOf(Dependency.Location location) {
            String string = location.getPackageName();
            return string.isEmpty() ? "<unnamed>" : string;
        }
    }

    private class ClassVisitor
    extends ArchiveDeps {
        ClassVisitor(Archive archive) {
            super(archive);
        }

        @Override
        public void visit(Dependency.Location location, Dependency.Location location2) {
            Archive archive;
            Archive archive2 = archive = this.archive.getClasses().contains(location2) ? this.archive : (Archive)Analyzer.this.map.get(location2);
            if (archive == null) {
                archive = Analyzer.this.NOT_FOUND;
                Analyzer.this.map.put(location2, archive);
            }
            String string = location.getClassName();
            String string2 = location2.getClassName();
            this.add(string, string2, archive, location2.getPackageName());
        }
    }

    private abstract class ArchiveDeps
    implements Archive.Visitor {
        final Archive archive;
        final SortedMap<String, SortedSet<Dep>> deps;

        ArchiveDeps(Archive archive) {
            this.archive = archive;
            this.deps = new TreeMap<String, SortedSet<Dep>>();
        }

        void add(String string, String string2, Archive archive, String string3) {
            TreeSet<Dep> treeSet = (TreeSet<Dep>)this.deps.get(string);
            if (treeSet == null) {
                treeSet = new TreeSet<Dep>();
                this.deps.put(string, treeSet);
            }
            Profile profile = archive instanceof PlatformClassPath.JDKArchive ? Profile.getProfile(string3) : null;
            treeSet.add(new Dep(string2, archive, profile));
        }

        List<Dep> requireArchives() {
            HashMap<Archive, Profile> hashMap = new HashMap<Archive, Profile>();
            for (Set object : this.deps.values()) {
                for (Dep dep : object) {
                    Profile profile;
                    if (this.archive == dep.archive || (profile = (Profile)((Object)hashMap.get(dep.archive))) != null && (dep.profile == null || profile.profile >= dep.profile.profile)) continue;
                    hashMap.put(dep.archive, dep.profile);
                }
            }
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : hashMap.entrySet()) {
                arrayList.add(new Dep("", (Archive)entry.getKey(), (Profile)((Object)entry.getValue())));
            }
            return arrayList;
        }

        @Override
        public abstract void visit(Dependency.Location var1, Dependency.Location var2);

        class Dep
        implements Comparable<Dep> {
            final String target;
            final Archive archive;
            final Profile profile;

            Dep(String string, Archive archive, Profile profile) {
                this.target = string;
                this.archive = archive;
                this.profile = profile;
            }

            public boolean equals(Object object) {
                if (object instanceof Dep) {
                    Dep dep = (Dep)object;
                    return this.archive == dep.archive && this.target.equals(dep.target);
                }
                return false;
            }

            public int hashCode() {
                int n = 3;
                n = 17 * n + Objects.hashCode(this.archive);
                n = 17 * n + Objects.hashCode(this.target);
                return n;
            }

            @Override
            public int compareTo(Dep dep) {
                if (this.target.equals(dep.target)) {
                    if (this.archive == dep.archive) {
                        return 0;
                    }
                    return this.archive.getFileName().compareTo(dep.archive.getFileName());
                }
                return this.target.compareTo(dep.target);
            }
        }
    }

    public static interface Visitor {
        public void visitArchiveDependence(Archive var1, Archive var2, Profile var3);

        public void visitDependence(String var1, Archive var2, String var3, Archive var4, Profile var5);
    }

    public static enum Type {
        SUMMARY,
        PACKAGE,
        CLASS,
        VERBOSE;

    }
}

