/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.LocalVariableTable_attribute;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class LocalVariableTableWriter
extends InstructionDetailWriter {
    private ClassWriter classWriter;
    private Code_attribute codeAttr;
    private Map<Integer, List<LocalVariableTable_attribute.Entry>> pcMap;

    static LocalVariableTableWriter instance(Context context) {
        LocalVariableTableWriter localVariableTableWriter = context.get(LocalVariableTableWriter.class);
        if (localVariableTableWriter == null) {
            localVariableTableWriter = new LocalVariableTableWriter(context);
        }
        return localVariableTableWriter;
    }

    protected LocalVariableTableWriter(Context context) {
        super(context);
        context.put(LocalVariableTableWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute code_attribute) {
        this.codeAttr = code_attribute;
        this.pcMap = new HashMap<Integer, List<LocalVariableTable_attribute.Entry>>();
        LocalVariableTable_attribute localVariableTable_attribute = (LocalVariableTable_attribute)code_attribute.attributes.get("LocalVariableTable");
        if (localVariableTable_attribute == null) {
            return;
        }
        for (int i = 0; i < localVariableTable_attribute.local_variable_table.length; ++i) {
            LocalVariableTable_attribute.Entry entry = localVariableTable_attribute.local_variable_table[i];
            this.put(entry.start_pc, entry);
            this.put(entry.start_pc + entry.length, entry);
        }
    }

    @Override
    public void writeDetails(Instruction instruction) {
        int n = instruction.getPC();
        this.writeLocalVariables(n, NoteKind.END);
        this.writeLocalVariables(n, NoteKind.START);
    }

    @Override
    public void flush() {
        int n = this.codeAttr.code_length;
        this.writeLocalVariables(n, NoteKind.END);
    }

    public void writeLocalVariables(int n, NoteKind noteKind) {
        ConstantPool constantPool = this.classWriter.getClassFile().constant_pool;
        String string = this.space(2);
        List<LocalVariableTable_attribute.Entry> list = this.pcMap.get(n);
        if (list != null) {
            ListIterator<LocalVariableTable_attribute.Entry> listIterator = list.listIterator(noteKind == NoteKind.END ? list.size() : 0);
            while (noteKind == NoteKind.END ? listIterator.hasPrevious() : listIterator.hasNext()) {
                LocalVariableTable_attribute.Entry entry = noteKind == NoteKind.END ? listIterator.previous() : listIterator.next();
                if (!noteKind.match(entry, n)) continue;
                this.print(string);
                this.print(noteKind.text);
                this.print(" local ");
                this.print(entry.index);
                this.print(" // ");
                Descriptor descriptor = new Descriptor(entry.descriptor_index);
                try {
                    this.print(descriptor.getFieldType(constantPool));
                }
                catch (Descriptor.InvalidDescriptor invalidDescriptor) {
                    this.print(this.report(invalidDescriptor));
                }
                catch (ConstantPoolException constantPoolException) {
                    this.print(this.report(constantPoolException));
                }
                this.print(" ");
                try {
                    this.print(constantPool.getUTF8Value(entry.name_index));
                }
                catch (ConstantPoolException constantPoolException) {
                    this.print(this.report(constantPoolException));
                }
                this.println();
            }
        }
    }

    private void put(int n, LocalVariableTable_attribute.Entry entry) {
        List<LocalVariableTable_attribute.Entry> list = this.pcMap.get(n);
        if (list == null) {
            list = new ArrayList<LocalVariableTable_attribute.Entry>();
            this.pcMap.put(n, list);
        }
        if (!list.contains(entry)) {
            list.add(entry);
        }
    }

    public static enum NoteKind {
        START("start"){

            @Override
            public boolean match(LocalVariableTable_attribute.Entry entry, int n) {
                return n == entry.start_pc;
            }
        }
        ,
        END("end"){

            @Override
            public boolean match(LocalVariableTable_attribute.Entry entry, int n) {
                return n == entry.start_pc + entry.length;
            }
        };

        public final String text;

        private NoteKind(String string2) {
            this.text = string2;
        }

        public abstract boolean match(LocalVariableTable_attribute.Entry var1, int var2);
    }
}

