/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.ConstantValue_attribute;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.DescriptorException;
import com.sun.tools.classfile.Exceptions_attribute;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.Signature;
import com.sun.tools.classfile.Signature_attribute;
import com.sun.tools.classfile.SourceFile_attribute;
import com.sun.tools.classfile.Type;
import com.sun.tools.javap.AttributeWriter;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.CodeWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Options;
import java.net.URI;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ClassWriter
extends BasicWriter {
    private Options options;
    private AttributeWriter attrWriter;
    private CodeWriter codeWriter;
    private ConstantWriter constantWriter;
    private ClassFile classFile;
    private URI uri;
    private long lastModified;
    private String digestName;
    private byte[] digest;
    private int size;
    private ConstantPool constant_pool;
    private Method method;

    static ClassWriter instance(Context context) {
        ClassWriter classWriter = context.get(ClassWriter.class);
        if (classWriter == null) {
            classWriter = new ClassWriter(context);
        }
        return classWriter;
    }

    protected ClassWriter(Context context) {
        super(context);
        context.put(ClassWriter.class, this);
        this.options = Options.instance(context);
        this.attrWriter = AttributeWriter.instance(context);
        this.codeWriter = CodeWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
    }

    void setDigest(String string, byte[] byArray) {
        this.digestName = string;
        this.digest = byArray;
    }

    void setFile(URI uRI) {
        this.uri = uRI;
    }

    void setFileSize(int n) {
        this.size = n;
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    protected ClassFile getClassFile() {
        return this.classFile;
    }

    protected void setClassFile(ClassFile classFile) {
        this.classFile = classFile;
        this.constant_pool = this.classFile.constant_pool;
    }

    protected Method getMethod() {
        return this.method;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ClassFile classFile) {
        Object object;
        Object object2;
        this.setClassFile(classFile);
        if ((this.options.sysInfo || this.options.verbose) && !this.options.compat) {
            if (this.uri != null) {
                if (this.uri.getScheme().equals("file")) {
                    this.println("Classfile " + this.uri.getPath());
                } else {
                    this.println("Classfile " + this.uri);
                }
            }
            this.indent(1);
            if (this.lastModified != -1L) {
                object2 = new Date(this.lastModified);
                object = DateFormat.getDateInstance();
                if (this.size > 0) {
                    this.println("Last modified " + ((DateFormat)object).format((Date)object2) + "; size " + this.size + " bytes");
                } else {
                    this.println("Last modified " + ((DateFormat)object).format((Date)object2));
                }
            } else if (this.size > 0) {
                this.println("Size " + this.size + " bytes");
            }
            if (this.digestName != null && this.digest != null) {
                object2 = new StringBuilder();
                for (Object object3 : (Object)this.digest) {
                    ((StringBuilder)object2).append(String.format("%02x", (byte)object3));
                }
                this.println(this.digestName + " checksum " + object2);
            }
        }
        if ((object2 = classFile.getAttribute("SourceFile")) instanceof SourceFile_attribute) {
            this.println("Compiled from \"" + this.getSourceFile((SourceFile_attribute)object2) + "\"");
        }
        if ((this.options.sysInfo || this.options.verbose) && !this.options.compat) {
            this.indent(-1);
        }
        object = this.getJavaName(this.classFile);
        AccessFlags accessFlags = classFile.access_flags;
        this.writeModifiers(accessFlags.getClassModifiers());
        if (this.classFile.isClass()) {
            this.print("class ");
        } else if (this.classFile.isInterface()) {
            this.print("interface ");
        }
        this.print((String)object);
        Signature_attribute signature_attribute = this.getSignature(classFile.attributes);
        if (signature_attribute != null) {
            try {
                Type type = signature_attribute.getParsedSignature().getType(this.constant_pool);
                JavaTypePrinter javaTypePrinter = new JavaTypePrinter(this.classFile.isInterface());
                if (type instanceof Type.ClassSigType) {
                    this.print(javaTypePrinter.print(type));
                } else if (this.options.verbose || !type.isObject()) {
                    this.print(" extends ");
                    this.print(javaTypePrinter.print(type));
                }
            }
            catch (ConstantPoolException constantPoolException) {
                this.print(this.report(constantPoolException));
            }
        } else {
            String string;
            if (this.classFile.isClass() && this.classFile.super_class != 0 && !(string = this.getJavaSuperclassName(classFile)).equals("java.lang.Object")) {
                this.print(" extends ");
                this.print(string);
            }
            for (int i = 0; i < this.classFile.interfaces.length; ++i) {
                this.print(i == 0 ? (this.classFile.isClass() ? " implements " : " extends ") : ",");
                this.print(this.getJavaInterfaceName(this.classFile, i));
            }
        }
        if (this.options.verbose) {
            this.println();
            this.indent(1);
            this.attrWriter.write((Object)classFile, classFile.attributes, this.constant_pool);
            this.println("minor version: " + classFile.minor_version);
            this.println("major version: " + classFile.major_version);
            if (!this.options.compat) {
                this.writeList("flags: ", accessFlags.getClassFlags(), "\n");
            }
            this.indent(-1);
            this.constantWriter.writeConstantPool();
        } else {
            this.print(" ");
        }
        this.println("{");
        this.indent(1);
        this.writeFields();
        this.writeMethods();
        this.indent(-1);
        this.println("}");
    }

    protected void writeFields() {
        for (Field field : this.classFile.fields) {
            this.writeField(field);
        }
    }

    protected void writeField(Field field) {
        Iterator<Attribute> iterator;
        if (!this.options.checkAccess(field.access_flags)) {
            return;
        }
        AccessFlags accessFlags = field.access_flags;
        this.writeModifiers(accessFlags.getFieldModifiers());
        Signature_attribute signature_attribute = this.getSignature(field.attributes);
        if (signature_attribute == null) {
            this.print(this.getJavaFieldType(field.descriptor));
        } else {
            try {
                iterator = signature_attribute.getParsedSignature().getType(this.constant_pool);
                this.print(ClassWriter.getJavaName(iterator.toString()));
            }
            catch (ConstantPoolException constantPoolException) {
                this.print(this.getJavaFieldType(field.descriptor));
            }
        }
        this.print(" ");
        this.print(this.getFieldName(field));
        if (this.options.showConstants && !this.options.compat && (iterator = field.attributes.get("ConstantValue")) instanceof ConstantValue_attribute) {
            this.print(" = ");
            Attribute attribute = (ConstantValue_attribute)((Object)iterator);
            this.print(this.getConstantValue(field.descriptor, attribute.constantvalue_index));
        }
        this.print(";");
        this.println();
        this.indent(1);
        if (this.options.showDescriptors) {
            this.println("descriptor: " + this.getValue(field.descriptor));
        }
        if (this.options.verbose && !this.options.compat) {
            this.writeList("flags: ", accessFlags.getFieldFlags(), "\n");
        }
        if (this.options.showAllAttrs) {
            for (Attribute attribute : field.attributes) {
                this.attrWriter.write((Object)field, attribute, this.constant_pool);
            }
            this.println();
        }
        this.indent(-1);
        if (this.options.showDisassembled || this.options.showLineAndLocalVariableTables) {
            this.println();
        }
    }

    protected void writeMethods() {
        for (Method method : this.classFile.methods) {
            this.writeMethod(method);
        }
        this.setPendingNewline(false);
    }

    protected void writeMethod(Method method) {
        Attribute attribute;
        Object object;
        List<? extends Type> list;
        Type.MethodType methodType;
        Descriptor descriptor;
        if (!this.options.checkAccess(method.access_flags)) {
            return;
        }
        this.method = method;
        AccessFlags accessFlags = method.access_flags;
        Signature_attribute signature_attribute = this.getSignature(method.attributes);
        if (signature_attribute == null) {
            descriptor = method.descriptor;
            methodType = null;
            list = null;
        } else {
            object = signature_attribute.getParsedSignature();
            descriptor = object;
            try {
                methodType = (Type.MethodType)((Signature)object).getType(this.constant_pool);
                list = methodType.throwsTypes;
                if (list != null && list.isEmpty()) {
                    list = null;
                }
            }
            catch (ConstantPoolException constantPoolException) {
                methodType = null;
                list = null;
            }
        }
        this.writeModifiers(accessFlags.getMethodModifiers());
        if (methodType != null) {
            this.print(new JavaTypePrinter(false).printTypeArgs(methodType.typeParamTypes));
        }
        if (this.getName(method).equals("<init>")) {
            this.print(this.getJavaName(this.classFile));
            this.print(this.getJavaParameterTypes(descriptor, accessFlags));
        } else if (this.getName(method).equals("<clinit>")) {
            this.print("{}");
        } else {
            this.print(this.getJavaReturnType(descriptor));
            this.print(" ");
            this.print(this.getName(method));
            this.print(this.getJavaParameterTypes(descriptor, accessFlags));
        }
        object = method.attributes.get("Exceptions");
        if (object != null) {
            if (object instanceof Exceptions_attribute) {
                attribute = (Exceptions_attribute)object;
                this.print(" throws ");
                if (list != null) {
                    this.writeList("", list, "");
                } else {
                    for (int i = 0; i < attribute.number_of_exceptions; ++i) {
                        if (i > 0) {
                            this.print(", ");
                        }
                        this.print(this.getJavaException((Exceptions_attribute)attribute, i));
                    }
                }
            } else {
                this.report("Unexpected or invalid value for Exceptions attribute");
            }
        }
        this.println(";");
        this.indent(1);
        if (this.options.showDescriptors) {
            this.println("descriptor: " + this.getValue(method.descriptor));
        }
        if (this.options.verbose && !this.options.compat) {
            this.writeList("flags: ", accessFlags.getMethodFlags(), "\n");
        }
        attribute = null;
        Attribute attribute2 = method.attributes.get("Code");
        if (attribute2 != null) {
            if (attribute2 instanceof Code_attribute) {
                attribute = (Code_attribute)attribute2;
            } else {
                this.report("Unexpected or invalid value for Code attribute");
            }
        }
        if (this.options.showDisassembled && !this.options.showAllAttrs && attribute != null) {
            this.println("Code:");
            this.codeWriter.writeInstrs((Code_attribute)attribute);
            this.codeWriter.writeExceptionTable((Code_attribute)attribute);
        }
        if (this.options.showLineAndLocalVariableTables && attribute != null) {
            this.attrWriter.write((Object)attribute, ((Code_attribute)attribute).attributes.get("LineNumberTable"), this.constant_pool);
            this.attrWriter.write((Object)attribute, ((Code_attribute)attribute).attributes.get("LocalVariableTable"), this.constant_pool);
        }
        if (this.options.showAllAttrs) {
            Attribute[] attributeArray;
            for (Attribute attribute3 : attributeArray = method.attributes.attrs) {
                this.attrWriter.write((Object)method, attribute3, this.constant_pool);
            }
        }
        this.indent(-1);
        this.setPendingNewline(this.options.showDisassembled || this.options.showAllAttrs || this.options.showDescriptors || this.options.showLineAndLocalVariableTables || this.options.verbose);
    }

    void writeModifiers(Collection<String> collection) {
        for (String string : collection) {
            this.print((Object)string);
            this.print(" ");
        }
    }

    void writeList(String string, Collection<?> collection, String string2) {
        this.print(string);
        String string3 = "";
        for (Object obj : collection) {
            this.print(string3);
            this.print(obj);
            string3 = ", ";
        }
        this.print(string2);
    }

    void writeListIfNotEmpty(String string, List<?> list, String string2) {
        if (list != null && list.size() > 0) {
            this.writeList(string, list, string2);
        }
    }

    Signature_attribute getSignature(Attributes attributes) {
        if (this.options.compat) {
            return null;
        }
        return (Signature_attribute)attributes.get("Signature");
    }

    String adjustVarargs(AccessFlags accessFlags, String string) {
        int n;
        if (accessFlags.is(128) && !this.options.compat && (n = string.lastIndexOf("[]")) > 0) {
            return string.substring(0, n) + "..." + string.substring(n + 2);
        }
        return string;
    }

    String getJavaName(ClassFile classFile) {
        try {
            return ClassWriter.getJavaName(classFile.getName());
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getJavaSuperclassName(ClassFile classFile) {
        try {
            return ClassWriter.getJavaName(classFile.getSuperclassName());
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getJavaInterfaceName(ClassFile classFile, int n) {
        try {
            return ClassWriter.getJavaName(classFile.getInterfaceName(n));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getJavaFieldType(Descriptor descriptor) {
        try {
            return ClassWriter.getJavaName(descriptor.getFieldType(this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            return this.report(descriptorException);
        }
    }

    String getJavaReturnType(Descriptor descriptor) {
        try {
            return ClassWriter.getJavaName(descriptor.getReturnType(this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            return this.report(descriptorException);
        }
    }

    String getJavaParameterTypes(Descriptor descriptor, AccessFlags accessFlags) {
        try {
            return ClassWriter.getJavaName(this.adjustVarargs(accessFlags, descriptor.getParameterTypes(this.constant_pool)));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            return this.report(descriptorException);
        }
    }

    String getJavaException(Exceptions_attribute exceptions_attribute, int n) {
        try {
            return ClassWriter.getJavaName(exceptions_attribute.getException(n, this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getValue(Descriptor descriptor) {
        try {
            return descriptor.getValue(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getFieldName(Field field) {
        try {
            return field.getName(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getName(Method method) {
        try {
            return method.getName(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    static String getJavaName(String string) {
        return string.replace('/', '.');
    }

    String getSourceFile(SourceFile_attribute sourceFile_attribute) {
        try {
            return sourceFile_attribute.getSourceFile(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getConstantValue(Descriptor descriptor, int n) {
        try {
            ConstantPool.CPInfo cPInfo = this.constant_pool.get(n);
            switch (cPInfo.getTag()) {
                case 3: {
                    ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info = (ConstantPool.CONSTANT_Integer_info)cPInfo;
                    String string = descriptor.getValue(this.constant_pool);
                    if (string.equals("C")) {
                        return this.getConstantCharValue((char)cONSTANT_Integer_info.value);
                    }
                    if (string.equals("Z")) {
                        return String.valueOf(cONSTANT_Integer_info.value == 1);
                    }
                    return String.valueOf(cONSTANT_Integer_info.value);
                }
                case 8: {
                    ConstantPool.CONSTANT_String_info cONSTANT_String_info = (ConstantPool.CONSTANT_String_info)cPInfo;
                    return this.getConstantStringValue(cONSTANT_String_info.getString());
                }
            }
            return this.constantWriter.stringValue(cPInfo);
        }
        catch (ConstantPoolException constantPoolException) {
            return "#" + n;
        }
    }

    private String getConstantCharValue(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\'');
        stringBuilder.append(this.esc(c, '\''));
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private String getConstantStringValue(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(this.esc(string.charAt(i), '\"'));
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private String esc(char c, char c2) {
        if (' ' <= c && c <= '~' && c != c2) {
            return String.valueOf(c);
        }
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
        }
        return String.format("\\u%04x", c);
    }

    class JavaTypePrinter
    implements Type.Visitor<StringBuilder, StringBuilder> {
        boolean isInterface;

        JavaTypePrinter(boolean bl) {
            this.isInterface = bl;
        }

        String print(Type type) {
            return type.accept(this, new StringBuilder()).toString();
        }

        String printTypeArgs(List<? extends Type.TypeParamType> list) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendIfNotEmpty(stringBuilder, "<", list, "> ");
            return stringBuilder.toString();
        }

        @Override
        public StringBuilder visitSimpleType(Type.SimpleType simpleType, StringBuilder stringBuilder) {
            stringBuilder.append(ClassWriter.getJavaName(simpleType.name));
            return stringBuilder;
        }

        @Override
        public StringBuilder visitArrayType(Type.ArrayType arrayType, StringBuilder stringBuilder) {
            this.append(stringBuilder, arrayType.elemType);
            stringBuilder.append("[]");
            return stringBuilder;
        }

        @Override
        public StringBuilder visitMethodType(Type.MethodType methodType, StringBuilder stringBuilder) {
            this.appendIfNotEmpty(stringBuilder, "<", methodType.typeParamTypes, "> ");
            this.append(stringBuilder, methodType.returnType);
            this.append(stringBuilder, " (", methodType.paramTypes, ")");
            this.appendIfNotEmpty(stringBuilder, " throws ", methodType.throwsTypes, "");
            return stringBuilder;
        }

        @Override
        public StringBuilder visitClassSigType(Type.ClassSigType classSigType, StringBuilder stringBuilder) {
            this.appendIfNotEmpty(stringBuilder, "<", classSigType.typeParamTypes, ">");
            if (this.isInterface) {
                this.appendIfNotEmpty(stringBuilder, " extends ", classSigType.superinterfaceTypes, "");
            } else {
                if (classSigType.superclassType != null && (((ClassWriter)ClassWriter.this).options.verbose || !classSigType.superclassType.isObject())) {
                    stringBuilder.append(" extends ");
                    this.append(stringBuilder, classSigType.superclassType);
                }
                this.appendIfNotEmpty(stringBuilder, " implements ", classSigType.superinterfaceTypes, "");
            }
            return stringBuilder;
        }

        @Override
        public StringBuilder visitClassType(Type.ClassType classType, StringBuilder stringBuilder) {
            if (classType.outerType != null) {
                this.append(stringBuilder, classType.outerType);
                stringBuilder.append(".");
            }
            stringBuilder.append(ClassWriter.getJavaName(classType.name));
            this.appendIfNotEmpty(stringBuilder, "<", classType.typeArgs, ">");
            return stringBuilder;
        }

        @Override
        public StringBuilder visitTypeParamType(Type.TypeParamType typeParamType, StringBuilder stringBuilder) {
            stringBuilder.append(typeParamType.name);
            String string = " extends ";
            if (typeParamType.classBound != null && (((ClassWriter)ClassWriter.this).options.verbose || !typeParamType.classBound.isObject())) {
                stringBuilder.append(string);
                this.append(stringBuilder, typeParamType.classBound);
                string = " & ";
            }
            if (typeParamType.interfaceBounds != null) {
                for (Type type : typeParamType.interfaceBounds) {
                    stringBuilder.append(string);
                    this.append(stringBuilder, type);
                    string = " & ";
                }
            }
            return stringBuilder;
        }

        @Override
        public StringBuilder visitWildcardType(Type.WildcardType wildcardType, StringBuilder stringBuilder) {
            switch (wildcardType.kind) {
                case UNBOUNDED: {
                    stringBuilder.append("?");
                    break;
                }
                case EXTENDS: {
                    stringBuilder.append("? extends ");
                    this.append(stringBuilder, wildcardType.boundType);
                    break;
                }
                case SUPER: {
                    stringBuilder.append("? super ");
                    this.append(stringBuilder, wildcardType.boundType);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return stringBuilder;
        }

        private void append(StringBuilder stringBuilder, Type type) {
            type.accept(this, stringBuilder);
        }

        private void append(StringBuilder stringBuilder, String string, List<? extends Type> list, String string2) {
            stringBuilder.append(string);
            String string3 = "";
            for (Type type : list) {
                stringBuilder.append(string3);
                this.append(stringBuilder, type);
                string3 = ", ";
            }
            stringBuilder.append(string2);
        }

        private void appendIfNotEmpty(StringBuilder stringBuilder, String string, List<? extends Type> list, String string2) {
            if (!this.isEmpty(list)) {
                this.append(stringBuilder, string, list, string2);
            }
        }

        private boolean isEmpty(List<? extends Type> list) {
            return list == null || list.isEmpty();
        }
    }
}

