/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javadoc.ModifierFilter;
import java.util.StringTokenizer;

public enum ToolOption {
    BOOTCLASSPATH("-bootclasspath", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    CLASSPATH("-classpath", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    CP("-cp", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    EXTDIRS("-extdirs", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    SOURCEPATH("-sourcepath", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    SYSCLASSPATH("-sysclasspath", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt("-bootclasspath", string);
        }
    }
    ,
    ENCODING("-encoding", true){

        @Override
        public void process(Helper helper, String string) {
            helper.encoding = string;
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    SOURCE("-source", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    XMAXERRS("-Xmaxerrs", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    XMAXWARNS("-Xmaxwarns", true){

        @Override
        public void process(Helper helper, String string) {
            helper.setCompilerOpt(this.opt, string);
        }
    }
    ,
    DOCLET("-doclet", true),
    DOCLETPATH("-docletpath", true),
    SUBPACKAGES("-subpackages", true){

        @Override
        public void process(Helper helper, String string) {
            helper.addToList(helper.subPackages, string);
        }
    }
    ,
    EXCLUDE("-exclude", true){

        @Override
        public void process(Helper helper, String string) {
            helper.addToList(helper.excludedPackages, string);
        }
    }
    ,
    PACKAGE("-package"){

        @Override
        public void process(Helper helper) {
            helper.setFilter(-9223372036854775803L);
        }
    }
    ,
    PRIVATE("-private"){

        @Override
        public void process(Helper helper) {
            helper.setFilter(-9223372036854775801L);
        }
    }
    ,
    PROTECTED("-protected"){

        @Override
        public void process(Helper helper) {
            helper.setFilter(5L);
        }
    }
    ,
    PUBLIC("-public"){

        @Override
        public void process(Helper helper) {
            helper.setFilter(1L);
        }
    }
    ,
    PROMPT("-prompt"){

        @Override
        public void process(Helper helper) {
            helper.compOpts.put("-prompt", "-prompt");
            helper.promptOnError = true;
        }
    }
    ,
    QUIET("-quiet"){

        @Override
        public void process(Helper helper) {
            helper.quiet = true;
        }
    }
    ,
    VERBOSE("-verbose"){

        @Override
        public void process(Helper helper) {
            helper.compOpts.put("-verbose", "");
        }
    }
    ,
    XWERROR("-Xwerror"){

        @Override
        public void process(Helper helper) {
            helper.rejectWarnings = true;
        }
    }
    ,
    BREAKITERATOR("-breakiterator"){

        @Override
        public void process(Helper helper) {
            helper.breakiterator = true;
        }
    }
    ,
    LOCALE("-locale", true){

        @Override
        public void process(Helper helper, String string) {
            helper.docLocale = string;
        }
    }
    ,
    OVERVIEW("-overview", true),
    XCLASSES("-Xclasses"){

        @Override
        public void process(Helper helper) {
            helper.docClasses = true;
        }
    }
    ,
    HELP("-help"){

        @Override
        public void process(Helper helper) {
            helper.usage();
        }
    }
    ,
    X("-X"){

        @Override
        public void process(Helper helper) {
            helper.Xusage();
        }
    };

    public final String opt;
    public final boolean hasArg;

    private ToolOption(String string2) {
        this(string2, false);
    }

    private ToolOption(String string2, boolean bl) {
        this.opt = string2;
        this.hasArg = bl;
    }

    void process(Helper helper, String string) {
    }

    void process(Helper helper) {
    }

    static ToolOption get(String string) {
        for (ToolOption toolOption : ToolOption.values()) {
            if (!string.equals(toolOption.opt)) continue;
            return toolOption;
        }
        return null;
    }

    static abstract class Helper {
        final ListBuffer<String[]> options = new ListBuffer();
        final ListBuffer<String> subPackages = new ListBuffer();
        final ListBuffer<String> excludedPackages = new ListBuffer();
        Options compOpts;
        String encoding = null;
        boolean breakiterator = false;
        boolean quiet = false;
        boolean docClasses = false;
        boolean rejectWarnings = false;
        boolean promptOnError;
        String docLocale = "";
        ModifierFilter showAccess = null;

        Helper() {
        }

        abstract void usage();

        abstract void Xusage();

        abstract void usageError(String var1, Object ... var2);

        protected void addToList(ListBuffer<String> listBuffer, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                listBuffer.append(string2);
            }
        }

        protected void setFilter(long l) {
            if (this.showAccess != null) {
                this.usageError("main.incompatible.access.flags", new Object[0]);
            }
            this.showAccess = new ModifierFilter(l);
        }

        private void setCompilerOpt(String string, String string2) {
            if (this.compOpts.get(string) != null) {
                this.usageError("main.option.already.seen", string);
            }
            this.compOpts.put(string, string2);
        }
    }
}

